/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.quasiliteral;

import com.google.caja.parser.quasiliteral.CajitaRewriter;
import com.google.caja.parser.quasiliteral.RuleDescription;
import com.google.caja.parser.quasiliteral.RuleDoclet;
import com.google.caja.parser.quasiliteral.RulesetDescription;
import com.google.caja.reporting.BuildInfo;
import com.google.caja.reporting.DevNullMessageQueue;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Date;

public class TextRuleDoclet
extends RuleDoclet {
    public String getDefaultExtension() {
        return "txt";
    }

    public void generateHeader(Writer output, RulesetDescription ruleSet) throws IOException {
        output.write("Rules for " + ruleSet.name() + "\n");
        output.write(ruleSet.synopsis() + "\n");
    }

    public void generateFooter(Writer output, RulesetDescription ruleSet) throws IOException {
        output.write("Generated " + new Date());
    }

    public void generateRuleDocumentation(Writer output, RuleDescription anno) throws IOException {
        output.write("  Rule: " + anno.name());
        output.write("\n  Synopsis: " + anno.synopsis());
        output.write("\n  Reason: " + anno.reason());
        output.write("\n  Matches: " + anno.matches());
        output.write("\n  Substitutes: " + anno.substitutes());
        output.append("\n\n");
    }

    public void finish(Writer out) {
    }

    public static void main(String[] args) throws IOException {
        TextRuleDoclet trd = new TextRuleDoclet();
        trd.setRewriter(new CajitaRewriter(BuildInfo.getInstance(), DevNullMessageQueue.singleton(), false));
        trd.generateDocumentation(new OutputStreamWriter(System.out));
    }
}

