/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.ancillary.linter;

import com.google.caja.ancillary.linter.LiveSet;
import com.google.caja.lexer.FilePosition;
import com.google.caja.parser.js.BreakStmt;
import com.google.caja.parser.js.ContinueStmt;
import com.google.caja.parser.js.ReturnStmt;
import com.google.caja.parser.js.Statement;
import com.google.caja.parser.js.ThrowStmt;
import com.google.caja.util.Lists;
import com.google.caja.util.Maps;
import com.google.caja.util.Sets;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ExitModes {
    static final ExitModes COMPLETES = new ExitModes(Collections.<String, ExitMode>emptyMap(), true);
    private final Map<String, ExitMode> exits;
    private final boolean completes;

    private ExitModes(Map<String, ExitMode> exits, boolean completes) {
        this.exits = exits;
        this.completes = completes;
    }

    boolean returns() {
        return this.returnsNormally() || this.returnsAbruptly();
    }

    boolean returnsNormally() {
        return this.hasAlwaysKey("r");
    }

    boolean returnsAbruptly() {
        return this.hasAlwaysKey("t");
    }

    ExitMode atThrow() {
        return this.exits.get("t");
    }

    boolean breaksToLabel(String label) {
        return this.hasAlwaysKey(this.prefix("b", label));
    }

    ExitMode atBreak(String label) {
        return this.exits.get(this.prefix("b", label));
    }

    boolean continuesToLabel(String label) {
        return this.hasAlwaysKey(this.prefix("b", label));
    }

    ExitMode atContinue(String label) {
        return this.exits.get(this.prefix("c", label));
    }

    boolean completes() {
        return this.completes;
    }

    Set<Statement> liveExits() {
        List<Statement> stmts = Lists.newArrayList();
        for (ExitMode em : this.exits.values()) {
            stmts.addAll(em.sources);
        }
        Collections.sort(stmts, new Comparator<Statement>(){

            @Override
            public int compare(Statement a, Statement b) {
                FilePosition pa = a.getFilePosition();
                FilePosition pb = b.getFilePosition();
                int delta = pa.source().toString().compareTo(pb.source().toString());
                if (delta != 0) {
                    return delta;
                }
                return pa.startCharInFile() - pb.startCharInFile();
            }
        });
        return Collections.unmodifiableSet(Sets.newLinkedHashSet(stmts));
    }

    private boolean hasAlwaysKey(String key) {
        ExitMode em = this.exits.get(key);
        return em != null && em.always;
    }

    ExitModes withBreak(BreakStmt s, LiveSet atBreak) {
        return this.withEntry(this.prefix("b", s.getLabel()), atBreak, s);
    }

    ExitModes withContinue(ContinueStmt s, LiveSet atContinue) {
        return this.withEntry(this.prefix("c", s.getLabel()), atContinue, s);
    }

    ExitModes withNormalReturn(ReturnStmt s, LiveSet atReturn) {
        return this.withEntry("r", atReturn, s);
    }

    ExitModes withAbruptReturn(ThrowStmt t, LiveSet atThrow) {
        return this.withEntry("t", atThrow, t);
    }

    ExitModes withoutBreak(String label) {
        return this.withoutEntry(this.prefix("b", label), true);
    }

    ExitModes withoutBreakOrContinue(String label) {
        String b = this.prefix("b", label);
        String c = this.prefix("c", label);
        int count = (this.exits.containsKey(b) ? 1 : 0) + (this.exits.containsKey(c) ? 1 : 0);
        if (count == this.exits.size()) {
            return COMPLETES;
        }
        Map<String, ExitMode> exits = Maps.newLinkedHashMap(this.exits);
        boolean completes = exits.remove(b) != null | this.completes;
        exits.remove(c);
        return new ExitModes(exits, completes);
    }

    ExitModes withoutAbruptReturn() {
        return this.withoutEntry("t", true);
    }

    ExitModes intersection(ExitModes m) {
        return this.join(this, m, false);
    }

    ExitModes union(ExitModes m) {
        return this.join(this, m, true);
    }

    private ExitModes join(ExitModes a, ExitModes b, boolean unioning) {
        boolean same;
        if (a == b) {
            return a;
        }
        if (unioning) {
            if (a.exits.isEmpty()) {
                return b;
            }
            if (b.exits.isEmpty()) {
                return a;
            }
        }
        if (a.exits.size() >= b.exits.size()) {
            ExitModes tmp = a;
            a = b;
            b = tmp;
        }
        Map<String, ExitMode> exits = Maps.newLinkedHashMap(a.exits);
        exits.putAll(b.exits);
        boolean bl = same = exits.size() == a.exits.size();
        if (unioning) {
            for (Map.Entry<String, ExitMode> e : b.exits.entrySet()) {
                ExitMode combined;
                String k = e.getKey();
                ExitMode orig = a.exits.get(k);
                if (orig == null || (combined = orig.combine(e.getValue(), true)) == e.getValue()) continue;
                exits.put(k, combined);
                same = false;
            }
        } else {
            for (Map.Entry<String, ExitMode> e : exits.entrySet()) {
                String k = e.getKey();
                ExitMode bEl = b.exits.get(k);
                if (bEl == null) {
                    if (!e.getValue().always || !b.completes) continue;
                    e.setValue(e.getValue().sometimes());
                    same = false;
                    continue;
                }
                ExitMode aEl = a.exits.get(k);
                ExitMode combined = aEl != null ? aEl.combine(bEl, false) : (a.completes ? bEl.sometimes() : bEl);
                if (combined == aEl) continue;
                e.setValue(combined);
                same = false;
            }
        }
        boolean completes = unioning ? a.completes && b.completes : a.completes || b.completes;
        return (same &= completes == a.completes) ? a : new ExitModes(exits, completes);
    }

    private String prefix(String prefix, String suffix) {
        if (suffix == null) {
            throw new NullPointerException();
        }
        if ("".equals(suffix)) {
            return prefix;
        }
        return prefix + suffix;
    }

    private ExitModes withEntry(String e, LiveSet vars, Statement source) {
        ExitMode em = new ExitMode(vars, true, Collections.singleton(source));
        ExitMode orig = this.exits.get(e);
        if (orig != null) {
            ExitMode inter = orig.combine(em, false);
            if (inter == orig) {
                return this;
            }
            em = inter;
        }
        Map<String, ExitMode> exits = Maps.newLinkedHashMap(this.exits);
        exits.put(e, em);
        return new ExitModes(exits, false);
    }

    private ExitModes withoutEntry(String e, boolean completes) {
        if (!this.exits.containsKey(e)) {
            return this;
        }
        if (this.exits.size() == 1) {
            return COMPLETES;
        }
        Map<String, ExitMode> exits = Maps.newLinkedHashMap(this.exits);
        exits.remove(e);
        return new ExitModes(exits, completes || this.completes);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ExitModes)) {
            return false;
        }
        return ((Object)this.exits).equals(((ExitModes)o).exits);
    }

    public int hashCode() {
        return ((Object)this.exits).hashCode();
    }

    public String toString() {
        return this.exits.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ExitMode {
        final LiveSet vars;
        final boolean always;
        final Set<Statement> sources;

        private ExitMode(LiveSet vars, boolean always, Set<Statement> sources) {
            this.vars = vars;
            this.always = always;
            this.sources = sources;
        }

        private ExitMode combine(ExitMode other, boolean orAlways) {
            boolean always;
            LiveSet inter = this.vars.intersection(other.vars);
            boolean bl = orAlways ? this.always || other.always : (always = this.always && other.always);
            if (inter == this.vars && always == this.always) {
                return this;
            }
            if (inter == other.vars && always == other.always) {
                return other;
            }
            Set<Statement> allSources = Sets.newHashSet(this.sources);
            allSources.addAll(other.sources);
            return new ExitMode(inter, always, allSources);
        }

        private ExitMode sometimes() {
            return this.always ? new ExitMode(this.vars, false, this.sources) : this;
        }

        public int hashCode() {
            return this.vars.hashCode() ^ (this.always ? 1 : 0);
        }

        public boolean equals(Object o) {
            if (!(o instanceof ExitMode)) {
                return false;
            }
            ExitMode that = (ExitMode)o;
            return this.vars.equals(that.vars) && this.always == that.always;
        }

        public String toString() {
            return "(" + this.vars + (this.always ? " always" : "") + ")";
        }
    }
}

