/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.htmlparser.impl;

import java.io.IOException;
import nu.validator.htmlparser.impl.ByteReadable;
import nu.validator.htmlparser.impl.Encoding;

public final class BomSniffer {
    private final ByteReadable source;

    public BomSniffer(ByteReadable source) {
        this.source = source;
    }

    Encoding sniff() throws IOException {
        int b = this.source.readByte();
        if (b == 239) {
            b = this.source.readByte();
            if (b == 187) {
                b = this.source.readByte();
                if (b == 191) {
                    return Encoding.UTF8;
                }
                return null;
            }
            return null;
        }
        if (b == 255) {
            b = this.source.readByte();
            if (b == 254) {
                return Encoding.UTF16LE;
            }
            return null;
        }
        if (b == 254) {
            b = this.source.readByte();
            if (b == 255) {
                return Encoding.UTF16BE;
            }
            return null;
        }
        return null;
    }
}

