/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.web.filter.authc;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsecurity.authc.AuthenticationException;
import org.jsecurity.authc.AuthenticationToken;
import org.jsecurity.subject.Subject;
import org.jsecurity.web.WebUtils;
import org.jsecurity.web.filter.authc.AuthenticatingFilter;

public class FormAuthenticationFilter
extends AuthenticatingFilter {
    public static final String DEFAULT_ERROR_KEY_ATTRIBUTE_NAME = "jsecLoginFailure";
    public static final String DEFAULT_USERNAME_PARAM = "username";
    public static final String DEFAULT_PASSWORD_PARAM = "password";
    public static final String DEFAULT_REMEMBER_ME_PARAM = "rememberMe";
    private static final Log log = LogFactory.getLog(FormAuthenticationFilter.class);
    private String usernameParam = "username";
    private String passwordParam = "password";
    private String rememberMeParam = "rememberMe";
    private String failureKeyAttribute = "jsecLoginFailure";

    public FormAuthenticationFilter() {
        this.setLoginUrl("/login.jsp");
    }

    public String getUsernameParam() {
        return this.usernameParam;
    }

    public void setUsernameParam(String usernameParam) {
        this.usernameParam = usernameParam;
    }

    public String getPasswordParam() {
        return this.passwordParam;
    }

    public void setPasswordParam(String passwordParam) {
        this.passwordParam = passwordParam;
    }

    public String getRememberMeParam() {
        return this.rememberMeParam;
    }

    public void setRememberMeParam(String rememberMeParam) {
        this.rememberMeParam = rememberMeParam;
    }

    public String getFailureKeyAttribute() {
        return this.failureKeyAttribute;
    }

    public void setFailureKeyAttribute(String failureKeyAttribute) {
        this.failureKeyAttribute = failureKeyAttribute;
    }

    protected void onFilterConfigSet() throws Exception {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Adding default login url to applied paths.");
        }
        this.appliedPaths.put(this.getLoginUrl(), null);
    }

    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws Exception {
        if (this.isLoginRequest(request, response)) {
            if (this.isLoginSubmission(request, response)) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"Login submission detected.  Attempting to execute login.");
                }
                return this.executeLogin(request, response);
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)"Login page view.");
            }
            return true;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Attempting to access a path which requires authentication.  Forwarding to the Authentication url [" + this.getLoginUrl() + "]"));
        }
        this.saveRequestAndRedirectToLogin(request, response);
        return false;
    }

    protected boolean isLoginSubmission(ServletRequest request, ServletResponse response) {
        return request instanceof HttpServletRequest && WebUtils.toHttp(request).getMethod().equalsIgnoreCase("POST");
    }

    protected AuthenticationToken createToken(ServletRequest request, ServletResponse response) {
        String username = this.getUsername(request);
        String password = this.getPassword(request);
        return this.createToken(username, password, request, response);
    }

    protected boolean isRememberMe(ServletRequest request) {
        return WebUtils.isTrue(request, this.getRememberMeParam());
    }

    protected boolean onLoginSuccess(AuthenticationToken token, Subject subject, ServletRequest request, ServletResponse response) throws Exception {
        this.issueSuccessRedirect(request, response);
        return false;
    }

    protected boolean onLoginFailure(AuthenticationToken token, AuthenticationException e, ServletRequest request, ServletResponse response) {
        this.setFailureAttribute(request, e);
        return true;
    }

    protected void setFailureAttribute(ServletRequest request, AuthenticationException ae) {
        String className = ae.getClass().getName();
        request.setAttribute(this.getFailureKeyAttribute(), (Object)className);
    }

    protected String getUsername(ServletRequest request) {
        return WebUtils.getCleanParam(request, this.getUsernameParam());
    }

    protected String getPassword(ServletRequest request) {
        return WebUtils.getCleanParam(request, this.getPasswordParam());
    }
}

