/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.cache;

import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jsecurity.cache.Cache;
import org.jsecurity.cache.CacheException;

public class HashtableCache
implements Cache {
    private final Map hashtable = new Hashtable();
    private final String name;

    public HashtableCache(String name) {
        this.name = name;
    }

    public Object get(Object key) throws CacheException {
        return this.hashtable.get(key);
    }

    public void put(Object key, Object value) throws CacheException {
        this.hashtable.put(key, value);
    }

    public void remove(Object key) throws CacheException {
        this.hashtable.remove(key);
    }

    public void clear() throws CacheException {
        this.hashtable.clear();
    }

    public int size() {
        return this.hashtable.size();
    }

    public Set keys() {
        if (!this.hashtable.isEmpty()) {
            return Collections.unmodifiableSet(this.hashtable.keySet());
        }
        return Collections.EMPTY_SET;
    }

    public Set values() {
        if (!this.hashtable.isEmpty()) {
            Collection values = this.hashtable.values();
            if (values instanceof Set) {
                return Collections.unmodifiableSet((Set)values);
            }
            return Collections.unmodifiableSet(new LinkedHashSet(values));
        }
        return Collections.EMPTY_SET;
    }

    public String toString() {
        return "HashtableCache [" + this.name + "]";
    }
}

