/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.aop;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.jsecurity.aop.AnnotationHandler;
import org.jsecurity.aop.MethodInterceptorSupport;
import org.jsecurity.aop.MethodInvocation;

public abstract class AnnotationMethodInterceptor
extends MethodInterceptorSupport {
    private AnnotationHandler handler;

    public AnnotationMethodInterceptor(AnnotationHandler handler) {
        this.setHandler(handler);
    }

    public AnnotationHandler getHandler() {
        return this.handler;
    }

    public void setHandler(AnnotationHandler handler) {
        this.handler = handler;
    }

    public boolean supports(MethodInvocation mi) {
        return this.getAnnotation(mi) != null;
    }

    protected Annotation getAnnotation(MethodInvocation mi) throws IllegalArgumentException {
        if (mi == null) {
            throw new IllegalArgumentException("method argument cannot be null");
        }
        Method m = mi.getMethod();
        if (m == null) {
            String msg = MethodInvocation.class.getName() + " parameter incorrectly " + "constructed.  getMethod() returned null";
            throw new IllegalArgumentException(msg);
        }
        return m.getAnnotation(this.getHandler().getAnnotationClass());
    }
}

