/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.annotations.repository.core;

import java.net.URI;
import java.security.Principal;
import java.util.List;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.annotations.api.Annotation;
import org.nuxeo.ecm.platform.annotations.api.AnnotationException;
import org.nuxeo.ecm.platform.annotations.repository.DefaultNuxeoUriResolver;
import org.nuxeo.ecm.platform.annotations.repository.service.AnnotatedDocumentEventListener;
import org.nuxeo.ecm.platform.annotations.repository.service.AnnotationsRepositoryConfigurationService;
import org.nuxeo.ecm.platform.annotations.service.EventListener;
import org.nuxeo.runtime.api.Framework;

public class AnnotationEventListener
implements EventListener {
    private List<AnnotatedDocumentEventListener> listeners;
    private final DefaultNuxeoUriResolver resolver = new DefaultNuxeoUriResolver();

    public void afterAnnotationCreated(Principal principal, Annotation annotation) throws AnnotationException {
        for (AnnotatedDocumentEventListener listener : this.getListeners()) {
            listener.afterAnnotationCreated((NuxeoPrincipal)principal, this.getDocumentLocation(annotation), annotation);
        }
    }

    private DocumentLocation getDocumentLocation(Annotation annotation) throws AnnotationException {
        URI annotates = annotation.getAnnotates();
        return this.resolver.getDocumentLocation(annotates);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AnnotatedDocumentEventListener> getListeners() throws AnnotationException {
        if (this.listeners == null) {
            AnnotationEventListener annotationEventListener = this;
            synchronized (annotationEventListener) {
                AnnotationsRepositoryConfigurationService service;
                try {
                    service = (AnnotationsRepositoryConfigurationService)Framework.getService(AnnotationsRepositoryConfigurationService.class);
                }
                catch (Exception e) {
                    throw new AnnotationException((Throwable)e);
                }
                this.listeners = service.getEventListeners();
            }
        }
        return this.listeners;
    }

    public void afterAnnotationDeleted(Principal principal, Annotation annotation) throws AnnotationException {
        for (AnnotatedDocumentEventListener listener : this.getListeners()) {
            listener.afterAnnotationDeleted((NuxeoPrincipal)principal, this.getDocumentLocation(annotation), annotation);
        }
    }

    public void afterAnnotationRead(Principal principal, Annotation annotation) throws AnnotationException {
        for (AnnotatedDocumentEventListener listener : this.getListeners()) {
            listener.afterAnnotationRead((NuxeoPrincipal)principal, this.getDocumentLocation(annotation), annotation);
        }
    }

    public void afterAnnotationUpdated(Principal principal, Annotation annotation) throws AnnotationException {
        for (AnnotatedDocumentEventListener listener : this.getListeners()) {
            listener.afterAnnotationUpdated((NuxeoPrincipal)principal, this.getDocumentLocation(annotation), annotation);
        }
    }

    public void beforeAnnotationCreated(Principal principal, Annotation annotation) throws AnnotationException {
        for (AnnotatedDocumentEventListener listener : this.getListeners()) {
            listener.beforeAnnotationCreated((NuxeoPrincipal)principal, this.getDocumentLocation(annotation), annotation);
        }
    }

    public void beforeAnnotationDeleted(Principal principal, Annotation annotation) throws AnnotationException {
        for (AnnotatedDocumentEventListener listener : this.getListeners()) {
            listener.beforeAnnotationDeleted((NuxeoPrincipal)principal, this.getDocumentLocation(annotation), annotation);
        }
    }

    public void beforeAnnotationRead(Principal principal, String annotationId) throws AnnotationException {
        for (AnnotatedDocumentEventListener listener : this.getListeners()) {
            listener.beforeAnnotationRead((NuxeoPrincipal)principal, annotationId);
        }
    }

    public void beforeAnnotationUpdated(Principal principal, Annotation annotation) throws AnnotationException {
        for (AnnotatedDocumentEventListener listener : this.getListeners()) {
            listener.beforeAnnotationUpdated((NuxeoPrincipal)principal, this.getDocumentLocation(annotation), annotation);
        }
    }
}

