/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.image.op;

import it.tidalwave.image.EditableImage;
import it.tidalwave.image.java2d.ImplementationFactoryJ2D;
import it.tidalwave.image.java2d.Java2DUtils;
import it.tidalwave.image.op.Operation;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public class ReadOp
extends Operation {
    private static final String CLASS = ReadOp.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);
    private static final Set<String> unwantedPlugins = new HashSet<String>();
    private final Object input;
    private final Type type;
    private final int imageIndex;
    private final int thumbnailIndex;

    public ReadOp(Object input) {
        this(input, Type.IMAGE, 0, 0);
    }

    public ReadOp(Object input, Type type) {
        this(input, type, 0, 0);
    }

    public ReadOp(Object input, Type type, int imageIndex) {
        this(input, type, imageIndex, 0);
    }

    public ReadOp(Object input, Type type, int imageIndex, int thumbnailIndex) {
        if (input == null) {
            throw new IllegalArgumentException("null input");
        }
        if (type == null) {
            throw new IllegalArgumentException("Type is mandatory");
        }
        this.input = input;
        this.type = type;
        this.imageIndex = imageIndex;
        this.thumbnailIndex = thumbnailIndex;
    }

    public Object getInput() {
        return this.input;
    }

    public int getImageIndex() {
        return this.imageIndex;
    }

    public int getThumbnailIndex() {
        return this.thumbnailIndex;
    }

    public EditableImage execute() throws IOException {
        return this.type.read(this);
    }

    public static ImageReader createImageReader(File file) throws FileNotFoundException, IOException {
        int i;
        logger.fine("getImageReader(" + file + ")");
        if (!file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        if (!file.canRead()) {
            throw new IOException("Cannot read " + file.getAbsolutePath());
        }
        String fileName = file.getName();
        String suffix = "";
        boolean gzipCompression = fileName.toLowerCase().endsWith(".gz");
        if (gzipCompression) {
            fileName = fileName.substring(0, fileName.length() - 3);
        }
        if ((i = fileName.lastIndexOf(46)) > 0) {
            suffix = fileName.substring(i + 1);
        }
        logger.finer(">>>> suffix is " + suffix);
        ImageInputStream imageInputStream = null;
        try {
            if (!gzipCompression) {
                imageInputStream = ImageIO.createImageInputStream(file);
            } else {
                GZIPInputStream inputStream = new GZIPInputStream(new FileInputStream(file));
                imageInputStream = ImageIO.createImageInputStream(inputStream);
            }
            return ReadOp.createImageReader(imageInputStream, gzipCompression, suffix);
        }
        catch (IOException e) {
            logger.throwing(CLASS, "getImageReader()", e);
            ReadOp.safeClose(imageInputStream);
            throw e;
        }
    }

    public static ImageReader createImageReader(URL url) throws IOException {
        logger.fine("getImageReader(" + url + ")");
        String fileName = url.getPath();
        String suffix = "";
        boolean gzipCompression = fileName.toLowerCase().endsWith(".gz");
        int i = fileName.lastIndexOf(46);
        if (i > 0) {
            suffix = fileName.substring(i + 1);
        }
        logger.finer(">>>> suffix is " + suffix);
        ImageInputStream imageInputStream = null;
        try {
            InputStream inputStream = gzipCompression ? new GZIPInputStream(url.openStream()) : url.openStream();
            imageInputStream = ImageIO.createImageInputStream(inputStream);
            return ReadOp.createImageReader(imageInputStream, gzipCompression, suffix);
        }
        catch (IOException e) {
            logger.throwing(CLASS, "getImageReader()", e);
            ReadOp.safeClose(imageInputStream);
            throw e;
        }
    }

    private static ImageReader createImageReader(InputStream inputStream) throws IOException {
        ImageInputStream iis = ImageIO.createImageInputStream(inputStream);
        Iterator<ImageReader> i = ImageIO.getImageReaders(iis);
        if (!i.hasNext()) {
            throw new IOException("Cannot read from the inputstream");
        }
        ImageReader imageReader = i.next();
        imageReader.setInput(iis);
        return imageReader;
    }

    private static ImageReader createImageReader(ImageInputStream imageInputStream, boolean gzipCompression, String suffix) throws IOException {
        try {
            Iterator<ImageReader> iterator = ImageIO.getImageReadersBySuffix(suffix);
            while (iterator.hasNext()) {
                ImageReader reader = iterator.next();
                String pluginClassName = reader.getOriginatingProvider().getPluginClassName();
                logger.finer(">>>> testing reader: " + reader + ", pluginClassName: " + pluginClassName);
                if (reader == null || unwantedPlugins.contains(pluginClassName) || !reader.getOriginatingProvider().canDecodeInput(imageInputStream)) continue;
                reader.setInput(imageInputStream);
                logger.finer(">>>> returning reader: " + reader + ", pluginClassName: " + pluginClassName);
                return reader;
            }
            throw new IOException("No ImageReader for the suffix: " + suffix);
        }
        catch (IOException e) {
            logger.throwing(CLASS, "getImageReader()", e);
            logger.finer(">>>> returning null");
            ReadOp.safeClose(imageInputStream);
            throw e;
        }
    }

    private static void safeClose(ImageInputStream imageInputStream) {
        try {
            if (imageInputStream != null) {
                imageInputStream.close();
            }
        }
        catch (IOException e) {
            logger.throwing(CLASS, "safeClose()", e);
        }
    }

    public String toString() {
        return "ReadOp(" + this.input + ", " + this.imageIndex + ", " + this.thumbnailIndex + ")";
    }

    static {
        unwantedPlugins.add("com.sun.media.imageioimpl.plugins.jpeg.CLibJPEGImageReader");
        unwantedPlugins.add("com.sun.media.imageioimpl.plugins.jpeg.CLibJPEGImageWriter");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        IMAGE{

            protected EditableImage read(ReadOp readOp) throws IOException {
                Object input = readOp.getInput();
                final int imageIndex = readOp.getImageIndex();
                logger.info("read(" + input + ", " + imageIndex + ")");
                return Reader.read(input, new Reader(){

                    protected EditableImage read(ImageReader imageReader) throws IOException {
                        long time = System.currentTimeMillis();
                        BufferedImage image = imageReader.read(imageIndex);
                        EditableImage editableImage = Type.create(image);
                        editableImage.loadDirectories(imageReader, imageIndex);
                        Java2DUtils.logImage(logger, ">>>> Loaded image: ", image);
                        editableImage.latestOperationTime = System.currentTimeMillis() - time;
                        return editableImage;
                    }
                });
            }
        }
        ,
        THUMBNAIL{

            protected EditableImage read(ReadOp readOp) throws IOException {
                Object input = readOp.getInput();
                final int imageIndex = readOp.getImageIndex();
                final int thumbnailIndex = readOp.getThumbnailIndex();
                logger.info("readThumbnail(" + input + ", " + imageIndex + ", " + thumbnailIndex + ")");
                return Reader.read(input, new Reader(){

                    protected EditableImage read(ImageReader imageReader) throws IOException {
                        long time = System.currentTimeMillis();
                        return Type.create(imageReader.readThumbnail(imageIndex, thumbnailIndex), System.currentTimeMillis() - time);
                    }
                });
            }
        }
        ,
        METADATA{

            protected EditableImage read(ReadOp readOp) throws IOException {
                Object input = readOp.getInput();
                final int imageIndex = readOp.getImageIndex();
                logger.info("readMetadata(" + input + ", " + imageIndex + ")");
                return Reader.read(input, new Reader(){

                    protected EditableImage read(ImageReader imageReader) throws IOException {
                        EditableImage editableImage = new EditableImage(null);
                        editableImage.loadDirectories(imageReader, imageIndex);
                        return editableImage;
                    }
                });
            }
        };


        protected abstract EditableImage read(ReadOp var1) throws IOException;

        private static EditableImage create(BufferedImage image) {
            return new EditableImage(ImplementationFactoryJ2D.getInstance().createImageModel(image));
        }

        private static EditableImage create(BufferedImage image, long time) {
            EditableImage editableImage = Type.create(image);
            editableImage.latestOperationTime = time;
            return editableImage;
        }
    }

    private static abstract class Reader {
        private Reader() {
        }

        public static EditableImage read(Object input, Reader Reader2) throws IOException {
            if (input == null) {
                throw new IOException("Cannot read object");
            }
            return Reader2.run(input);
        }

        private EditableImage run(Object input) throws IOException {
            if (input instanceof File) {
                ImageReader imageReader = ReadOp.createImageReader((File)input);
                EditableImage editableImage = this.read(imageReader);
                imageReader.dispose();
                return editableImage;
            }
            if (input instanceof URL) {
                ImageReader imageReader = ReadOp.createImageReader((URL)input);
                EditableImage editableImage = this.read(imageReader);
                imageReader.dispose();
                return editableImage;
            }
            if (input instanceof InputStream) {
                ImageReader imageReader = ReadOp.createImageReader((InputStream)input);
                EditableImage editableImage = this.read(imageReader);
                imageReader.dispose();
                return editableImage;
            }
            if (input instanceof ImageReader) {
                return this.read((ImageReader)input);
            }
            throw new IllegalArgumentException("" + input.getClass());
        }

        protected abstract EditableImage read(ImageReader var1) throws IOException;
    }
}

