/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.htmlparser.xom;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import nu.validator.htmlparser.common.DoctypeExpectation;
import nu.validator.htmlparser.common.DocumentModeHandler;
import nu.validator.htmlparser.common.Heuristics;
import nu.validator.htmlparser.common.XmlViolationPolicy;
import nu.validator.htmlparser.impl.Tokenizer;
import nu.validator.htmlparser.xom.SimpleNodeFactory;
import nu.validator.htmlparser.xom.XOMTreeBuilder;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Nodes;
import nu.xom.ParsingException;
import nu.xom.ValidityException;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class HtmlBuilder
extends Builder {
    private final Tokenizer tokenizer;
    private final XOMTreeBuilder xomTreeBuilder;
    private final SimpleNodeFactory simpleNodeFactory;
    private EntityResolver entityResolver;

    public HtmlBuilder() {
        this(new SimpleNodeFactory(), XmlViolationPolicy.FATAL);
    }

    public HtmlBuilder(SimpleNodeFactory nodeFactory) {
        this(nodeFactory, XmlViolationPolicy.FATAL);
    }

    public HtmlBuilder(XmlViolationPolicy xmlPolicy) {
        this(new SimpleNodeFactory(), xmlPolicy);
    }

    public HtmlBuilder(SimpleNodeFactory nodeFactory, XmlViolationPolicy xmlPolicy) {
        this.simpleNodeFactory = nodeFactory;
        this.xomTreeBuilder = new XOMTreeBuilder(nodeFactory);
        this.tokenizer = new Tokenizer(this.xomTreeBuilder);
        this.tokenizer.setXmlnsPolicy(XmlViolationPolicy.ALTER_INFOSET);
        this.setXmlPolicy(xmlPolicy);
    }

    private void tokenize(InputSource is) throws ParsingException, IOException, MalformedURLException {
        try {
            if (is == null) {
                throw new IllegalArgumentException("Null input.");
            }
            if (is.getByteStream() == null && is.getCharacterStream() == null) {
                String systemId = is.getSystemId();
                if (systemId == null) {
                    throw new IllegalArgumentException("No byte stream, no character stream nor URI.");
                }
                if (this.entityResolver != null) {
                    is = this.entityResolver.resolveEntity(is.getPublicId(), systemId);
                }
                if (is.getByteStream() == null || is.getCharacterStream() == null) {
                    is = new InputSource();
                    is.setSystemId(systemId);
                    is.setByteStream(new URL(systemId).openStream());
                }
            }
            this.tokenizer.tokenize(is);
        }
        catch (SAXParseException e) {
            throw new ParsingException(e.getMessage(), e.getSystemId(), e.getLineNumber(), e.getColumnNumber(), (Throwable)e);
        }
        catch (SAXException e) {
            throw new ParsingException(e.getMessage(), (Throwable)e);
        }
    }

    public Document build(InputSource is) throws ParsingException, IOException {
        this.xomTreeBuilder.setFragmentContext(null);
        this.tokenize(is);
        return this.xomTreeBuilder.getDocument();
    }

    public Nodes buildFragment(InputSource is, String context) throws IOException, ParsingException {
        this.xomTreeBuilder.setFragmentContext(context);
        this.tokenize(is);
        return this.xomTreeBuilder.getDocumentFragment();
    }

    public Document build(File file) throws ParsingException, ValidityException, IOException {
        return this.build(new FileInputStream(file), file.toURI().toASCIIString());
    }

    public Document build(InputStream stream, String uri) throws ParsingException, ValidityException, IOException {
        InputSource is = new InputSource(stream);
        is.setSystemId(uri);
        return this.build(is);
    }

    public Document build(InputStream stream) throws ParsingException, ValidityException, IOException {
        return this.build(new InputSource(stream));
    }

    public Document build(Reader stream, String uri) throws ParsingException, ValidityException, IOException {
        InputSource is = new InputSource(stream);
        is.setSystemId(uri);
        return this.build(is);
    }

    public Document build(Reader stream) throws ParsingException, ValidityException, IOException {
        return this.build(new InputSource(stream));
    }

    public Document build(String content, String uri) throws ParsingException, ValidityException, IOException {
        return this.build(new StringReader(content), uri);
    }

    public Document build(String uri) throws ParsingException, ValidityException, IOException {
        return this.build(new InputSource(uri));
    }

    public SimpleNodeFactory getSimpleNodeFactory() {
        return this.simpleNodeFactory;
    }

    public void setEntityResolver(EntityResolver resolver) {
        this.entityResolver = resolver;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.xomTreeBuilder.setErrorHandler(errorHandler);
        this.tokenizer.setErrorHandler(errorHandler);
    }

    public void setIgnoringComments(boolean ignoreComments) {
        this.xomTreeBuilder.setIgnoringComments(ignoreComments);
    }

    public void setScriptingEnabled(boolean scriptingEnabled) {
        this.xomTreeBuilder.setScriptingEnabled(scriptingEnabled);
    }

    public void setCheckingNormalization(boolean enable) {
        this.tokenizer.setCheckingNormalization(enable);
    }

    public void setCommentPolicy(XmlViolationPolicy commentPolicy) {
        if (commentPolicy == XmlViolationPolicy.ALLOW) {
            throw new IllegalArgumentException("Only XML 1.0-compatible policies allowed. Cannot use ALLOW.");
        }
        this.tokenizer.setCommentPolicy(commentPolicy);
    }

    public void setContentNonXmlCharPolicy(XmlViolationPolicy contentNonXmlCharPolicy) {
        if (contentNonXmlCharPolicy == XmlViolationPolicy.ALLOW) {
            throw new IllegalArgumentException("Only XML 1.0-compatible policies allowed. Cannot use ALLOW.");
        }
        this.tokenizer.setContentNonXmlCharPolicy(contentNonXmlCharPolicy);
    }

    public void setContentSpacePolicy(XmlViolationPolicy contentSpacePolicy) {
        if (contentSpacePolicy == XmlViolationPolicy.ALLOW) {
            throw new IllegalArgumentException("Only XML 1.0-compatible policies allowed. Cannot use ALLOW.");
        }
        this.tokenizer.setContentSpacePolicy(contentSpacePolicy);
    }

    public void setHtml4ModeCompatibleWithXhtml1Schemata(boolean html4ModeCompatibleWithXhtml1Schemata) {
        this.tokenizer.setHtml4ModeCompatibleWithXhtml1Schemata(html4ModeCompatibleWithXhtml1Schemata);
    }

    public void setMappingLangToXmlLang(boolean mappingLangToXmlLang) {
        this.tokenizer.setMappingLangToXmlLang(mappingLangToXmlLang);
    }

    public void setNamePolicy(XmlViolationPolicy namePolicy) {
        if (namePolicy == XmlViolationPolicy.ALLOW) {
            throw new IllegalArgumentException("Only XML 1.0-compatible policies allowed. Cannot use ALLOW.");
        }
        this.tokenizer.setNamePolicy(namePolicy);
    }

    public void setXmlPolicy(XmlViolationPolicy xmlPolicy) {
        this.setNamePolicy(xmlPolicy);
        this.setContentSpacePolicy(xmlPolicy);
        this.setContentNonXmlCharPolicy(xmlPolicy);
        this.setCommentPolicy(xmlPolicy);
        this.setBogusXmlnsPolicy(xmlPolicy);
    }

    public void setDoctypeExpectation(DoctypeExpectation doctypeExpectation) {
        this.xomTreeBuilder.setDoctypeExpectation(doctypeExpectation);
    }

    public void setDocumentModeHandler(DocumentModeHandler documentModeHandler) {
        this.xomTreeBuilder.setDocumentModeHandler(documentModeHandler);
    }

    public void setBogusXmlnsPolicy(XmlViolationPolicy bogusXmlnsPolicy) {
        this.tokenizer.setBogusXmlnsPolicy(bogusXmlnsPolicy);
    }

    public void setHeuristics(Heuristics heuristics) {
        this.tokenizer.setHeuristics(heuristics);
    }
}

