/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.htmlparser.impl;

import java.util.Arrays;
import nu.validator.htmlparser.common.DoctypeExpectation;
import nu.validator.htmlparser.common.DocumentMode;
import nu.validator.htmlparser.common.DocumentModeHandler;
import nu.validator.htmlparser.common.XmlViolationPolicy;
import nu.validator.htmlparser.impl.AttributesImpl;
import nu.validator.htmlparser.impl.ContentModelFlag;
import nu.validator.htmlparser.impl.EmptyAttributes;
import nu.validator.htmlparser.impl.MetaSniffer;
import nu.validator.htmlparser.impl.TokenHandler;
import nu.validator.htmlparser.impl.Tokenizer;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TreeBuilder<T>
implements TokenHandler {
    private static final char[] ISINDEX_PROMPT = "This is a searchable index. Insert your search keywords here: ".toCharArray();
    private static final String[] HTML4_PUBLIC_IDS = new String[]{"-//W3C//DTD HTML 4.0 Frameset//EN", "-//W3C//DTD HTML 4.0 Transitional//EN", "-//W3C//DTD HTML 4.0//EN", "-//W3C//DTD HTML 4.01 Frameset//EN", "-//W3C//DTD HTML 4.01 Transitional//EN", "-//W3C//DTD HTML 4.01//EN"};
    private static final String[] QUIRKY_PUBLIC_IDS = new String[]{"+//silmaril//dtd html pro v0r11 19970101//en", "-//advasoft ltd//dtd html 3.0 aswedit + extensions//en", "-//as//dtd html 3.0 aswedit + extensions//en", "-//ietf//dtd html 2.0 level 1//en", "-//ietf//dtd html 2.0 level 2//en", "-//ietf//dtd html 2.0 strict level 1//en", "-//ietf//dtd html 2.0 strict level 2//en", "-//ietf//dtd html 2.0 strict//en", "-//ietf//dtd html 2.0//en", "-//ietf//dtd html 2.1e//en", "-//ietf//dtd html 3.0//en", "-//ietf//dtd html 3.0//en//", "-//ietf//dtd html 3.2 final//en", "-//ietf//dtd html 3.2//en", "-//ietf//dtd html 3//en", "-//ietf//dtd html level 0//en", "-//ietf//dtd html level 0//en//2.0", "-//ietf//dtd html level 1//en", "-//ietf//dtd html level 1//en//2.0", "-//ietf//dtd html level 2//en", "-//ietf//dtd html level 2//en//2.0", "-//ietf//dtd html level 3//en", "-//ietf//dtd html level 3//en//3.0", "-//ietf//dtd html strict level 0//en", "-//ietf//dtd html strict level 0//en//2.0", "-//ietf//dtd html strict level 1//en", "-//ietf//dtd html strict level 1//en//2.0", "-//ietf//dtd html strict level 2//en", "-//ietf//dtd html strict level 2//en//2.0", "-//ietf//dtd html strict level 3//en", "-//ietf//dtd html strict level 3//en//3.0", "-//ietf//dtd html strict//en", "-//ietf//dtd html strict//en//2.0", "-//ietf//dtd html strict//en//3.0", "-//ietf//dtd html//en", "-//ietf//dtd html//en//2.0", "-//ietf//dtd html//en//3.0", "-//metrius//dtd metrius presentational//en", "-//microsoft//dtd internet explorer 2.0 html strict//en", "-//microsoft//dtd internet explorer 2.0 html//en", "-//microsoft//dtd internet explorer 2.0 tables//en", "-//microsoft//dtd internet explorer 3.0 html strict//en", "-//microsoft//dtd internet explorer 3.0 html//en", "-//microsoft//dtd internet explorer 3.0 tables//en", "-//netscape comm. corp.//dtd html//en", "-//netscape comm. corp.//dtd strict html//en", "-//o'reilly and associates//dtd html 2.0//en", "-//o'reilly and associates//dtd html extended 1.0//en", "-//o'reilly and associates//dtd html extended relaxed 1.0//en", "-//softquad software//dtd hotmetal pro 6.0::19990601::extensions to html 4.0//en", "-//softquad//dtd hotmetal pro 4.0::19971010::extensions to html 4.0//en", "-//spyglass//dtd html 2.0 extended//en", "-//sq//dtd html 2.0 hotmetal + extensions//en", "-//sun microsystems corp.//dtd hotjava html//en", "-//sun microsystems corp.//dtd hotjava strict html//en", "-//w3c//dtd html 3 1995-03-24//en", "-//w3c//dtd html 3.2 draft//en", "-//w3c//dtd html 3.2 final//en", "-//w3c//dtd html 3.2//en", "-//w3c//dtd html 3.2s draft//en", "-//w3c//dtd html 4.0 frameset//en", "-//w3c//dtd html 4.0 transitional//en", "-//w3c//dtd html experimental 19960712//en", "-//w3c//dtd html experimental 970421//en", "-//w3c//dtd w3 html//en", "-//w3o//dtd w3 html 3.0//en", "-//w3o//dtd w3 html 3.0//en//", "-//w3o//dtd w3 html strict 3.0//en//", "-//webtechs//dtd mozilla html 2.0//en", "-//webtechs//dtd mozilla html//en", "-/w3c/dtd html 4.0 transitional/en", "html"};
    private static final int NOT_FOUND_ON_STACK = Integer.MAX_VALUE;
    private final StackNode<T> MARKER = new StackNode<Object>(null, null);
    private final boolean nonConformingAndStreaming;
    private final boolean conformingAndStreaming;
    private final boolean coalescingText;
    private boolean bodyCloseReported = false;
    private boolean htmlCloseReported = false;
    private InsertionMode mode = InsertionMode.INITIAL;
    protected Tokenizer tokenizer;
    private ErrorHandler errorHandler;
    private DocumentModeHandler documentModeHandler;
    private DoctypeExpectation doctypeExpectation = DoctypeExpectation.HTML;
    private int cdataOrRcdataTimesToPop;
    private boolean scriptingEnabled = false;
    private boolean needToDropLF;
    private boolean wantingComments;
    private String context;
    private StackNode<T>[] stack;
    private int currentPtr = -1;
    private StackNode<T>[] listOfActiveFormattingElements;
    private int listPtr = -1;
    private T formPointer;
    private T headPointer;
    private boolean reportingDoctype = true;
    private char[] charBuffer;
    private int charBufferLen = 0;

    protected TreeBuilder(XmlViolationPolicy streamabilityViolationPolicy, boolean coalescingText) {
        this.conformingAndStreaming = streamabilityViolationPolicy == XmlViolationPolicy.FATAL;
        this.nonConformingAndStreaming = streamabilityViolationPolicy == XmlViolationPolicy.ALTER_INFOSET;
        this.coalescingText = coalescingText;
        if (coalescingText) {
            this.charBuffer = new char[1024];
        }
    }

    protected final void fatal() throws SAXException {
        SAXParseException spe = new SAXParseException("Last error required non-streamable recovery.", this.tokenizer);
        if (this.errorHandler != null) {
            this.errorHandler.fatalError(spe);
        }
        throw spe;
    }

    protected final void fatal(Exception e) throws SAXException {
        SAXParseException spe = new SAXParseException(e.getMessage(), this.tokenizer, e);
        if (this.errorHandler != null) {
            this.errorHandler.fatalError(spe);
        }
        throw spe;
    }

    protected final void err(String message) throws SAXException {
        if (this.errorHandler == null) {
            return;
        }
        SAXParseException spe = new SAXParseException(message, this.tokenizer);
        this.errorHandler.error(spe);
    }

    protected final void warn(String message) throws SAXException {
        if (this.errorHandler == null) {
            return;
        }
        SAXParseException spe = new SAXParseException(message, this.tokenizer);
        this.errorHandler.warning(spe);
    }

    @Override
    public final void start(Tokenizer self) throws SAXException {
        this.tokenizer = self;
        this.stack = new StackNode[64];
        this.listOfActiveFormattingElements = new StackNode[64];
        this.needToDropLF = false;
        this.cdataOrRcdataTimesToPop = 0;
        this.currentPtr = -1;
        this.formPointer = null;
        this.wantingComments = this.wantsComments();
        this.start(this.context != null);
        if (this.context == null) {
            this.mode = InsertionMode.INITIAL;
        } else {
            T elt = this.createHtmlElementSetAsRoot(this.tokenizer.newAttributes());
            StackNode<T> node = new StackNode<T>("html", elt);
            ++this.currentPtr;
            this.stack[this.currentPtr] = node;
            this.resetTheInsertionMode();
            if ("title" == this.context || "textarea" == this.context) {
                this.tokenizer.setContentModelFlag(ContentModelFlag.RCDATA, this.context);
            } else if ("style" == this.context || "script" == this.context || "xmp" == this.context || "iframe" == this.context || "noembed" == this.context || "noframes" == this.context || this.scriptingEnabled && "noscript" == this.context) {
                this.tokenizer.setContentModelFlag(ContentModelFlag.CDATA, this.context);
            } else if ("plaintext" == this.context) {
                this.tokenizer.setContentModelFlag(ContentModelFlag.PLAINTEXT, this.context);
            } else {
                this.tokenizer.setContentModelFlag(ContentModelFlag.PCDATA, this.context);
            }
        }
    }

    @Override
    public final void doctype(String name, String publicIdentifier, String systemIdentifier, boolean forceQuirks) throws SAXException {
        this.needToDropLF = false;
        switch (this.mode) {
            case INITIAL: {
                if (this.reportingDoctype) {
                    this.appendDoctypeToDocument(name, publicIdentifier == null ? "" : publicIdentifier, systemIdentifier == null ? "" : systemIdentifier);
                }
                String publicIdentifierLC = this.toAsciiLowerCase(publicIdentifier);
                String systemIdentifierLC = this.toAsciiLowerCase(systemIdentifier);
                switch (this.doctypeExpectation) {
                    case HTML: {
                        if (this.isQuirky(name, publicIdentifierLC, systemIdentifierLC, forceQuirks)) {
                            this.err("Quirky doctype.");
                            this.documentModeInternal(DocumentMode.QUIRKS_MODE, publicIdentifier, systemIdentifier, false);
                            break;
                        }
                        if (this.isAlmostStandards(publicIdentifierLC, systemIdentifierLC)) {
                            this.err("Almost standards mode doctype.");
                            this.documentModeInternal(DocumentMode.ALMOST_STANDARDS_MODE, publicIdentifier, systemIdentifier, false);
                            break;
                        }
                        if (publicIdentifier != null || systemIdentifier != null) {
                            this.err("Legacy doctype.");
                        }
                        this.documentModeInternal(DocumentMode.STANDARDS_MODE, publicIdentifier, systemIdentifier, false);
                        break;
                    }
                    case HTML401_STRICT: {
                        this.tokenizer.turnOnAdditionalHtml4Errors();
                        if (this.isQuirky(name, publicIdentifierLC, systemIdentifierLC, forceQuirks)) {
                            this.err("Quirky doctype.");
                            this.documentModeInternal(DocumentMode.QUIRKS_MODE, publicIdentifier, systemIdentifier, true);
                            break;
                        }
                        if (this.isAlmostStandards(publicIdentifierLC, systemIdentifierLC)) {
                            this.err("Almost standards mode doctype.");
                            this.documentModeInternal(DocumentMode.ALMOST_STANDARDS_MODE, publicIdentifier, systemIdentifier, true);
                            break;
                        }
                        if ("-//W3C//DTD HTML 4.01//EN".equals(publicIdentifier)) {
                            if (!"http://www.w3.org/TR/html4/strict.dtd".equals(systemIdentifier)) {
                                this.warn("The doctype did not contain the system identifier prescribed by the HTML 4.01 specification.");
                            }
                        } else {
                            this.err("The doctype was not the HTML 4.01 Strict doctype.");
                        }
                        this.documentModeInternal(DocumentMode.STANDARDS_MODE, publicIdentifier, systemIdentifier, true);
                        break;
                    }
                    case HTML401_TRANSITIONAL: {
                        this.tokenizer.turnOnAdditionalHtml4Errors();
                        if (this.isQuirky(name, publicIdentifierLC, systemIdentifierLC, forceQuirks)) {
                            this.err("Quirky doctype.");
                            this.documentModeInternal(DocumentMode.QUIRKS_MODE, publicIdentifier, systemIdentifier, true);
                            break;
                        }
                        if (this.isAlmostStandards(publicIdentifierLC, systemIdentifierLC)) {
                            if ("-//W3C//DTD HTML 4.01 Transitional//EN".equals(publicIdentifier) && systemIdentifier != null) {
                                if (!"http://www.w3.org/TR/html4/loose.dtd".equals(systemIdentifier)) {
                                    this.warn("The doctype did not contain the system identifier prescribed by the HTML 4.01 specification.");
                                }
                            } else {
                                this.err("The doctype was not a non-quirky HTML 4.01 Transitional doctype.");
                            }
                            this.documentModeInternal(DocumentMode.ALMOST_STANDARDS_MODE, publicIdentifier, systemIdentifier, true);
                            break;
                        }
                        this.err("The doctype was not the HTML 4.01 Transitional doctype.");
                        this.documentModeInternal(DocumentMode.STANDARDS_MODE, publicIdentifier, systemIdentifier, true);
                        break;
                    }
                    case AUTO: {
                        boolean html4 = this.isHtml4Doctype(publicIdentifier);
                        if (html4) {
                            this.tokenizer.turnOnAdditionalHtml4Errors();
                        }
                        if (this.isQuirky(name, publicIdentifierLC, systemIdentifierLC, forceQuirks)) {
                            this.err("Quirky doctype.");
                            this.documentModeInternal(DocumentMode.QUIRKS_MODE, publicIdentifier, systemIdentifier, html4);
                            break;
                        }
                        if (this.isAlmostStandards(publicIdentifierLC, systemIdentifierLC)) {
                            if ("-//W3C//DTD HTML 4.01 Transitional//EN".equals(publicIdentifier)) {
                                this.tokenizer.turnOnAdditionalHtml4Errors();
                                if (!"http://www.w3.org/TR/html4/loose.dtd".equals(systemIdentifier)) {
                                    this.warn("The doctype did not contain the system identifier prescribed by the HTML 4.01 specification.");
                                }
                            } else {
                                this.err("Almost standards mode doctype.");
                            }
                            this.documentModeInternal(DocumentMode.ALMOST_STANDARDS_MODE, publicIdentifier, systemIdentifier, html4);
                            break;
                        }
                        if ("-//W3C//DTD HTML 4.01//EN".equals(publicIdentifier)) {
                            this.tokenizer.turnOnAdditionalHtml4Errors();
                            if (!"http://www.w3.org/TR/html4/strict.dtd".equals(systemIdentifier)) {
                                this.warn("The doctype did not contain the system identifier prescribed by the HTML 4.01 specification.");
                            }
                        } else if (publicIdentifier != null || systemIdentifier != null) {
                            this.err("Legacy doctype.");
                        }
                        this.documentModeInternal(DocumentMode.STANDARDS_MODE, publicIdentifier, systemIdentifier, html4);
                        break;
                    }
                    case NO_DOCTYPE_ERRORS: {
                        if (this.isQuirky(name, publicIdentifierLC, systemIdentifierLC, forceQuirks)) {
                            this.documentModeInternal(DocumentMode.QUIRKS_MODE, publicIdentifier, systemIdentifier, false);
                            break;
                        }
                        if (this.isAlmostStandards(publicIdentifierLC, systemIdentifierLC)) {
                            this.documentModeInternal(DocumentMode.ALMOST_STANDARDS_MODE, publicIdentifier, systemIdentifier, false);
                            break;
                        }
                        this.documentModeInternal(DocumentMode.STANDARDS_MODE, publicIdentifier, systemIdentifier, false);
                    }
                }
                this.mode = InsertionMode.BEFORE_HTML;
                return;
            }
        }
        this.err("Stray doctype.");
    }

    private boolean isHtml4Doctype(String publicIdentifier) {
        return publicIdentifier != null && Arrays.binarySearch(HTML4_PUBLIC_IDS, publicIdentifier) > -1;
    }

    @Override
    public final void comment(char[] buf, int length) throws SAXException {
        this.needToDropLF = false;
        if (this.wantingComments) {
            switch (this.mode) {
                case INITIAL: 
                case BEFORE_HTML: 
                case AFTER_AFTER_BODY: 
                case AFTER_AFTER_FRAMESET: {
                    this.appendCommentToDocument(buf, 0, length);
                    return;
                }
                case AFTER_BODY: {
                    this.flushCharacters();
                    this.appendComment(this.stack[0].node, buf, 0, length);
                    return;
                }
            }
            this.flushCharacters();
            this.appendComment(this.stack[this.currentPtr].node, buf, 0, length);
            return;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public final void characters(char[] buf, int start, int length) throws SAXException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[CASE]], but top level block is 3[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void eof() throws SAXException {
        try {
            this.flushCharacters();
            block15: while (true) {
                switch (this.mode) {
                    case INITIAL: {
                        if (this.doctypeExpectation != DoctypeExpectation.NO_DOCTYPE_ERRORS) {
                            this.err("End of file seen without seeing a doctype first.");
                        }
                        this.documentModeInternal(DocumentMode.QUIRKS_MODE, null, null, false);
                        this.mode = InsertionMode.BEFORE_HTML;
                        continue block15;
                    }
                    case BEFORE_HTML: {
                        this.appendHtmlElementToDocumentAndPush();
                        this.mode = InsertionMode.BEFORE_HEAD;
                        continue block15;
                    }
                    case BEFORE_HEAD: {
                        this.appendToCurrentNodeAndPushHeadElement(EmptyAttributes.EMPTY_ATTRIBUTES);
                        this.mode = InsertionMode.IN_HEAD;
                        continue block15;
                    }
                    case IN_HEAD: {
                        if (this.currentPtr > 1) {
                            this.err("End of file seen and there were open elements.");
                        }
                        while (this.currentPtr > 0) {
                            this.pop();
                        }
                        this.mode = InsertionMode.AFTER_HEAD;
                        continue block15;
                    }
                    case IN_HEAD_NOSCRIPT: {
                        this.err("End of file seen and there were open elements.");
                        while (this.currentPtr > 1) {
                            this.pop();
                        }
                        this.mode = InsertionMode.IN_HEAD;
                        continue block15;
                    }
                    case AFTER_HEAD: {
                        this.appendToCurrentNodeAndPushBodyElement();
                        this.mode = InsertionMode.IN_BODY;
                        continue block15;
                    }
                    case IN_COLUMN_GROUP: {
                        if (this.currentPtr == 0) {
                            assert (this.context != null);
                            break block15;
                        }
                        this.pop();
                        this.mode = InsertionMode.IN_TABLE;
                        continue block15;
                    }
                    case IN_BODY: 
                    case IN_CELL: 
                    case IN_CAPTION: {
                        for (int i = this.currentPtr; i >= 0; --i) {
                            String name = this.stack[i].name;
                            if ("dd" == name || "dt" == name || "li" == name || "p" == name || "tbody" == name || "td" == name || "tfoot" == name || "th" == name || "thead" == name || "body" == name || "html" == name) continue;
                            this.err("End of file seen and there were open elements.");
                            break block15;
                        }
                        break block15;
                    }
                    case IN_TABLE: 
                    case IN_TABLE_BODY: 
                    case IN_ROW: 
                    case IN_FRAMESET: 
                    case IN_SELECT: 
                    case IN_SELECT_IN_TABLE: {
                        if (this.currentPtr <= 0) break block15;
                        this.err("End of file seen and there were open elements.");
                        break block15;
                    }
                    case AFTER_AFTER_BODY: 
                    case AFTER_AFTER_FRAMESET: 
                    case AFTER_BODY: 
                    case AFTER_FRAMESET: {
                        break block15;
                    }
                    default: {
                        continue block15;
                    }
                }
                break;
            }
            while (this.currentPtr > 1) {
                this.pop();
            }
            if (this.currentPtr == 1) {
                if (this.stack[1].name == "body") {
                    if (!this.bodyCloseReported) {
                        this.bodyClosed(this.stack[1].node);
                    }
                } else {
                    this.pop();
                }
            }
            if (this.context == null && !this.htmlCloseReported) {
                this.htmlClosed(this.stack[0].node);
            }
        }
        finally {
            this.stack = null;
            this.listOfActiveFormattingElements = null;
            this.end();
        }
    }

    @Override
    public final void startTag(String name, Attributes attributes) throws SAXException {
        this.needToDropLF = false;
        block25: while (true) {
            switch (this.mode) {
                case IN_TABLE_BODY: {
                    int eltPos;
                    if ("tr" == name) {
                        this.clearStackBackTo(this.findLastInTableScopeOrRootTbodyTheadTfoot());
                        this.appendToCurrentNodeAndPushElement(name, attributes);
                        this.mode = InsertionMode.IN_ROW;
                        return;
                    }
                    if ("td" == name || "th" == name) {
                        this.err("\u201c" + name + "\u201d start tag in table body.");
                        this.clearStackBackTo(this.findLastInTableScopeOrRootTbodyTheadTfoot());
                        this.appendToCurrentNodeAndPushElement("tr", EmptyAttributes.EMPTY_ATTRIBUTES);
                        this.mode = InsertionMode.IN_ROW;
                        continue block25;
                    }
                    if ("caption" == name || "col" == name || "colgroup" == name || "tbody" == name || "tfoot" == name || "thead" == name) {
                        eltPos = this.findLastInTableScopeOrRootTbodyTheadTfoot();
                        if (eltPos == 0) {
                            this.err("Stray \u201c" + name + "\u201d start tag.");
                            return;
                        }
                        this.clearStackBackTo(eltPos);
                        this.pop();
                        this.mode = InsertionMode.IN_TABLE;
                        continue block25;
                    }
                }
                case IN_ROW: {
                    int eltPos;
                    if ("td" == name || "th" == name) {
                        this.clearStackBackTo(this.findLastOrRoot("tr"));
                        this.appendToCurrentNodeAndPushElement(name, attributes);
                        this.mode = InsertionMode.IN_CELL;
                        this.insertMarker();
                        return;
                    }
                    if ("caption" == name || "col" == name || "colgroup" == name || "tbody" == name || "tfoot" == name || "thead" == name || "tr" == name) {
                        eltPos = this.findLastOrRoot("tr");
                        if (eltPos == 0) {
                            assert (this.context != null);
                            this.err("No table row to close.");
                            return;
                        }
                        this.clearStackBackTo(eltPos);
                        this.pop();
                        this.mode = InsertionMode.IN_TABLE_BODY;
                        continue block25;
                    }
                }
                case IN_TABLE: {
                    int eltPos;
                    if ("caption" == name) {
                        this.clearStackBackTo(this.findLastOrRoot("table"));
                        this.insertMarker();
                        this.appendToCurrentNodeAndPushElement(name, attributes);
                        this.mode = InsertionMode.IN_CAPTION;
                        return;
                    }
                    if ("colgroup" == name) {
                        this.clearStackBackTo(this.findLastOrRoot("table"));
                        this.appendToCurrentNodeAndPushElement(name, attributes);
                        this.mode = InsertionMode.IN_COLUMN_GROUP;
                        return;
                    }
                    if ("col" == name) {
                        this.clearStackBackTo(this.findLastOrRoot("table"));
                        this.appendToCurrentNodeAndPushElement("colgroup", EmptyAttributes.EMPTY_ATTRIBUTES);
                        this.mode = InsertionMode.IN_COLUMN_GROUP;
                        continue block25;
                    }
                    if ("tbody" == name || "tfoot" == name || "thead" == name) {
                        this.clearStackBackTo(this.findLastOrRoot("table"));
                        this.appendToCurrentNodeAndPushElement(name, attributes);
                        this.mode = InsertionMode.IN_TABLE_BODY;
                        return;
                    }
                    if ("td" == name || "tr" == name || "th" == name) {
                        this.clearStackBackTo(this.findLastOrRoot("table"));
                        this.appendToCurrentNodeAndPushElement("tbody", EmptyAttributes.EMPTY_ATTRIBUTES);
                        this.mode = InsertionMode.IN_TABLE_BODY;
                        continue block25;
                    }
                    if ("table" == name) {
                        this.err("Start tag for \u201ctable\u201d seen but the previous \u201ctable\u201d is still open.");
                        eltPos = this.findLastInTableScope(name);
                        if (eltPos == Integer.MAX_VALUE) {
                            assert (this.context != null);
                            return;
                        }
                        this.generateImpliedEndTags();
                        if (!this.isCurrent("table")) {
                            this.err("Unclosed elements on stack.");
                        }
                        while (this.currentPtr >= eltPos) {
                            this.pop();
                        }
                        this.resetTheInsertionMode();
                        continue block25;
                    }
                    if (!("script" != name && "style" != name || this.isTainted())) {
                        this.appendToCurrentNodeAndPushElement(name, attributes);
                        this.cdataOrRcdataTimesToPop = 1;
                        this.tokenizer.setContentModelFlag(ContentModelFlag.CDATA, name);
                        return;
                    }
                    if ("input" == name && !this.isTainted() && this.equalsIgnoreAsciiCase("hidden", attributes.getValue("", "type"))) {
                        this.appendVoidElementToCurrent(name, attributes, this.formPointer);
                        return;
                    }
                    this.err("Start tag \u201c" + name + "\u201d seen in \u201ctable\u201d.");
                }
                case IN_CAPTION: {
                    int eltPos;
                    if ("caption" == name || "col" == name || "colgroup" == name || "tbody" == name || "td" == name || "tfoot" == name || "th" == name || "thead" == name || "tr" == name) {
                        this.err("Stray \u201c" + name + "\u201d start tag in \u201ccaption\u201d.");
                        eltPos = this.findLastInTableScope("caption");
                        if (eltPos == Integer.MAX_VALUE) {
                            return;
                        }
                        this.generateImpliedEndTags();
                        if (this.currentPtr != eltPos) {
                            this.err("Unclosed elements on stack.");
                        }
                        while (this.currentPtr >= eltPos) {
                            this.pop();
                        }
                        this.clearTheListOfActiveFormattingElementsUpToTheLastMarker();
                        this.mode = InsertionMode.IN_TABLE;
                        continue block25;
                    }
                }
                case IN_CELL: {
                    int eltPos;
                    if ("caption" == name || "col" == name || "colgroup" == name || "tbody" == name || "td" == name || "tfoot" == name || "th" == name || "thead" == name || "tr" == name) {
                        eltPos = this.findLastInTableScopeTdTh();
                        if (eltPos == Integer.MAX_VALUE) {
                            this.err("No cell to close.");
                            return;
                        }
                        this.closeTheCell(eltPos);
                        continue block25;
                    }
                }
                case IN_BODY: {
                    int eltPos;
                    if ("html" == name) {
                        this.err("Stray \u201chtml\u201d start tag.");
                        this.addAttributesToElement(this.stack[0].node, attributes);
                        return;
                    }
                    if ("base" != name && "link" != name && "meta" != name && "style" != name && "script" != name && "title" != name) {
                        if ("body" == name) {
                            this.err("\u201cbody\u201d start tag found but the \u201cbody\u201d element is already open.");
                            this.addAttributesToBody(attributes);
                            return;
                        }
                        if ("p" == name || "div" == name || "h1" == name || "h2" == name || "h3" == name || "h4" == name || "h5" == name || "h6" == name || "blockquote" == name || "ol" == name || "ul" == name || "dl" == name || "fieldset" == name || "address" == name || "menu" == name || "center" == name || "dir" == name) {
                            this.implicitlyCloseP();
                            this.appendToCurrentNodeAndPushElementMayFoster(name, attributes);
                            return;
                        }
                        if ("pre" == name || "listing" == name) {
                            this.implicitlyCloseP();
                            this.appendToCurrentNodeAndPushElementMayFoster(name, attributes);
                            this.needToDropLF = true;
                            return;
                        }
                        if ("form" == name) {
                            if (this.formPointer != null) {
                                this.err("Saw a \u201cform\u201d start tag, but there was already an active \u201cform\u201d element.");
                                return;
                            }
                            this.implicitlyCloseP();
                            this.appendToCurrentNodeAndPushFormElementMayFoster(attributes);
                            return;
                        }
                        if ("li" == name) {
                            this.implicitlyCloseP();
                            eltPos = this.findLiToPop();
                            if (eltPos < this.currentPtr) {
                                this.err("A \u201cli\u201d start tag was seen but the previous \u201cli\u201d element had open children.");
                            }
                            while (this.currentPtr >= eltPos) {
                                this.pop();
                            }
                            this.appendToCurrentNodeAndPushElementMayFoster(name, attributes);
                            return;
                        }
                        if ("dd" == name || "dt" == name) {
                            this.implicitlyCloseP();
                            eltPos = this.findDdOrDtToPop();
                            if (eltPos < this.currentPtr) {
                                this.err("A definition list item start tag was seen but the previous definition list item element had open children.");
                            }
                            while (this.currentPtr >= eltPos) {
                                this.pop();
                            }
                            this.appendToCurrentNodeAndPushElementMayFoster(name, attributes);
                            return;
                        }
                        if ("plaintext" == name) {
                            this.implicitlyCloseP();
                            this.appendToCurrentNodeAndPushElementMayFoster(name, attributes);
                            this.tokenizer.setContentModelFlag(ContentModelFlag.PLAINTEXT, name);
                            return;
                        }
                        if ("a" == name) {
                            int activeAPos = this.findInListOfActiveFormattingElementsContainsBetweenEndAndLastMarker("a");
                            if (activeAPos != -1) {
                                this.err("An \u201ca\u201d start tag seen with already an active \u201ca\u201d element.");
                                StackNode<T> activeA = this.listOfActiveFormattingElements[activeAPos];
                                this.adoptionAgencyEndTag("a");
                                this.removeFromStack(activeA);
                                activeAPos = this.findInListOfActiveFormattingElements(activeA);
                                if (activeAPos != -1) {
                                    this.removeFromListOfActiveFormattingElements(activeAPos);
                                }
                            }
                            this.reconstructTheActiveFormattingElements();
                            this.appendToCurrentNodeAndPushFormattingElementMayFoster(name, attributes);
                            return;
                        }
                        if ("i" == name || "b" == name || "em" == name || "strong" == name || "font" == name || "big" == name || "s" == name || "small" == name || "strike" == name || "tt" == name || "u" == name) {
                            this.reconstructTheActiveFormattingElements();
                            this.appendToCurrentNodeAndPushFormattingElementMayFoster(name, attributes);
                            return;
                        }
                        if ("nobr" == name) {
                            this.reconstructTheActiveFormattingElements();
                            if (Integer.MAX_VALUE != this.findLastInScope("nobr")) {
                                this.err("\u201cnobr\u201d start tag seen when there was an open \u201cnobr\u201d element in scope.");
                                this.adoptionAgencyEndTag("nobr");
                            }
                            this.appendToCurrentNodeAndPushFormattingElementMayFoster(name, attributes);
                            return;
                        }
                        if ("button" == name) {
                            eltPos = this.findLastInScope(name);
                            if (eltPos != Integer.MAX_VALUE) {
                                this.err("\u201cbutton\u201d start tag seen when there was an open \u201cbutton\u201d element in scope.");
                                this.generateImpliedEndTags();
                                if (!this.isCurrent("button")) {
                                    this.err("There was an open \u201cbutton\u201d element in scope with unclosed children.");
                                }
                                while (this.currentPtr >= eltPos) {
                                    this.pop();
                                }
                                this.clearTheListOfActiveFormattingElementsUpToTheLastMarker();
                                continue block25;
                            }
                            this.reconstructTheActiveFormattingElements();
                            this.appendToCurrentNodeAndPushElementMayFoster(name, attributes, this.formPointer);
                            this.insertMarker();
                            return;
                        }
                        if ("object" == name || "marquee" == name || "applet" == name) {
                            this.reconstructTheActiveFormattingElements();
                            this.appendToCurrentNodeAndPushElementMayFoster(name, attributes);
                            this.insertMarker();
                            return;
                        }
                        if ("xmp" == name) {
                            this.reconstructTheActiveFormattingElements();
                            this.appendToCurrentNodeAndPushElementMayFoster(name, attributes);
                            this.cdataOrRcdataTimesToPop = 1;
                            this.tokenizer.setContentModelFlag(ContentModelFlag.CDATA, name);
                            return;
                        }
                        if ("table" == name) {
                            this.implicitlyCloseP();
                            this.appendToCurrentNodeAndPushElementMayFoster(name, attributes);
                            this.mode = InsertionMode.IN_TABLE;
                            return;
                        }
                        if ("br" == name || "img" == name || "embed" == name || "param" == name || "area" == name || "basefont" == name || "bgsound" == name || "spacer" == name || "wbr" == name) {
                            this.reconstructTheActiveFormattingElements();
                            this.appendVoidElementToCurrentMayFoster(name, attributes);
                            return;
                        }
                        if ("hr" == name) {
                            this.implicitlyCloseP();
                            this.appendVoidElementToCurrentMayFoster(name, attributes);
                            return;
                        }
                        if ("image" == name) {
                            this.err("Saw a start tag \u201cimage\u201d.");
                            name = "img";
                            continue block25;
                        }
                        if ("input" == name) {
                            this.reconstructTheActiveFormattingElements();
                            this.appendVoidElementToCurrentMayFoster(name, attributes, this.formPointer);
                            return;
                        }
                        if ("isindex" == name) {
                            this.err("\u201cisindex\u201d seen.");
                            if (this.formPointer != null) {
                                return;
                            }
                            this.implicitlyCloseP();
                            AttributesImpl formAttrs = this.tokenizer.newAttributes();
                            int actionIndex = attributes.getIndex("action");
                            if (actionIndex > -1) {
                                formAttrs.addAttribute("action", attributes.getValue(actionIndex));
                            }
                            this.appendToCurrentNodeAndPushFormElementMayFoster(formAttrs);
                            this.appendVoidElementToCurrentMayFoster("hr", EmptyAttributes.EMPTY_ATTRIBUTES);
                            this.appendToCurrentNodeAndPushElementMayFoster("p", EmptyAttributes.EMPTY_ATTRIBUTES);
                            this.appendToCurrentNodeAndPushElementMayFoster("label", EmptyAttributes.EMPTY_ATTRIBUTES);
                            int promptIndex = attributes.getIndex("prompt");
                            if (promptIndex > -1) {
                                char[] prompt = attributes.getValue(promptIndex).toCharArray();
                                this.appendCharacters(this.stack[this.currentPtr].node, prompt, 0, prompt.length);
                            } else {
                                this.appendCharacters(this.stack[this.currentPtr].node, ISINDEX_PROMPT, 0, ISINDEX_PROMPT.length);
                            }
                            AttributesImpl inputAttributes = this.tokenizer.newAttributes();
                            inputAttributes.addAttribute("name", "isindex");
                            for (int i = 0; i < attributes.getLength(); ++i) {
                                String attributeQName = attributes.getQName(i);
                                if ("name".equals(attributeQName) || "action".equals(attributeQName) || "prompt".equals(attributeQName)) continue;
                                inputAttributes.addAttribute(attributeQName, attributes.getValue(i));
                            }
                            this.appendVoidElementToCurrentMayFoster("input", inputAttributes, this.formPointer);
                            this.pop();
                            this.pop();
                            this.appendVoidElementToCurrentMayFoster("hr", EmptyAttributes.EMPTY_ATTRIBUTES);
                            this.pop();
                            return;
                        }
                        if ("textarea" == name) {
                            this.appendToCurrentNodeAndPushElementMayFoster(name, attributes, this.formPointer);
                            this.tokenizer.setContentModelFlag(ContentModelFlag.RCDATA, name);
                            this.cdataOrRcdataTimesToPop = 1;
                            this.needToDropLF = true;
                            return;
                        }
                        if ("iframe" == name || "noembed" == name || "noframes" == name || "noscript" == name && this.scriptingEnabled) {
                            this.appendToCurrentNodeAndPushElementMayFoster(name, attributes);
                            this.cdataOrRcdataTimesToPop = 1;
                            this.tokenizer.setContentModelFlag(ContentModelFlag.CDATA, name);
                            return;
                        }
                        if ("select" == name) {
                            this.reconstructTheActiveFormattingElements();
                            this.appendToCurrentNodeAndPushElementMayFoster(name, attributes, this.formPointer);
                            switch (this.mode) {
                                case IN_TABLE: 
                                case IN_TABLE_BODY: 
                                case IN_ROW: 
                                case IN_COLUMN_GROUP: 
                                case IN_CELL: 
                                case IN_CAPTION: {
                                    this.mode = InsertionMode.IN_SELECT_IN_TABLE;
                                    break;
                                }
                                default: {
                                    this.mode = InsertionMode.IN_SELECT;
                                }
                            }
                            return;
                        }
                        if ("caption" == name || "col" == name || "colgroup" == name || "frame" == name || "frameset" == name || "head" == name || "option" == name || "optgroup" == name || "tbody" == name || "td" == name || "tfoot" == name || "th" == name || "thead" == name || "tr" == name) {
                            this.err("Stray start tag \u201c" + name + "\u201d.");
                            return;
                        }
                        this.reconstructTheActiveFormattingElements();
                        this.appendToCurrentNodeAndPushElementMayFoster(name, attributes);
                        return;
                    }
                }
                case IN_HEAD: {
                    if ("html" == name) {
                        this.err("Stray \u201chtml\u201d start tag.");
                        this.addAttributesToElement(this.stack[0].node, attributes);
                        return;
                    }
                    if ("base" == name) {
                        this.appendVoidElementToCurrentMayFoster(name, attributes);
                        return;
                    }
                    if ("meta" != name && "link" != name) {
                        if ("title" == name) {
                            this.appendToCurrentNodeAndPushElementMayFoster(name, attributes);
                            this.cdataOrRcdataTimesToPop = 1;
                            this.tokenizer.setContentModelFlag(ContentModelFlag.RCDATA, name);
                            return;
                        }
                        if ("noscript" == name) {
                            if (this.scriptingEnabled) {
                                this.appendToCurrentNodeAndPushElement(name, attributes);
                                this.cdataOrRcdataTimesToPop = 1;
                                this.tokenizer.setContentModelFlag(ContentModelFlag.CDATA, name);
                            } else {
                                this.appendToCurrentNodeAndPushElementMayFoster(name, attributes);
                                this.mode = InsertionMode.IN_HEAD_NOSCRIPT;
                            }
                            return;
                        }
                        if ("script" == name || "style" == name) {
                            this.appendToCurrentNodeAndPushElementMayFoster(name, attributes);
                            this.cdataOrRcdataTimesToPop = 1;
                            this.tokenizer.setContentModelFlag(ContentModelFlag.CDATA, name);
                            return;
                        }
                        if ("head" == name) {
                            this.err("Start tag for \u201chead\u201d seen when \u201chead\u201d was already open.");
                            return;
                        }
                        this.pop();
                        this.mode = InsertionMode.AFTER_HEAD;
                        continue block25;
                    }
                }
                case IN_HEAD_NOSCRIPT: {
                    if ("html" == name) {
                        this.err("Stray \u201chtml\u201d start tag.");
                        this.addAttributesToElement(this.stack[0].node, attributes);
                        return;
                    }
                    if ("link" == name) {
                        this.appendVoidElementToCurrentMayFoster(name, attributes);
                        return;
                    }
                    if ("meta" == name) {
                        this.checkMetaCharset(attributes);
                        this.appendVoidElementToCurrentMayFoster(name, attributes);
                        return;
                    }
                    if ("style" == name) {
                        this.appendToCurrentNodeAndPushElement(name, attributes);
                        this.cdataOrRcdataTimesToPop = 1;
                        this.tokenizer.setContentModelFlag(ContentModelFlag.CDATA, name);
                        return;
                    }
                    if ("head" == name) {
                        this.err("Start tag for \u201chead\u201d seen when \u201chead\u201d was already open.");
                        return;
                    }
                    if ("noscript" == name) {
                        this.err("Start tag for \u201cnoscript\u201d seen when \u201cnoscript\u201d was already open.");
                        return;
                    }
                    this.err("Bad start tag in \u201cnoscript\u201d in \u201chead\u201d.");
                    this.pop();
                    this.mode = InsertionMode.IN_HEAD;
                    continue block25;
                }
                case IN_COLUMN_GROUP: {
                    if ("html" == name) {
                        this.err("Stray \u201chtml\u201d start tag.");
                        this.addAttributesToElement(this.stack[0].node, attributes);
                        return;
                    }
                    if ("col" == name) {
                        this.appendVoidElementToCurrentMayFoster(name, attributes);
                        return;
                    }
                    if (this.currentPtr == 0) {
                        assert (this.context != null);
                        this.err("Garbage in \u201ccolgroup\u201d fragment.");
                        return;
                    }
                    this.pop();
                    this.mode = InsertionMode.IN_TABLE;
                    continue block25;
                }
                case IN_SELECT_IN_TABLE: {
                    if ("caption" == name || "table" == name || "tbody" == name || "tfoot" == name || "thead" == name || "tr" == name || "td" == name || "th" == name) {
                        this.err("\u201c" + name + "\u201d start tag with \u201cselect\u201d open.");
                        this.endSelect();
                        continue block25;
                    }
                }
                case IN_SELECT: {
                    int eltPos;
                    if ("html" == name) {
                        this.err("Stray \u201chtml\u201d start tag.");
                        this.addAttributesToElement(this.stack[0].node, attributes);
                        return;
                    }
                    if ("option" == name) {
                        if (this.isCurrent("option")) {
                            this.pop();
                        }
                        this.appendToCurrentNodeAndPushElement(name, attributes);
                        return;
                    }
                    if ("optgroup" == name) {
                        if (this.isCurrent("option")) {
                            this.pop();
                        }
                        if (this.isCurrent("optgroup")) {
                            this.pop();
                        }
                        this.appendToCurrentNodeAndPushElement(name, attributes);
                        return;
                    }
                    if ("select" == name) {
                        this.err("\u201cselect\u201d start tag where end tag expected.");
                        eltPos = this.findLastInTableScope(name);
                        if (eltPos == Integer.MAX_VALUE) {
                            assert (this.context != null);
                            this.err("No \u201cselect\u201d in table scope.");
                            return;
                        }
                        while (this.currentPtr >= eltPos) {
                            this.pop();
                        }
                        this.resetTheInsertionMode();
                        return;
                    }
                    if ("input" == name) {
                        this.err("\u201cinput\u201d start tag seen in \u201cselect\u00901D.");
                        this.endSelect();
                        continue block25;
                    }
                    this.err("Stray \u201c" + name + "\u201d start tag.");
                    return;
                }
                case AFTER_BODY: {
                    if ("html" == name) {
                        this.err("Stray \u201chtml\u201d start tag.");
                        this.addAttributesToElement(this.stack[0].node, attributes);
                        return;
                    }
                    this.err("Stray \u201c" + name + "\u201d start tag.");
                    if (this.conformingAndStreaming) {
                        this.fatal();
                    }
                    this.mode = InsertionMode.IN_BODY;
                    continue block25;
                }
                case IN_FRAMESET: {
                    if ("frameset" == name) {
                        this.appendToCurrentNodeAndPushElement(name, attributes);
                        return;
                    }
                    if ("frame" == name) {
                        this.appendVoidElementToCurrentMayFoster(name, attributes);
                        return;
                    }
                }
                case AFTER_FRAMESET: {
                    if ("html" == name) {
                        this.err("Stray \u201chtml\u201d start tag.");
                        this.addAttributesToElement(this.stack[0].node, attributes);
                        return;
                    }
                    if ("noframes" == name) {
                        this.appendToCurrentNodeAndPushElement(name, attributes);
                        this.cdataOrRcdataTimesToPop = 1;
                        this.tokenizer.setContentModelFlag(ContentModelFlag.CDATA, name);
                        return;
                    }
                    this.err("Stray \u201c" + name + "\u201d start tag.");
                    return;
                }
                case INITIAL: {
                    if (this.doctypeExpectation != DoctypeExpectation.NO_DOCTYPE_ERRORS) {
                        this.err("Start tag seen without seeing a doctype first.");
                    }
                    this.documentModeInternal(DocumentMode.QUIRKS_MODE, null, null, false);
                    this.mode = InsertionMode.BEFORE_HTML;
                    continue block25;
                }
                case BEFORE_HTML: {
                    if ("html" == name) {
                        if (attributes.getLength() == 0) {
                            this.appendHtmlElementToDocumentAndPush();
                        } else {
                            this.appendHtmlElementToDocumentAndPush(attributes);
                        }
                        this.mode = InsertionMode.BEFORE_HEAD;
                        return;
                    }
                    this.appendHtmlElementToDocumentAndPush();
                    this.mode = InsertionMode.BEFORE_HEAD;
                    continue block25;
                }
                case BEFORE_HEAD: {
                    if ("html" == name) {
                        this.err("Stray \u201chtml\u201d start tag.");
                        this.addAttributesToElement(this.stack[0].node, attributes);
                        return;
                    }
                    if ("head" == name) {
                        this.appendToCurrentNodeAndPushHeadElement(attributes);
                        this.mode = InsertionMode.IN_HEAD;
                        return;
                    }
                    this.appendToCurrentNodeAndPushHeadElement(EmptyAttributes.EMPTY_ATTRIBUTES);
                    this.mode = InsertionMode.IN_HEAD;
                    continue block25;
                }
                case AFTER_HEAD: {
                    if ("html" == name) {
                        this.err("Stray \u201chtml\u201d start tag.");
                        this.addAttributesToElement(this.stack[0].node, attributes);
                        return;
                    }
                    if ("body" == name) {
                        if (attributes.getLength() == 0) {
                            this.appendToCurrentNodeAndPushBodyElement();
                        } else {
                            this.appendToCurrentNodeAndPushBodyElement(attributes);
                        }
                        this.mode = InsertionMode.IN_BODY;
                        return;
                    }
                    if ("frameset" == name) {
                        this.appendToCurrentNodeAndPushElement(name, attributes);
                        this.mode = InsertionMode.IN_FRAMESET;
                        return;
                    }
                    if ("base" == name) {
                        this.err("\u201cbase\u201d element outside \u201chead\u201d.");
                        if (!this.nonConformingAndStreaming) {
                            this.pushHeadPointerOntoStack();
                        }
                        this.appendVoidElementToCurrentMayFoster(name, attributes);
                        if (!this.nonConformingAndStreaming) {
                            this.pop();
                        }
                        return;
                    }
                    if ("link" == name) {
                        this.err("\u201clink\u201d element outside \u201chead\u201d.");
                        if (!this.nonConformingAndStreaming) {
                            this.pushHeadPointerOntoStack();
                        }
                        this.appendVoidElementToCurrentMayFoster(name, attributes);
                        if (!this.nonConformingAndStreaming) {
                            this.pop();
                        }
                        return;
                    }
                    if ("meta" == name) {
                        this.err("\u201cmeta\u201d element outside \u201chead\u201d.");
                        this.checkMetaCharset(attributes);
                        if (!this.nonConformingAndStreaming) {
                            this.pushHeadPointerOntoStack();
                        }
                        this.appendVoidElementToCurrentMayFoster(name, attributes);
                        if (!this.nonConformingAndStreaming) {
                            this.pop();
                        }
                        return;
                    }
                    if ("script" == name) {
                        this.err("\u201cscript\u201d element between \u201chead\u201d and \u201cbody\u201d.");
                        if (!this.nonConformingAndStreaming) {
                            this.pushHeadPointerOntoStack();
                        }
                        this.appendToCurrentNodeAndPushElement(name, attributes);
                        this.cdataOrRcdataTimesToPop = this.nonConformingAndStreaming ? 1 : 2;
                        this.tokenizer.setContentModelFlag(ContentModelFlag.CDATA, name);
                        return;
                    }
                    if ("style" == name) {
                        this.err("\u201cstyle\u201d element between \u201chead\u201d and \u201cbody\u201d.");
                        if (!this.nonConformingAndStreaming) {
                            this.pushHeadPointerOntoStack();
                        }
                        this.appendToCurrentNodeAndPushElement(name, attributes);
                        this.cdataOrRcdataTimesToPop = this.nonConformingAndStreaming ? 1 : 2;
                        this.tokenizer.setContentModelFlag(ContentModelFlag.CDATA, name);
                        return;
                    }
                    if ("title" == name) {
                        this.err("\u201ctitle\u201d element outside \u201chead\u201d.");
                        if (!this.nonConformingAndStreaming) {
                            this.pushHeadPointerOntoStack();
                        }
                        this.appendToCurrentNodeAndPushElement(name, attributes);
                        this.cdataOrRcdataTimesToPop = this.nonConformingAndStreaming ? 1 : 2;
                        this.tokenizer.setContentModelFlag(ContentModelFlag.RCDATA, name);
                        return;
                    }
                    this.appendToCurrentNodeAndPushBodyElement();
                    this.mode = InsertionMode.IN_BODY;
                    continue block25;
                }
                case AFTER_AFTER_BODY: {
                    this.err("Stray \u201c" + name + "\u201d start tag.");
                    if (this.conformingAndStreaming) {
                        this.fatal();
                    }
                    this.mode = InsertionMode.IN_BODY;
                    continue block25;
                }
                case AFTER_AFTER_FRAMESET: {
                    this.err("Stray \u201c" + name + "\u201d start tag.");
                    if (this.conformingAndStreaming) {
                        this.fatal();
                    }
                    this.mode = InsertionMode.IN_FRAMESET;
                    continue block25;
                }
            }
        }
    }

    private boolean equalsIgnoreAsciiCase(CharSequence one, CharSequence other) {
        if (other == null && one == null) {
            return true;
        }
        if (other == null || one == null) {
            return false;
        }
        if (one.length() != other.length()) {
            return false;
        }
        for (int i = 0; i < other.length(); ++i) {
            char c1;
            char c0 = one.charAt(i);
            if (c0 >= 'A' && c0 <= 'Z') {
                c0 = (char)(c0 + 32);
            }
            if ((c1 = other.charAt(i)) >= 'A' && c1 <= 'Z') {
                c1 = (char)(c1 + 32);
            }
            if (c0 == c1) continue;
            return false;
        }
        return true;
    }

    private void checkMetaCharset(Attributes attributes) throws SAXException {
        String content = attributes.getValue("", "content");
        String internalCharset = null;
        if (content != null && (internalCharset = MetaSniffer.extractCharsetFromContent(content)) != null && !this.equalsIgnoreAsciiCase("content-type", attributes.getValue("", "http-equiv"))) {
            this.warn("Attribute \u201ccontent\u201d would be sniffed as an internal character encoding declaration but there was no matching \u201chttp-equiv='Content-Type'\u201d attribute.");
        }
        if (internalCharset == null) {
            internalCharset = attributes.getValue("", "charset");
        }
        if (internalCharset != null) {
            this.tokenizer.internalEncodingDeclaration(internalCharset);
        }
    }

    @Override
    public final void endTag(String name, Attributes attributes) throws SAXException {
        this.needToDropLF = false;
        if (this.cdataOrRcdataTimesToPop > 0) {
            while (this.cdataOrRcdataTimesToPop > 0) {
                this.pop();
                --this.cdataOrRcdataTimesToPop;
            }
            return;
        }
        block23: while (true) {
            switch (this.mode) {
                case IN_ROW: {
                    int eltPos;
                    if ("tr" == name) {
                        eltPos = this.findLastOrRoot("tr");
                        if (eltPos == 0) {
                            assert (this.context != null);
                            this.err("No table row to close.");
                            return;
                        }
                        this.clearStackBackTo(eltPos);
                        this.pop();
                        this.mode = InsertionMode.IN_TABLE_BODY;
                        return;
                    }
                    if ("table" == name) {
                        eltPos = this.findLastOrRoot("tr");
                        if (eltPos == 0) {
                            assert (this.context != null);
                            this.err("No table row to close.");
                            return;
                        }
                        this.clearStackBackTo(eltPos);
                        this.pop();
                        this.mode = InsertionMode.IN_TABLE_BODY;
                        continue block23;
                    }
                    if ("tbody" == name || "thead" == name || "tfoot" == name) {
                        if (this.findLastInTableScope(name) == Integer.MAX_VALUE) {
                            this.err("Stray end tag \u201c" + name + "\u201d.");
                            return;
                        }
                        eltPos = this.findLastOrRoot("tr");
                        if (eltPos == 0) {
                            assert (this.context != null);
                            this.err("No table row to close.");
                            return;
                        }
                        this.clearStackBackTo(eltPos);
                        this.pop();
                        this.mode = InsertionMode.IN_TABLE_BODY;
                        continue block23;
                    }
                    if ("body" == name || "caption" == name || "col" == name || "colgroup" == name || "html" == name || "td" == name || "th" == name) {
                        this.err("Stray end tag \u201c" + name + "\u201d.");
                        return;
                    }
                }
                case IN_TABLE_BODY: {
                    int eltPos;
                    if ("tbody" == name || "tfoot" == name || "thead" == name) {
                        eltPos = this.findLastOrRoot(name);
                        if (eltPos == 0) {
                            this.err("Stray end tag \u201c" + name + "\u201d.");
                            return;
                        }
                        this.clearStackBackTo(eltPos);
                        this.pop();
                        this.mode = InsertionMode.IN_TABLE;
                        return;
                    }
                    if ("table" == name) {
                        eltPos = this.findLastInTableScopeOrRootTbodyTheadTfoot();
                        if (eltPos == 0) {
                            assert (this.context != null);
                            this.err("Stray end tag \u201ctable\u201d.");
                            return;
                        }
                        this.clearStackBackTo(eltPos);
                        this.pop();
                        this.mode = InsertionMode.IN_TABLE;
                        continue block23;
                    }
                    if ("body" == name || "caption" == name || "col" == name || "colgroup" == name || "html" == name || "td" == name || "th" == name || "tr" == name) {
                        this.err("Stray end tag \u201c" + name + "\u201d.");
                        return;
                    }
                }
                case IN_TABLE: {
                    int eltPos;
                    if ("table" == name) {
                        eltPos = this.findLast("table");
                        if (eltPos == Integer.MAX_VALUE) {
                            assert (this.context != null);
                            this.err("Stray end tag \u201ctable\u201d.");
                            return;
                        }
                        while (this.currentPtr >= eltPos) {
                            this.pop();
                        }
                        this.resetTheInsertionMode();
                        return;
                    }
                    if ("body" == name || "caption" == name || "col" == name || "colgroup" == name || "html" == name || "tbody" == name || "td" == name || "tfoot" == name || "th" == name || "thead" == name || "tr" == name) {
                        this.err("Stray end tag \u201c" + name + "\u201d.");
                        return;
                    }
                    this.err("Stray end tag \u201c" + name + "\u201d.");
                }
                case IN_CAPTION: {
                    int eltPos;
                    if ("caption" == name) {
                        eltPos = this.findLastInTableScope("caption");
                        if (eltPos == Integer.MAX_VALUE) {
                            return;
                        }
                        this.generateImpliedEndTags();
                        if (this.currentPtr != eltPos) {
                            this.err("Unclosed elements on stack.");
                        }
                        while (this.currentPtr >= eltPos) {
                            this.pop();
                        }
                        this.clearTheListOfActiveFormattingElementsUpToTheLastMarker();
                        this.mode = InsertionMode.IN_TABLE;
                        return;
                    }
                    if ("table" == name) {
                        this.err("\u201ctable\u201d closed but \u201ccaption\u201d was still open.");
                        eltPos = this.findLastInTableScope("caption");
                        if (eltPos == Integer.MAX_VALUE) {
                            return;
                        }
                        this.generateImpliedEndTags();
                        if (this.currentPtr != eltPos) {
                            this.err("Unclosed elements on stack.");
                        }
                        while (this.currentPtr >= eltPos) {
                            this.pop();
                        }
                        this.clearTheListOfActiveFormattingElementsUpToTheLastMarker();
                        this.mode = InsertionMode.IN_TABLE;
                        continue block23;
                    }
                    if ("body" == name || "col" == name || "colgroup" == name || "html" == name || "tbody" == name || "td" == name || "tfoot" == name || "th" == name || "thead" == name || "tr" == name) {
                        this.err("Stray end tag \u201c" + name + "\u201d.");
                        return;
                    }
                }
                case IN_CELL: {
                    int eltPos;
                    if ("td" == name || "th" == name) {
                        eltPos = this.findLastInTableScope(name);
                        if (eltPos == Integer.MAX_VALUE) {
                            this.err("Stray end tag \u201c" + name + "\u201d.");
                            return;
                        }
                        this.generateImpliedEndTags();
                        if (!this.isCurrent(name)) {
                            this.err("Unclosed elements.");
                        }
                        while (this.currentPtr >= eltPos) {
                            this.pop();
                        }
                        this.clearTheListOfActiveFormattingElementsUpToTheLastMarker();
                        this.mode = InsertionMode.IN_ROW;
                        return;
                    }
                    if ("table" == name || "tbody" == name || "tfoot" == name || "thead" == name || "tr" == name) {
                        if (this.findLastInTableScope(name) == Integer.MAX_VALUE) {
                            this.err("Stray end tag \u201c" + name + "\u201d.");
                            return;
                        }
                        this.closeTheCell(this.findLastInTableScopeTdTh());
                        continue block23;
                    }
                    if ("body" == name || "caption" == name || "col" == name || "colgroup" == name || "html" == name) {
                        this.err("Stray end tag \u201c" + name + "\u201d.");
                        return;
                    }
                }
                case IN_BODY: {
                    String stackName;
                    int i;
                    int eltPos;
                    if ("body" == name) {
                        if (!this.isSecondOnStackBody()) {
                            assert (this.context != null);
                            this.err("Stray end tag \u201cbody\u201d.");
                            return;
                        }
                        assert (this.currentPtr >= 1);
                        for (i = 2; i <= this.currentPtr; ++i) {
                            stackName = this.stack[i].name;
                            if ("dd" == stackName || "dt" == stackName || "li" == stackName || "p" == stackName) continue;
                            this.err("End tag for \u201cbody\u201d seen but there were unclosed elements.");
                            break;
                        }
                        if (this.conformingAndStreaming) {
                            while (this.currentPtr > 1) {
                                this.pop();
                            }
                        }
                        if (this.context == null) {
                            this.bodyCloseReported = true;
                            this.bodyClosed(this.stack[1].node);
                        }
                        this.mode = InsertionMode.AFTER_BODY;
                        return;
                    }
                    if ("html" == name) {
                        if (!this.isSecondOnStackBody()) {
                            assert (this.context != null);
                            this.err("Stray end tag \u201chtml\u201d.");
                            return;
                        }
                        for (i = 0; i <= this.currentPtr; ++i) {
                            stackName = this.stack[i].name;
                            if ("dd" == stackName || "dt" == stackName || "li" == stackName || "p" == stackName || "tbody" == stackName || "td" == stackName || "tfoot" == stackName || "th" == stackName || "thead" == stackName || "tr" == stackName || "body" == stackName || "html" == stackName) continue;
                            this.err("End tag for \u201chtml\u201d seen but there were unclosed elements.");
                            break;
                        }
                        if (this.context == null) {
                            this.bodyCloseReported = true;
                            this.bodyClosed(this.stack[1].node);
                        }
                        this.mode = InsertionMode.AFTER_BODY;
                        continue block23;
                    }
                    if ("div" == name || "blockquote" == name || "ul" == name || "ol" == name || "pre" == name || "dl" == name || "fieldset" == name || "address" == name || "center" == name || "dir" == name || "listing" == name || "menu" == name) {
                        eltPos = this.findLastInScope(name);
                        if (eltPos == Integer.MAX_VALUE) {
                            this.err("Stray end tag \u201c" + name + "\u201d.");
                        } else {
                            this.generateImpliedEndTags();
                            if (!this.isCurrent(name)) {
                                this.err("End tag \u201c" + name + "\u201d seen but there were unclosed elements.");
                            }
                            while (this.currentPtr >= eltPos) {
                                this.pop();
                            }
                        }
                        return;
                    }
                    if ("form" == name) {
                        this.formPointer = null;
                        eltPos = this.findLastInScope(name);
                        if (eltPos == Integer.MAX_VALUE) {
                            this.err("Stray end tag \u201c" + name + "\u201d.");
                        } else {
                            this.generateImpliedEndTags();
                            if (!this.isCurrent(name)) {
                                this.err("End tag \u201c" + name + "\u201d seen but there were unclosed elements.");
                            }
                            while (this.currentPtr >= eltPos) {
                                this.pop();
                            }
                        }
                        return;
                    }
                    if ("p" == name) {
                        if (!this.isCurrent(name)) {
                            this.err("End tag \u201cp\u201d seen but there were unclosed elements.");
                        }
                        if ((eltPos = this.findLastInScope(name)) != Integer.MAX_VALUE) {
                            while (this.currentPtr >= eltPos) {
                                this.pop();
                            }
                        } else {
                            this.appendVoidElementToCurrentMayFoster(name, EmptyAttributes.EMPTY_ATTRIBUTES);
                        }
                        return;
                    }
                    if ("dd" == name || "dt" == name || "li" == name) {
                        eltPos = this.findLastInScope(name);
                        if (eltPos == Integer.MAX_VALUE) {
                            this.err("Stray end tag \u201c" + name + "\u201d.");
                        } else {
                            this.generateImpliedEndTagsExceptFor(name);
                            if (!this.isCurrent(name)) {
                                this.err("End tag \u201c" + name + "\u201d seen but there were unclosed elements.");
                            }
                            while (this.currentPtr >= eltPos) {
                                this.pop();
                            }
                        }
                        return;
                    }
                    if ("h1" == name || "h2" == name || "h3" == name || "h4" == name || "h5" == name || "h6" == name) {
                        eltPos = this.findLastInScopeHn();
                        if (eltPos == Integer.MAX_VALUE) {
                            this.err("Stray end tag \u201c" + name + "\u201d.");
                        } else {
                            this.generateImpliedEndTags();
                            if (!this.isCurrent(name)) {
                                this.err("End tag \u201c" + name + "\u201d seen but there were unclosed elements.");
                            }
                            while (this.currentPtr >= eltPos) {
                                this.pop();
                            }
                        }
                        return;
                    }
                    if ("a" == name || "b" == name || "big" == name || "em" == name || "font" == name || "i" == name || "nobr" == name || "s" == name || "small" == name || "strike" == name || "strong" == name || "tt" == name || "u" == name) {
                        this.adoptionAgencyEndTag(name);
                        return;
                    }
                    if ("button" == name || "marquee" == name || "object" == name || "applet" == name) {
                        eltPos = this.findLastInScope(name);
                        if (eltPos == Integer.MAX_VALUE) {
                            this.err("Stray end tag \u201c" + name + "\u201d.");
                        } else {
                            this.generateImpliedEndTags();
                            if (!this.isCurrent(name)) {
                                this.err("End tag \u201c" + name + "\u201d seen but there were unclosed elements.");
                            }
                            while (this.currentPtr >= eltPos) {
                                this.pop();
                            }
                            this.clearTheListOfActiveFormattingElementsUpToTheLastMarker();
                        }
                        return;
                    }
                    if ("br" == name) {
                        this.err("End tag \u201cbr\u201d.");
                        this.reconstructTheActiveFormattingElements();
                        this.appendVoidElementToCurrentMayFoster(name, EmptyAttributes.EMPTY_ATTRIBUTES);
                        return;
                    }
                    if ("area" == name || "basefont" == name || "bgsound" == name || "embed" == name || "hr" == name || "iframe" == name || "image" == name || "img" == name || "input" == name || "isindex" == name || "noembed" == name || "noframes" == name || "param" == name || "select" == name || "spacer" == name || "table" == name || "textarea" == name || "wbr" == name || this.scriptingEnabled && "noscript" == name) {
                        this.err("Stray end tag \u201c" + name + "\u201d.");
                        return;
                    }
                    if (this.isCurrent(name)) {
                        this.pop();
                        return;
                    }
                    while (true) {
                        this.generateImpliedEndTags();
                        if (this.isCurrent(name)) {
                            this.pop();
                            return;
                        }
                        StackNode<T> node = this.stack[this.currentPtr];
                        if (node.scoping || node.special) break;
                        this.err("Unclosed element \u201c" + node.name + "\u201d.");
                        this.pop();
                    }
                    this.err("Stray end tag \u201c" + name + "\u201d.");
                    return;
                }
                case IN_COLUMN_GROUP: {
                    if ("colgroup" == name) {
                        if (this.currentPtr == 0) {
                            assert (this.context != null);
                            this.err("Garbage in \u201ccolgroup\u201d fragment.");
                            return;
                        }
                        this.pop();
                        this.mode = InsertionMode.IN_TABLE;
                        return;
                    }
                    if ("col" == name) {
                        this.err("Stray end tag \u201ccol\u201d.");
                        return;
                    }
                    if (this.currentPtr == 0) {
                        assert (this.context != null);
                        this.err("Garbage in \u201ccolgroup\u201d fragment.");
                        return;
                    }
                    this.pop();
                    this.mode = InsertionMode.IN_TABLE;
                    continue block23;
                }
                case IN_SELECT_IN_TABLE: {
                    if ("caption" == name || "table" == name || "tbody" == name || "tfoot" == name || "thead" == name || "tr" == name || "td" == name || "th" == name) {
                        this.err("\u201c" + name + "\u201d end tag with \u201cselect\u201d open.");
                        if (this.findLastInTableScope(name) != Integer.MAX_VALUE) {
                            this.endSelect();
                            continue block23;
                        }
                        return;
                    }
                }
                case IN_SELECT: {
                    if ("option" == name) {
                        if (this.isCurrent("option")) {
                            this.pop();
                            return;
                        }
                        this.err("Stray end tag \u201coption\u201d");
                        return;
                    }
                    if ("optgroup" == name) {
                        if (this.isCurrent("option") && "optgroup" == this.stack[this.currentPtr - 1].name) {
                            this.pop();
                        }
                        if (this.isCurrent("optgroup")) {
                            this.pop();
                        } else {
                            this.err("Stray end tag \u201coptgroup\u201d");
                        }
                        return;
                    }
                    if ("select" == name) {
                        this.endSelect();
                        return;
                    }
                    this.err("Stray end tag \u201c" + name + "\u201d");
                    return;
                }
                case AFTER_BODY: {
                    if ("html" == name) {
                        if (this.context != null) {
                            this.err("Stray end tag \u201chtml\u201d");
                            return;
                        }
                        if (this.context == null) {
                            this.htmlCloseReported = true;
                            this.htmlClosed(this.stack[0].node);
                        }
                        this.mode = InsertionMode.AFTER_AFTER_BODY;
                        return;
                    }
                    this.err("Saw an end tag after \u201cbody\u201d had been closed.");
                    if (this.conformingAndStreaming) {
                        this.fatal();
                    }
                    this.mode = InsertionMode.IN_BODY;
                    continue block23;
                }
                case IN_FRAMESET: {
                    if ("frameset" == name) {
                        if (this.currentPtr == 0) {
                            assert (this.context != null);
                            this.err("Stray end tag \u201cframeset\u201d");
                            return;
                        }
                        this.pop();
                        if (this.context == null && !this.isCurrent("frameset")) {
                            this.mode = InsertionMode.AFTER_FRAMESET;
                        }
                        return;
                    }
                    this.err("Stray end tag \u201c" + name + "\u201d");
                    return;
                }
                case AFTER_FRAMESET: {
                    if ("html" == name) {
                        if (this.context == null) {
                            this.htmlCloseReported = true;
                            this.htmlClosed(this.stack[0].node);
                        }
                        this.mode = InsertionMode.AFTER_AFTER_FRAMESET;
                        return;
                    }
                    this.err("Stray end tag \u201c" + name + "\u201d");
                    return;
                }
                case INITIAL: {
                    if (this.doctypeExpectation != DoctypeExpectation.NO_DOCTYPE_ERRORS) {
                        this.err("End tag seen without seeing a doctype first.");
                    }
                    this.documentModeInternal(DocumentMode.QUIRKS_MODE, null, null, false);
                    this.mode = InsertionMode.BEFORE_HTML;
                    continue block23;
                }
                case BEFORE_HTML: {
                    this.appendHtmlElementToDocumentAndPush();
                    this.mode = InsertionMode.BEFORE_HEAD;
                    continue block23;
                }
                case BEFORE_HEAD: {
                    if ("head" == name || "body" == name || "html" == name || "p" == name || "br" == name) {
                        this.appendToCurrentNodeAndPushHeadElement(EmptyAttributes.EMPTY_ATTRIBUTES);
                        this.mode = InsertionMode.IN_HEAD;
                        continue block23;
                    }
                    this.err("Stray end tag \u201c" + name + "\u201d.");
                    return;
                }
                case IN_HEAD: {
                    if ("head" == name) {
                        this.pop();
                        this.mode = InsertionMode.AFTER_HEAD;
                        return;
                    }
                    if ("body" == name || "html" == name || "p" == name || "br" == name) {
                        this.pop();
                        this.mode = InsertionMode.AFTER_HEAD;
                        continue block23;
                    }
                    this.err("Stray end tag \u201c" + name + "\u201d.");
                    return;
                }
                case IN_HEAD_NOSCRIPT: {
                    if ("noscript" == name) {
                        this.pop();
                        this.mode = InsertionMode.IN_HEAD;
                        return;
                    }
                    if ("p" == name || "br" == name) {
                        this.err("Stray end tag \u201c" + name + "\u201d.");
                        this.pop();
                        this.mode = InsertionMode.IN_HEAD;
                        continue block23;
                    }
                    this.err("Stray end tag \u201c" + name + "\u201d.");
                    return;
                }
                case AFTER_HEAD: {
                    this.appendToCurrentNodeAndPushBodyElement();
                    this.mode = InsertionMode.IN_BODY;
                    continue block23;
                }
                case AFTER_AFTER_BODY: {
                    this.err("Stray \u201c" + name + "\u201d end tag.");
                    if (this.conformingAndStreaming) {
                        this.fatal();
                    }
                    this.mode = InsertionMode.IN_BODY;
                    continue block23;
                }
                case AFTER_AFTER_FRAMESET: {
                    this.err("Stray \u201c" + name + "\u201d end tag.");
                    if (this.conformingAndStreaming) {
                        this.fatal();
                    }
                    this.mode = InsertionMode.IN_FRAMESET;
                    continue block23;
                }
            }
        }
    }

    private void endSelect() throws SAXException {
        int eltPos = this.findLastInTableScope("select");
        if (eltPos == Integer.MAX_VALUE) {
            assert (this.context != null);
            this.err("Stray end tag \u201cselect\u201d");
            return;
        }
        while (this.currentPtr >= eltPos) {
            this.pop();
        }
        this.resetTheInsertionMode();
    }

    private int findLastInTableScopeOrRootTbodyTheadTfoot() {
        for (int i = this.currentPtr; i > 0; --i) {
            if (this.stack[i].name != "tbody" && this.stack[i].name != "thead" && this.stack[i].name != "tfoot") continue;
            return i;
        }
        return 0;
    }

    private int findLast(String name) {
        for (int i = this.currentPtr; i > 0; --i) {
            if (this.stack[i].name != name) continue;
            return i;
        }
        return Integer.MAX_VALUE;
    }

    private int findLastInTableScope(String name) {
        for (int i = this.currentPtr; i > 0; --i) {
            if (this.stack[i].name == name) {
                return i;
            }
            if (this.stack[i].name != "table") continue;
            return Integer.MAX_VALUE;
        }
        return Integer.MAX_VALUE;
    }

    private int findLastInScope(String name) {
        for (int i = this.currentPtr; i > 0; --i) {
            if (this.stack[i].name == name) {
                return i;
            }
            if (!this.stack[i].scoping) continue;
            return Integer.MAX_VALUE;
        }
        return Integer.MAX_VALUE;
    }

    private int findLastInScopeHn() {
        for (int i = this.currentPtr; i > 0; --i) {
            String name = this.stack[i].name;
            if ("h1" == name || "h2" == name || "h3" == name || "h4" == name || "h5" == name || "h6" == name) {
                return i;
            }
            if (!this.stack[i].scoping) continue;
            return Integer.MAX_VALUE;
        }
        return Integer.MAX_VALUE;
    }

    private void generateImpliedEndTagsExceptFor(String name) throws SAXException {
        String stackName;
        while (name != (stackName = this.stack[this.currentPtr].name) && ("p" == stackName || "li" == stackName || "dd" == stackName || "dt" == stackName)) {
            this.pop();
        }
    }

    private void generateImpliedEndTags() throws SAXException {
        String stackName;
        while ("p" == (stackName = this.stack[this.currentPtr].name) || "li" == stackName || "dd" == stackName || "dt" == stackName) {
            this.pop();
        }
    }

    private boolean isSecondOnStackBody() {
        return this.currentPtr >= 1 && this.stack[1].name == "body";
    }

    private void documentModeInternal(DocumentMode mode, String publicIdentifier, String systemIdentifier, boolean html4SpecificAdditionalErrorChecks) throws SAXException {
        if (this.documentModeHandler != null) {
            this.documentModeHandler.documentMode(mode, publicIdentifier, systemIdentifier, html4SpecificAdditionalErrorChecks);
        }
        this.documentMode(mode, publicIdentifier, systemIdentifier, html4SpecificAdditionalErrorChecks);
    }

    private boolean isAlmostStandards(String publicIdentifierLC, String systemIdentifierLC) {
        if ("-//w3c//dtd xhtml 1.0 transitional//en".equals(publicIdentifierLC)) {
            return true;
        }
        if ("-//w3c//dtd xhtml 1.0 frameset//en".equals(publicIdentifierLC)) {
            return true;
        }
        if (systemIdentifierLC != null) {
            if ("-//w3c//dtd html 4.01 transitional//en".equals(publicIdentifierLC)) {
                return true;
            }
            if ("-//w3c//dtd html 4.01 frameset//en".equals(publicIdentifierLC)) {
                return true;
            }
        }
        return false;
    }

    private boolean isQuirky(String name, String publicIdentifierLC, String systemIdentifierLC, boolean forceQuirks) {
        if (forceQuirks) {
            return true;
        }
        if (!"HTML".equalsIgnoreCase(name)) {
            return true;
        }
        if (publicIdentifierLC != null && Arrays.binarySearch(QUIRKY_PUBLIC_IDS, publicIdentifierLC) > -1) {
            return true;
        }
        if (systemIdentifierLC == null) {
            if ("-//w3c//dtd html 4.01 transitional//en".equals(publicIdentifierLC)) {
                return true;
            }
            if ("-//w3c//dtd html 4.01 frameset//en".equals(publicIdentifierLC)) {
                return true;
            }
        } else if ("http://www.ibm.com/data/dtd/v11/ibmxhtml1-transitional.dtd".equals(systemIdentifierLC)) {
            return true;
        }
        return false;
    }

    private String toAsciiLowerCase(String str) {
        if (str == null) {
            return null;
        }
        char[] buf = new char[str.length()];
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c >= 'A' && c <= 'Z') {
                c = (char)(c + 32);
            }
            buf[i] = c;
        }
        return new String(buf);
    }

    private void closeTheCell(int eltPos) throws SAXException {
        this.generateImpliedEndTags();
        if (eltPos != this.currentPtr) {
            this.err("Unclosed elements.");
        }
        while (this.currentPtr >= eltPos) {
            this.pop();
        }
        this.clearTheListOfActiveFormattingElementsUpToTheLastMarker();
        this.mode = InsertionMode.IN_ROW;
    }

    private int findLastInTableScopeTdTh() {
        for (int i = this.currentPtr; i > 0; --i) {
            String name = this.stack[i].name;
            if ("td" == name || "th" == name) {
                return i;
            }
            if (name != "table") continue;
            return Integer.MAX_VALUE;
        }
        return Integer.MAX_VALUE;
    }

    private void clearStackBackTo(int eltPos) throws SAXException {
        if (eltPos != this.currentPtr) {
            while (this.currentPtr > eltPos) {
                this.pop();
            }
        }
    }

    private void resetTheInsertionMode() {
        for (int i = this.currentPtr; i >= 0; --i) {
            String name = this.stack[i].name;
            if (i == 0) {
                if (this.context != "td" && this.context != "th") {
                    name = this.context;
                } else {
                    this.mode = InsertionMode.IN_BODY;
                    return;
                }
            }
            if ("select" == name) {
                this.mode = InsertionMode.IN_SELECT;
                return;
            }
            if ("td" == name || "th" == name) {
                this.mode = InsertionMode.IN_CELL;
                return;
            }
            if ("tr" == name) {
                this.mode = InsertionMode.IN_ROW;
                return;
            }
            if ("tbody" == name || "thead" == name || "tfoot" == name) {
                this.mode = InsertionMode.IN_TABLE_BODY;
                return;
            }
            if ("caption" == name) {
                this.mode = InsertionMode.IN_CAPTION;
                return;
            }
            if ("colgroup" == name) {
                this.mode = InsertionMode.IN_COLUMN_GROUP;
                return;
            }
            if ("table" == name) {
                this.mode = InsertionMode.IN_TABLE;
                return;
            }
            if ("head" == name) {
                this.mode = InsertionMode.IN_BODY;
                return;
            }
            if ("body" == name) {
                this.mode = InsertionMode.IN_BODY;
                return;
            }
            if ("frameset" == name) {
                this.mode = InsertionMode.IN_FRAMESET;
                return;
            }
            if ("html" == name) {
                this.mode = this.headPointer == null ? InsertionMode.BEFORE_HEAD : InsertionMode.AFTER_HEAD;
                return;
            }
            if (i != 0) continue;
            this.mode = InsertionMode.IN_BODY;
            return;
        }
    }

    private void implicitlyCloseP() throws SAXException {
        int eltPos = this.findLastInScope("p");
        if (eltPos == Integer.MAX_VALUE) {
            return;
        }
        if (this.currentPtr != eltPos) {
            this.err("Unclosed elements.");
        }
        while (this.currentPtr >= eltPos) {
            this.pop();
        }
    }

    private boolean clearLastStackSlot() {
        this.stack[this.currentPtr] = null;
        return true;
    }

    private boolean clearLastListSlot() {
        this.listOfActiveFormattingElements[this.listPtr] = null;
        return true;
    }

    private void push(StackNode<T> node) throws SAXException {
        ++this.currentPtr;
        if (this.currentPtr == this.stack.length) {
            StackNode[] newStack = new StackNode[this.stack.length + 64];
            System.arraycopy(this.stack, 0, newStack, 0, this.stack.length);
            this.stack = newStack;
        }
        this.stack[this.currentPtr] = node;
        this.elementPushed(node.name, node.node);
    }

    private void append(StackNode<T> node) {
        ++this.listPtr;
        if (this.listPtr == this.listOfActiveFormattingElements.length) {
            StackNode[] newList = new StackNode[this.listOfActiveFormattingElements.length + 64];
            System.arraycopy(this.listOfActiveFormattingElements, 0, newList, 0, this.listOfActiveFormattingElements.length);
            this.listOfActiveFormattingElements = newList;
        }
        this.listOfActiveFormattingElements[this.listPtr] = node;
    }

    private void insertMarker() {
        this.append(this.MARKER);
    }

    private void clearTheListOfActiveFormattingElementsUpToTheLastMarker() {
        while (this.listPtr > -1) {
            if (this.listOfActiveFormattingElements[this.listPtr--] != this.MARKER) continue;
            return;
        }
    }

    private boolean isCurrent(String name) {
        return name == this.stack[this.currentPtr].name;
    }

    private void removeFromStack(int pos) throws SAXException {
        if (this.currentPtr == pos) {
            this.pop();
        } else if (this.conformingAndStreaming) {
            this.fatal();
        } else {
            if (this.nonConformingAndStreaming) {
                throw new UnsupportedOperationException();
            }
            System.arraycopy(this.stack, pos + 1, this.stack, pos, this.currentPtr - pos);
            assert (this.clearLastStackSlot());
            --this.currentPtr;
        }
    }

    private void removeFromStack(StackNode<T> node) throws SAXException {
        if (this.stack[this.currentPtr] == node) {
            this.pop();
        } else {
            int pos;
            for (pos = this.currentPtr - 1; pos >= 0 && this.stack[pos] != node; --pos) {
            }
            if (pos == -1) {
                return;
            }
            if (this.conformingAndStreaming) {
                this.fatal();
            } else {
                if (this.nonConformingAndStreaming) {
                    throw new UnsupportedOperationException();
                }
                System.arraycopy(this.stack, pos + 1, this.stack, pos, this.currentPtr - pos);
                --this.currentPtr;
            }
        }
    }

    private void removeFromListOfActiveFormattingElements(int pos) {
        if (pos == this.listPtr) {
            assert (this.clearLastListSlot());
            --this.listPtr;
            return;
        }
        assert (pos < this.listPtr);
        System.arraycopy(this.listOfActiveFormattingElements, pos + 1, this.listOfActiveFormattingElements, pos, this.listPtr - pos);
        assert (this.clearLastListSlot());
        --this.listPtr;
    }

    private void adoptionAgencyEndTag(String name) throws SAXException {
        this.flushCharacters();
        while (true) {
            int furthestBlockPos;
            StackNode<T> node;
            int formattingEltStackPos;
            String listName;
            int formattingEltListPos;
            for (formattingEltListPos = this.listPtr; formattingEltListPos > -1 && (listName = this.listOfActiveFormattingElements[formattingEltListPos].name) != name; --formattingEltListPos) {
                if (listName != null) continue;
                formattingEltListPos = -1;
                break;
            }
            if (formattingEltListPos == -1) {
                this.err("No element \u201c" + name + "\u201d to close.");
                return;
            }
            StackNode<T> formattingElt = this.listOfActiveFormattingElements[formattingEltListPos];
            boolean inScope = true;
            for (formattingEltStackPos = this.currentPtr; formattingEltStackPos > -1 && (node = this.stack[formattingEltStackPos]) != formattingElt; --formattingEltStackPos) {
                if (!node.scoping) continue;
                inScope = false;
            }
            if (formattingEltStackPos == -1) {
                this.err("No element \u201c" + name + "\u201d to close.");
                this.removeFromListOfActiveFormattingElements(formattingEltListPos);
                return;
            }
            if (!inScope) {
                this.err("No element \u201c" + name + "\u201d to close.");
                return;
            }
            if (formattingEltStackPos != this.currentPtr) {
                this.err("End tag \u201c" + name + "\u201d violates nesting rules.");
            }
            for (furthestBlockPos = formattingEltStackPos + 1; furthestBlockPos <= this.currentPtr; ++furthestBlockPos) {
                StackNode<T> node2 = this.stack[furthestBlockPos];
                if (node2.scoping || node2.special) break;
            }
            if (furthestBlockPos > this.currentPtr) {
                while (this.currentPtr >= formattingEltStackPos) {
                    this.pop();
                }
                this.removeFromListOfActiveFormattingElements(formattingEltListPos);
                return;
            }
            StackNode<T> commonAncestor = this.stack[formattingEltStackPos - 1];
            StackNode<T> furthestBlock = this.stack[furthestBlockPos];
            this.detachFromParent(furthestBlock.node);
            int bookmark = formattingEltListPos;
            int nodePos = furthestBlockPos;
            StackNode<T> lastNode = furthestBlock;
            while (true) {
                StackNode<Object> node3;
                int nodeListPos;
                if ((nodeListPos = this.findInListOfActiveFormattingElements(node3 = this.stack[--nodePos])) == -1) {
                    assert (formattingEltStackPos < nodePos);
                    assert (bookmark < nodePos);
                    assert (furthestBlockPos > nodePos);
                    this.removeFromStack(nodePos);
                    --furthestBlockPos;
                    continue;
                }
                if (nodePos == formattingEltStackPos) break;
                if (nodePos == furthestBlockPos) {
                    bookmark = nodeListPos + 1;
                }
                if (this.hasChildren(node3.node)) {
                    assert (node3 == this.listOfActiveFormattingElements[nodeListPos]);
                    assert (node3 == this.stack[nodePos]);
                    Object clone = this.shallowClone(node3.node);
                    node3 = new StackNode(node3.name, clone, node3.scoping, node3.special, node3.fosterParenting);
                    this.listOfActiveFormattingElements[nodeListPos] = node3;
                    this.stack[nodePos] = node3;
                }
                this.detachFromParentAndAppendToNewParent(lastNode.node, node3.node);
                lastNode = node3;
            }
            if (commonAncestor.fosterParenting) {
                if (this.conformingAndStreaming) {
                    this.fatal();
                }
                this.insertIntoFosterParent(lastNode.node);
            } else {
                this.detachFromParentAndAppendToNewParent(lastNode.node, commonAncestor.node);
            }
            Object clone = this.shallowClone(formattingElt.node);
            StackNode formattingClone = new StackNode(formattingElt.name, clone, formattingElt.scoping, formattingElt.special, formattingElt.fosterParenting);
            this.appendChildrenToNewParent(furthestBlock.node, clone);
            this.detachFromParentAndAppendToNewParent(clone, furthestBlock.node);
            this.removeFromListOfActiveFormattingElements(formattingEltListPos);
            this.insertIntoListOfActiveFormattingElements(formattingClone, bookmark);
            assert (formattingEltStackPos < furthestBlockPos);
            this.removeFromStack(formattingEltStackPos);
            this.insertIntoStack(formattingClone, furthestBlockPos);
        }
    }

    private void insertIntoStack(StackNode<T> node, int position) throws SAXException {
        assert (this.currentPtr + 1 < this.stack.length);
        assert (position <= this.currentPtr + 1);
        if (position == this.currentPtr + 1) {
            this.flushCharacters();
            this.push(node);
        } else {
            System.arraycopy(this.stack, position, this.stack, position + 1, this.currentPtr - position + 1);
            ++this.currentPtr;
            this.stack[position] = node;
        }
    }

    private void insertIntoListOfActiveFormattingElements(StackNode<T> formattingClone, int bookmark) {
        assert (this.listPtr + 1 < this.listOfActiveFormattingElements.length);
        if (bookmark <= this.listPtr) {
            System.arraycopy(this.listOfActiveFormattingElements, bookmark, this.listOfActiveFormattingElements, bookmark + 1, this.listPtr - bookmark + 1);
        }
        ++this.listPtr;
        this.listOfActiveFormattingElements[bookmark] = formattingClone;
    }

    private int findInListOfActiveFormattingElements(StackNode<T> node) {
        for (int i = this.listPtr; i >= 0; --i) {
            if (node != this.listOfActiveFormattingElements[i]) continue;
            return i;
        }
        return -1;
    }

    private int findInListOfActiveFormattingElementsContainsBetweenEndAndLastMarker(String name) {
        for (int i = this.listPtr; i >= 0; --i) {
            StackNode<T> node = this.listOfActiveFormattingElements[i];
            if (node.name == name) {
                return i;
            }
            if (node != this.MARKER) continue;
            return -1;
        }
        return -1;
    }

    private int findDdOrDtToPop() {
        for (int i = this.currentPtr; i >= 0; --i) {
            StackNode<T> node = this.stack[i];
            if ("dd" == node.name || "dt" == node.name) {
                return i;
            }
            if (!node.scoping && !node.special || "div" == node.name || "address" == node.name) continue;
            return Integer.MAX_VALUE;
        }
        return Integer.MAX_VALUE;
    }

    private int findLiToPop() {
        for (int i = this.currentPtr; i >= 0; --i) {
            StackNode<T> node = this.stack[i];
            if ("li" == node.name) {
                return i;
            }
            if (!node.scoping && !node.special || "div" == node.name || "address" == node.name) continue;
            return Integer.MAX_VALUE;
        }
        return Integer.MAX_VALUE;
    }

    private int findLastOrRoot(String name) {
        for (int i = this.currentPtr; i > 0; --i) {
            if (this.stack[i].name != name) continue;
            return i;
        }
        return 0;
    }

    private void addAttributesToBody(Attributes attributes) throws SAXException {
        if (this.currentPtr >= 1) {
            StackNode<T> body = this.stack[1];
            if (body.name == "body") {
                this.addAttributesToElement(body.node, attributes);
            }
        }
    }

    private void pushHeadPointerOntoStack() throws SAXException {
        this.flushCharacters();
        if (this.conformingAndStreaming) {
            this.fatal();
        }
        if (this.headPointer == null) {
            assert (this.context != null);
            this.push(this.stack[this.currentPtr]);
        } else {
            this.push(new StackNode<T>("head", this.headPointer));
        }
    }

    private void reconstructTheActiveFormattingElements() throws SAXException {
        if (this.listPtr == -1) {
            return;
        }
        StackNode<T> mostRecent = this.listOfActiveFormattingElements[this.listPtr];
        if (mostRecent == this.MARKER || this.isInStack(mostRecent)) {
            return;
        }
        int entryPos = this.listPtr;
        while (--entryPos != -1 && this.listOfActiveFormattingElements[entryPos] != this.MARKER && !this.isInStack(this.listOfActiveFormattingElements[entryPos])) {
        }
        if (entryPos < this.listPtr) {
            this.flushCharacters();
        }
        while (entryPos < this.listPtr) {
            StackNode<T> entry = this.listOfActiveFormattingElements[++entryPos];
            Object clone = this.shallowClone(entry.node);
            StackNode entryClone = new StackNode(entry.name, clone, entry.scoping, entry.special, entry.fosterParenting);
            StackNode<T> currentNode = this.stack[this.currentPtr];
            if (currentNode.fosterParenting) {
                this.insertIntoFosterParent(clone);
            } else {
                this.detachFromParentAndAppendToNewParent(clone, currentNode.node);
            }
            this.push(entryClone);
            this.listOfActiveFormattingElements[entryPos] = entryClone;
        }
    }

    private void insertIntoFosterParent(T child) throws SAXException {
        int eltPos = this.findLastOrRoot("table");
        StackNode<T> node = this.stack[eltPos];
        node.tainted = true;
        Object elt = node.node;
        if (eltPos == 0) {
            this.detachFromParentAndAppendToNewParent(child, elt);
            return;
        }
        Object parent = this.parentElementFor(elt);
        if (parent == null) {
            this.detachFromParentAndAppendToNewParent(child, this.stack[eltPos - 1].node);
        } else {
            this.insertBefore(child, elt, parent);
        }
    }

    private boolean isInStack(StackNode<T> node) {
        for (int i = this.currentPtr; i >= 0; --i) {
            if (this.stack[i] != node) continue;
            return true;
        }
        return false;
    }

    private void pop() throws SAXException {
        this.flushCharacters();
        StackNode<T> node = this.stack[this.currentPtr];
        assert (this.clearLastStackSlot());
        --this.currentPtr;
        this.elementPopped(node.name, node.node);
    }

    private void appendCharMayFoster(char[] buf, int i) throws SAXException {
        StackNode<T> current = this.stack[this.currentPtr];
        if (current.fosterParenting) {
            if (this.conformingAndStreaming) {
                this.fatal();
            } else {
                if (this.nonConformingAndStreaming) {
                    return;
                }
                int eltPos = this.findLastOrRoot("table");
                StackNode<T> node = this.stack[eltPos];
                node.tainted = true;
                Object elt = node.node;
                if (eltPos == 0) {
                    this.appendCharacters(elt, buf, i, 1);
                    return;
                }
                Object parent = this.parentElementFor(elt);
                if (parent == null) {
                    this.appendCharacters(this.stack[eltPos - 1].node, buf, i, 1);
                } else {
                    this.insertCharactersBefore(buf, i, 1, elt, parent);
                }
            }
        } else {
            this.accumulateCharacters(buf, i, 1);
        }
    }

    private boolean isTainted() {
        int eltPos = this.findLastOrRoot("table");
        StackNode<T> node = this.stack[eltPos];
        return node.tainted;
    }

    private void appendHtmlElementToDocumentAndPush(Attributes attributes) throws SAXException {
        T elt = this.createHtmlElementSetAsRoot(attributes);
        StackNode<T> node = new StackNode<T>("html", elt);
        this.push(node);
    }

    private void appendHtmlElementToDocumentAndPush() throws SAXException {
        this.appendHtmlElementToDocumentAndPush(this.tokenizer.newAttributes());
    }

    private void appendToCurrentNodeAndPushHeadElement(Attributes attributes) throws SAXException {
        this.flushCharacters();
        T elt = this.createElement("head", attributes);
        this.detachFromParentAndAppendToNewParent(elt, this.stack[this.currentPtr].node);
        this.headPointer = elt;
        StackNode<T> node = new StackNode<T>("head", elt);
        this.push(node);
    }

    private void appendToCurrentNodeAndPushBodyElement(Attributes attributes) throws SAXException {
        this.appendToCurrentNodeAndPushElement("body", attributes);
    }

    private void appendToCurrentNodeAndPushBodyElement() throws SAXException {
        this.appendToCurrentNodeAndPushBodyElement(this.tokenizer.newAttributes());
    }

    private void appendToCurrentNodeAndPushFormElementMayFoster(Attributes attributes) throws SAXException {
        this.flushCharacters();
        T elt = this.createElement("form", attributes);
        this.formPointer = elt;
        StackNode<T> current = this.stack[this.currentPtr];
        if (current.fosterParenting) {
            if (this.conformingAndStreaming) {
                this.fatal();
            } else {
                if (this.nonConformingAndStreaming) {
                    return;
                }
                this.insertIntoFosterParent(elt);
            }
        } else {
            this.detachFromParentAndAppendToNewParent(elt, current.node);
        }
        StackNode<T> node = new StackNode<T>("form", elt);
        this.push(node);
    }

    private void appendToCurrentNodeAndPushFormattingElementMayFoster(String name, Attributes attributes) throws SAXException {
        this.flushCharacters();
        T elt = this.createElement(name, attributes, this.formPointer);
        StackNode<T> current = this.stack[this.currentPtr];
        if (current.fosterParenting) {
            if (this.conformingAndStreaming) {
                this.fatal();
            } else {
                if (this.nonConformingAndStreaming) {
                    return;
                }
                this.insertIntoFosterParent(elt);
            }
        } else {
            this.detachFromParentAndAppendToNewParent(elt, current.node);
        }
        StackNode<T> node = new StackNode<T>(name, elt);
        this.push(node);
        this.append(node);
    }

    private void appendToCurrentNodeAndPushElement(String name, Attributes attributes) throws SAXException {
        this.flushCharacters();
        T elt = this.createElement(name, attributes);
        this.detachFromParentAndAppendToNewParent(elt, this.stack[this.currentPtr].node);
        StackNode<T> node = new StackNode<T>(name, elt);
        this.push(node);
    }

    private void appendToCurrentNodeAndPushElementMayFoster(String name, Attributes attributes) throws SAXException {
        this.flushCharacters();
        T elt = this.createElement(name, attributes);
        StackNode<T> current = this.stack[this.currentPtr];
        if (current.fosterParenting) {
            if (this.conformingAndStreaming) {
                this.fatal();
            } else {
                if (this.nonConformingAndStreaming) {
                    return;
                }
                this.insertIntoFosterParent(elt);
            }
        } else {
            this.detachFromParentAndAppendToNewParent(elt, current.node);
        }
        StackNode<T> node = new StackNode<T>(name, elt);
        this.push(node);
    }

    private void appendToCurrentNodeAndPushElementMayFoster(String name, Attributes attributes, T form) throws SAXException {
        this.flushCharacters();
        T elt = this.createElement(name, attributes, this.formPointer);
        StackNode<T> current = this.stack[this.currentPtr];
        if (current.fosterParenting) {
            if (this.conformingAndStreaming) {
                this.fatal();
            } else {
                if (this.nonConformingAndStreaming) {
                    return;
                }
                this.insertIntoFosterParent(elt);
            }
        } else {
            this.detachFromParentAndAppendToNewParent(elt, current.node);
        }
        StackNode<T> node = new StackNode<T>(name, elt);
        this.push(node);
    }

    private void appendVoidElementToCurrentMayFoster(String name, Attributes attributes, T form) throws SAXException {
        this.flushCharacters();
        T elt = this.createElement(name, attributes, this.formPointer);
        StackNode<T> current = this.stack[this.currentPtr];
        if (current.fosterParenting) {
            if (this.conformingAndStreaming) {
                this.fatal();
            } else {
                if (this.nonConformingAndStreaming) {
                    return;
                }
                this.insertIntoFosterParent(elt);
            }
        } else {
            this.detachFromParentAndAppendToNewParent(elt, current.node);
        }
        if (this.conformingAndStreaming || this.nonConformingAndStreaming) {
            this.elementPushed(name, attributes);
            this.elementPopped(name, null);
        }
    }

    private void appendVoidElementToCurrentMayFoster(String name, Attributes attributes) throws SAXException {
        this.flushCharacters();
        T elt = this.createElement(name, attributes);
        StackNode<T> current = this.stack[this.currentPtr];
        if (current.fosterParenting) {
            if (this.conformingAndStreaming) {
                this.fatal();
            } else {
                if (this.nonConformingAndStreaming) {
                    return;
                }
                this.insertIntoFosterParent(elt);
            }
        } else {
            this.detachFromParentAndAppendToNewParent(elt, current.node);
        }
        if (this.conformingAndStreaming || this.nonConformingAndStreaming) {
            this.elementPushed(name, attributes);
            this.elementPopped(name, null);
        }
    }

    private void appendVoidElementToCurrent(String name, Attributes attributes, T form) throws SAXException {
        this.flushCharacters();
        T elt = this.createElement(name, attributes, this.formPointer);
        StackNode<T> current = this.stack[this.currentPtr];
        this.detachFromParentAndAppendToNewParent(elt, current.node);
        if (this.conformingAndStreaming || this.nonConformingAndStreaming) {
            this.elementPushed(name, attributes);
            this.elementPopped(name, null);
        }
    }

    private void accumulateCharacters(char[] buf, int start, int length) throws SAXException {
        if (this.coalescingText) {
            int newLen = this.charBufferLen + length;
            if (newLen > this.charBuffer.length) {
                char[] newBuf = new char[newLen];
                System.arraycopy(this.charBuffer, 0, newBuf, 0, this.charBuffer.length);
                this.charBuffer = newBuf;
            }
            System.arraycopy(buf, start, this.charBuffer, this.charBufferLen, length);
            this.charBufferLen = newLen;
        } else {
            this.appendCharacters(this.stack[this.currentPtr].node, buf, start, length);
        }
    }

    private void flushCharacters() throws SAXException {
        if (this.charBufferLen > 0) {
            this.appendCharacters(this.stack[this.currentPtr].node, this.charBuffer, 0, this.charBufferLen);
            this.charBufferLen = 0;
        }
    }

    protected abstract T createElement(String var1, Attributes var2) throws SAXException;

    protected T createElement(String name, Attributes attributes, T form) throws SAXException {
        return this.createElement(name, attributes);
    }

    protected abstract T createHtmlElementSetAsRoot(Attributes var1) throws SAXException;

    protected abstract void detachFromParent(T var1) throws SAXException;

    protected abstract boolean hasChildren(T var1) throws SAXException;

    protected abstract T shallowClone(T var1) throws SAXException;

    protected abstract void detachFromParentAndAppendToNewParent(T var1, T var2) throws SAXException;

    protected abstract void appendChildrenToNewParent(T var1, T var2) throws SAXException;

    protected abstract T parentElementFor(T var1) throws SAXException;

    protected abstract void insertBefore(T var1, T var2, T var3) throws SAXException;

    protected abstract void insertCharactersBefore(char[] var1, int var2, int var3, T var4, T var5) throws SAXException;

    protected abstract void appendCharacters(T var1, char[] var2, int var3, int var4) throws SAXException;

    protected abstract void appendComment(T var1, char[] var2, int var3, int var4) throws SAXException;

    protected abstract void appendCommentToDocument(char[] var1, int var2, int var3) throws SAXException;

    protected abstract void addAttributesToElement(T var1, Attributes var2) throws SAXException;

    protected void start(boolean fragment) throws SAXException {
    }

    protected void end() throws SAXException {
    }

    protected void bodyClosed(T body) throws SAXException {
    }

    protected void htmlClosed(T html) throws SAXException {
    }

    protected void appendDoctypeToDocument(String name, String publicIdentifier, String systemIdentifier) throws SAXException {
    }

    protected void elementPushed(String name, T node) throws SAXException {
    }

    protected void elementPopped(String name, T node) throws SAXException {
    }

    protected void documentMode(DocumentMode mode, String publicIdentifier, String systemIdentifier, boolean html4SpecificAdditionalErrorChecks) throws SAXException {
    }

    @Override
    public boolean wantsComments() {
        return this.wantingComments;
    }

    public void setIgnoringComments(boolean ignoreComments) {
        this.wantingComments = !ignoreComments;
    }

    public final void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public final void setFragmentContext(String context) {
        this.context = context == null ? null : context.intern();
    }

    protected final T currentNode() {
        return (T)this.stack[this.currentPtr].node;
    }

    public boolean isScriptingEnabled() {
        return this.scriptingEnabled;
    }

    public void setScriptingEnabled(boolean scriptingEnabled) {
        this.scriptingEnabled = scriptingEnabled;
    }

    public void setDoctypeExpectation(DoctypeExpectation doctypeExpectation) {
        this.doctypeExpectation = doctypeExpectation;
    }

    public void setDocumentModeHandler(DocumentModeHandler documentModeHandler) {
        this.documentModeHandler = documentModeHandler;
    }

    public void setReportingDoctype(boolean reportingDoctype) {
        this.reportingDoctype = reportingDoctype;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StackNode<S> {
        final String name;
        final S node;
        final boolean scoping;
        final boolean special;
        final boolean fosterParenting;
        boolean tainted = false;

        StackNode(String name, S node, boolean scoping, boolean special, boolean fosterParenting) {
            this.name = name;
            this.node = node;
            this.scoping = scoping;
            this.special = special;
            this.fosterParenting = fosterParenting;
        }

        StackNode(String name, S node) {
            this.name = name;
            this.node = node;
            this.scoping = "table" == name || "caption" == name || "html" == name || "td" == name || "th" == name || "button" == name || "marquee" == name || "object" == name || "applet" == name;
            this.special = "address" == name || "area" == name || "base" == name || "basefont" == name || "bgsound" == name || "blockquote" == name || "body" == name || "br" == name || "center" == name || "col" == name || "colgroup" == name || "dd" == name || "dir" == name || "div" == name || "dl" == name || "dt" == name || "embed" == name || "fieldset" == name || "form" == name || "frame" == name || "frameset" == name || "h1" == name || "h2" == name || "h3" == name || "h4" == name || "h5" == name || "h6" == name || "head" == name || "hr" == name || "iframe" == name || "image" == name || "img" == name || "input" == name || "isindex" == name || "li" == name || "link" == name || "listing" == name || "menu" == name || "meta" == name || "noembed" == name || "noframes" == name || "noscript" == name || "ol" == name || "optgroup" == name || "option" == name || "p" == name || "param" == name || "plaintext" == name || "pre" == name || "script" == name || "select" == name || "spacer" == name || "style" == name || "tbody" == name || "textarea" == name || "tfoot" == name || "thead" == name || "title" == name || "tr" == name || "ul" == name || "wbr" == name;
            this.fosterParenting = "table" == name || "tbody" == name || "tfoot" == name || "thead" == name || "tr" == name;
        }

        public String toString() {
            return this.name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum InsertionMode {
        INITIAL,
        BEFORE_HTML,
        BEFORE_HEAD,
        IN_HEAD,
        IN_HEAD_NOSCRIPT,
        AFTER_HEAD,
        IN_BODY,
        IN_TABLE,
        IN_CAPTION,
        IN_COLUMN_GROUP,
        IN_TABLE_BODY,
        IN_ROW,
        IN_CELL,
        IN_SELECT,
        IN_SELECT_IN_TABLE,
        AFTER_BODY,
        IN_FRAMESET,
        AFTER_FRAMESET,
        AFTER_AFTER_BODY,
        AFTER_AFTER_FRAMESET;

    }
}

