/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.htmlparser.dom;

import nu.validator.htmlparser.common.DocumentMode;
import nu.validator.htmlparser.common.XmlViolationPolicy;
import nu.validator.htmlparser.impl.TreeBuilder;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DOMTreeBuilder
extends TreeBuilder<Element> {
    private DOMImplementation implementation;
    private Document document;

    protected DOMTreeBuilder(DOMImplementation implementation) {
        super(XmlViolationPolicy.ALLOW, true);
        this.implementation = implementation;
    }

    @Override
    protected void addAttributesToElement(Element element, Attributes attributes) throws SAXException {
        try {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String localName = attributes.getLocalName(i);
                String uri = attributes.getURI(i);
                if (element.hasAttributeNS(uri, localName)) continue;
                element.setAttributeNS(uri, localName, attributes.getValue(i));
            }
        }
        catch (DOMException e) {
            this.fatal(e);
        }
    }

    @Override
    protected void appendCharacters(Element parent, char[] buf, int start, int length) throws SAXException {
        try {
            parent.appendChild(this.document.createTextNode(new String(buf, start, length)));
        }
        catch (DOMException e) {
            this.fatal(e);
        }
    }

    @Override
    protected void appendChildrenToNewParent(Element oldParent, Element newParent) throws SAXException {
        try {
            while (oldParent.hasChildNodes()) {
                newParent.appendChild(oldParent.getFirstChild());
            }
        }
        catch (DOMException e) {
            this.fatal(e);
        }
    }

    @Override
    protected void appendComment(Element parent, char[] buf, int start, int length) throws SAXException {
        try {
            parent.appendChild(this.document.createComment(new String(buf, start, length)));
        }
        catch (DOMException e) {
            this.fatal(e);
        }
    }

    @Override
    protected void appendCommentToDocument(char[] buf, int start, int length) throws SAXException {
        try {
            this.document.appendChild(this.document.createComment(new String(buf, start, length)));
        }
        catch (DOMException e) {
            this.fatal(e);
        }
    }

    @Override
    protected Element createElement(String name, Attributes attributes) throws SAXException {
        try {
            Element rv = this.document.createElementNS("http://www.w3.org/1999/xhtml", name);
            for (int i = 0; i < attributes.getLength(); ++i) {
                rv.setAttributeNS(attributes.getURI(i), attributes.getLocalName(i), attributes.getValue(i));
            }
            return rv;
        }
        catch (DOMException e) {
            this.fatal(e);
            throw new RuntimeException("Unreachable");
        }
    }

    @Override
    protected Element createHtmlElementSetAsRoot(Attributes attributes) throws SAXException {
        try {
            Element rv = this.document.createElementNS("http://www.w3.org/1999/xhtml", "html");
            for (int i = 0; i < attributes.getLength(); ++i) {
                rv.setAttributeNS(attributes.getURI(i), attributes.getLocalName(i), attributes.getValue(i));
            }
            this.document.appendChild(rv);
            return rv;
        }
        catch (DOMException e) {
            this.fatal(e);
            throw new RuntimeException("Unreachable");
        }
    }

    @Override
    protected void detachFromParent(Element element) throws SAXException {
        try {
            Node parent = element.getParentNode();
            if (parent != null) {
                parent.removeChild(element);
            }
        }
        catch (DOMException e) {
            this.fatal(e);
        }
    }

    @Override
    protected void detachFromParentAndAppendToNewParent(Element child, Element newParent) throws SAXException {
        try {
            newParent.appendChild(child);
        }
        catch (DOMException e) {
            this.fatal(e);
        }
    }

    @Override
    protected boolean hasChildren(Element element) throws SAXException {
        try {
            return element.hasChildNodes();
        }
        catch (DOMException e) {
            this.fatal(e);
            throw new RuntimeException("Unreachable");
        }
    }

    @Override
    protected void insertBefore(Element child, Element sibling, Element parent) throws SAXException {
        try {
            parent.insertBefore(child, sibling);
        }
        catch (DOMException e) {
            this.fatal(e);
        }
    }

    @Override
    protected void insertCharactersBefore(char[] buf, int start, int length, Element sibling, Element parent) throws SAXException {
        try {
            parent.insertBefore(this.document.createTextNode(new String(buf, start, length)), sibling);
        }
        catch (DOMException e) {
            this.fatal(e);
        }
    }

    @Override
    protected Element parentElementFor(Element child) throws SAXException {
        try {
            Node parent = child.getParentNode();
            if (parent != null && parent.getNodeType() == 1) {
                return (Element)parent;
            }
            return null;
        }
        catch (DOMException e) {
            this.fatal(e);
            throw new RuntimeException("Unreachable");
        }
    }

    @Override
    protected Element shallowClone(Element element) throws SAXException {
        try {
            return (Element)element.cloneNode(false);
        }
        catch (DOMException e) {
            this.fatal(e);
            throw new RuntimeException("Unreachable");
        }
    }

    Document getDocument() {
        Document rv = this.document;
        this.document = null;
        return rv;
    }

    DocumentFragment getDocumentFragment() {
        DocumentFragment rv = this.document.createDocumentFragment();
        Node rootElt = this.document.getFirstChild();
        while (rootElt.hasChildNodes()) {
            rv.appendChild(rootElt.getFirstChild());
        }
        this.document = null;
        return rv;
    }

    @Override
    protected Element createElement(String name, Attributes attributes, Element form) throws SAXException {
        try {
            Element rv = this.createElement(name, attributes);
            rv.setUserData("nu.validator.form-pointer", form, null);
            return rv;
        }
        catch (DOMException e) {
            this.fatal(e);
            return null;
        }
    }

    @Override
    protected void start(boolean fragment) throws SAXException {
        this.document = this.implementation.createDocument(null, null, null);
    }

    @Override
    protected void documentMode(DocumentMode mode, String publicIdentifier, String systemIdentifier, boolean html4SpecificAdditionalErrorChecks) throws SAXException {
        this.document.setUserData("nu.validator.document-mode", (Object)mode, null);
    }
}

