/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.render;

import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.TokenConsumer;
import com.google.caja.parser.js.IntegerLiteral;
import com.google.caja.parser.js.Literal;
import com.google.caja.parser.js.NullLiteral;
import com.google.caja.parser.js.ObjectConstructor;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.parser.quasiliteral.QuasiBuilder;
import com.google.caja.render.Concatenator;
import com.google.caja.render.JsMinimalPrinter;
import com.google.caja.render.JsPrettyPrinter;
import com.google.caja.render.TokenClassification;
import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.RenderContext;
import com.google.caja.util.Callback;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.simple.JSONArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceSpansRenderer
implements TokenConsumer {
    private static final Comparator<InputSource> INPUT_SOURCE_COMPARATOR = new Comparator<InputSource>(){

        @Override
        public int compare(InputSource x, InputSource y) {
            if (x == null && y == null) {
                return 0;
            }
            if (x == null) {
                return -1;
            }
            if (y == null) {
                return 1;
            }
            return x.getUri().compareTo(y.getUri());
        }
    };
    private static final Pattern markPattern = Pattern.compile(" */\\*@([0-9]+)\\*/");
    private final MessageContext mc;
    private final InputSource cajoledOutputFilename;
    private final TokenConsumer delegateRenderer;
    private final List<FilePosition> marks = new ArrayList<FilePosition>();
    private final StringBuilder programTextAccumulator = new StringBuilder();
    private String programText;
    private final List<String> sourceLocationMap = new ArrayList<String>();

    public SourceSpansRenderer(Callback<IOException> exHandler, InputSource cajoledOutputFilename) {
        this.mc = new MessageContext();
        this.cajoledOutputFilename = cajoledOutputFilename;
        this.delegateRenderer = new JsPrettyPrinter(new Concatenator(this.programTextAccumulator, exHandler));
        ((JsPrettyPrinter)this.delegateRenderer).setBreakAfterComment(false);
    }

    @Override
    public void mark(FilePosition pos) {
        this.delegateRenderer.mark(pos);
        this.delegateRenderer.consume("/*@" + this.marks.size() + "*/");
        this.marks.add(pos == null ? FilePosition.UNKNOWN : pos);
    }

    @Override
    public void consume(String text) {
        if (TokenClassification.isComment(text)) {
            return;
        }
        this.delegateRenderer.consume(text);
    }

    @Override
    public void noMoreTokens() {
        this.delegateRenderer.noMoreTokens();
        this.programText = this.programTextAccumulator.toString();
        this.programTextAccumulator.delete(0, this.programTextAccumulator.length());
        List<List<FilePosition>> allPositionsByLine = this.buildSourcePositionMappings();
        this.programText = this.programTextAccumulator.toString();
        this.compressSourcePositionMappings(allPositionsByLine);
    }

    private List<List<FilePosition>> buildSourcePositionMappings() {
        String[] renderedLines = SourceSpansRenderer.splitLines(this.programText);
        Slot<FilePosition> currentPosition = new Slot<FilePosition>();
        currentPosition.value = FilePosition.UNKNOWN;
        ArrayList<List<FilePosition>> allPositionsByLine = new ArrayList<List<FilePosition>>();
        for (String renderedLine : renderedLines) {
            allPositionsByLine.add(this.buildSourcePositionMappingForLine(currentPosition, renderedLine));
        }
        this.marks.clear();
        return allPositionsByLine;
    }

    private List<FilePosition> buildSourcePositionMappingForLine(Slot<FilePosition> currentPosition, String line) {
        ArrayList<FilePosition> result = new ArrayList<FilePosition>();
        Matcher m = markPattern.matcher(line);
        int consumed = 0;
        while (m.find()) {
            String chunk = line.substring(consumed, m.start());
            this.programTextAccumulator.append(chunk);
            for (int i = 0; i < chunk.length(); ++i) {
                result.add((FilePosition)currentPosition.value);
            }
            consumed = m.end();
            currentPosition.value = this.marks.get(Integer.parseInt(m.group(1)));
        }
        if (consumed < line.length()) {
            this.programTextAccumulator.append(line, consumed, line.length());
            for (int i = 0; i < line.length() - consumed; ++i) {
                result.add((FilePosition)currentPosition.value);
            }
        }
        this.programTextAccumulator.append('\n');
        return result;
    }

    private void compressSourcePositionMappings(List<List<FilePosition>> allPositionsByLine) {
        ArrayList<List<Integer>> linePositionIndicesByLine = new ArrayList<List<Integer>>();
        ArrayList<Set<InputSource>> inputSourcesByLine = new ArrayList<Set<InputSource>>();
        HashMap<FilePosition, Integer> tableIndexByFilePosition = new HashMap<FilePosition, Integer>();
        ArrayList<FilePosition> filePositionTable = new ArrayList<FilePosition>();
        for (int lineIdx = 0; lineIdx < allPositionsByLine.size(); ++lineIdx) {
            linePositionIndicesByLine.add(new ArrayList());
            inputSourcesByLine.add(new TreeSet<InputSource>(INPUT_SOURCE_COMPARATOR));
            for (int charIdx = 0; charIdx < allPositionsByLine.get(lineIdx).size(); ++charIdx) {
                Integer tableIndex;
                FilePosition currentPos = FilePosition.startOf(allPositionsByLine.get(lineIdx).get(charIdx));
                ((Set)inputSourcesByLine.get(lineIdx)).add(currentPos.source());
                if (!currentPos.source().equals(InputSource.UNKNOWN)) {
                    this.mc.addInputSource(currentPos.source());
                }
                if ((tableIndex = (Integer)tableIndexByFilePosition.get(currentPos)) == null) {
                    tableIndexByFilePosition.put(currentPos, filePositionTable.size());
                    tableIndex = filePositionTable.size();
                    filePositionTable.add(currentPos);
                }
                ((List)linePositionIndicesByLine.get(lineIdx)).add(tableIndex);
            }
        }
        this.renderSourcePositionMappings(linePositionIndicesByLine, inputSourcesByLine, filePositionTable);
    }

    private void renderSourcePositionMappings(List<List<Integer>> linePositionIndicesByLine, List<Set<InputSource>> inputSourcesByLine, List<FilePosition> filePositionTable) {
        JSONArray line;
        int i;
        FilePosition unk = FilePosition.UNKNOWN;
        String inputSource = SourceSpansRenderer.renderInputSource(this.mc, this.cajoledOutputFilename);
        Literal fileLit = inputSource == null ? new NullLiteral(unk) : StringLiteral.valueOf(unk, inputSource);
        ObjectConstructor oc = (ObjectConstructor)QuasiBuilder.substV("({ count: @count, file: @file })", "file", fileLit, "count", new IntegerLiteral(unk, linePositionIndicesByLine.size()));
        StringBuilder header = new StringBuilder("/** Begin line maps. **/");
        RenderContext rc = new RenderContext(new JsMinimalPrinter(new Concatenator(header))).withJson(true);
        oc.render(rc);
        rc.getOut().noMoreTokens();
        this.sourceLocationMap.add(header.toString());
        for (i = 0; i < linePositionIndicesByLine.size(); ++i) {
            line = new JSONArray();
            for (int j = 0; j < linePositionIndicesByLine.get(i).size(); ++j) {
                SourceSpansRenderer.jsonArrayAdd(line, linePositionIndicesByLine.get(i).get(j));
            }
            this.sourceLocationMap.add(line.toJSONString());
        }
        this.sourceLocationMap.add("/** Begin file information. **/");
        for (i = 0; i < inputSourcesByLine.size(); ++i) {
            line = new JSONArray();
            for (InputSource p : inputSourcesByLine.get(i)) {
                SourceSpansRenderer.jsonArrayAdd(line, SourceSpansRenderer.renderInputSource(this.mc, p));
            }
            this.sourceLocationMap.add(line.toJSONString());
        }
        this.sourceLocationMap.add("/** Begin mapping definitions. **/");
        for (i = 0; i < filePositionTable.size(); ++i) {
            line = new JSONArray();
            SourceSpansRenderer.jsonArrayAdd(line, SourceSpansRenderer.renderInputSource(this.mc, filePositionTable.get(i).source()));
            SourceSpansRenderer.jsonArrayAdd(line, filePositionTable.get(i).startLineNo());
            SourceSpansRenderer.jsonArrayAdd(line, filePositionTable.get(i).startCharInLine());
            this.sourceLocationMap.add(line.toJSONString());
        }
    }

    private static void jsonArrayAdd(JSONArray a, Object value) {
        a.add(value);
    }

    public String getProgramText() {
        return this.programText;
    }

    public List<String> getSourceLocationMap() {
        return this.sourceLocationMap;
    }

    public MessageContext getMessageContext() {
        return this.mc;
    }

    private static String[] splitLines(String s) {
        return s.split("\r\n?|\n", -1);
    }

    private static String renderInputSource(MessageContext mc, InputSource is) {
        return InputSource.UNKNOWN.equals(is) ? null : mc.abbreviate(is);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Slot<T> {
        public T value;

        private Slot() {
        }
    }
}

