/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin.stages;

import com.google.caja.lang.css.CssSchema;
import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.CssTokenType;
import com.google.caja.lexer.ExternalReference;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.JsLexer;
import com.google.caja.lexer.JsTokenQueue;
import com.google.caja.lexer.ParseException;
import com.google.caja.lexer.TokenQueue;
import com.google.caja.parser.AncestorChain;
import com.google.caja.parser.MutableParseTreeNode;
import com.google.caja.parser.Visitor;
import com.google.caja.parser.css.CssParser;
import com.google.caja.parser.css.CssTree;
import com.google.caja.parser.html.Namespaces;
import com.google.caja.parser.html.Nodes;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.Parser;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.plugin.Dom;
import com.google.caja.plugin.ExtractedHtmlContent;
import com.google.caja.plugin.Job;
import com.google.caja.plugin.Jobs;
import com.google.caja.plugin.PluginEnvironment;
import com.google.caja.plugin.PluginMessageType;
import com.google.caja.reporting.Message;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.MessageTypeInt;
import com.google.caja.util.Name;
import com.google.caja.util.Pipeline;
import com.google.caja.util.Strings;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RewriteHtmlStage
implements Pipeline.Stage<Jobs> {
    private static final String HTML_NS = Namespaces.HTML_NAMESPACE_URI;

    @Override
    public boolean apply(Jobs jobs) {
        for (Job job : jobs.getJobsByType(Job.JobType.HTML, new Job.JobType[0])) {
            Node root = ((Dom)job.getRoot().node).getValue();
            this.rewriteDomTree(root, root, jobs);
        }
        return jobs.hasNoFatalErrors();
    }

    void rewriteDomTree(Node root, Node n, Jobs jobs) {
        Element el;
        if (n.getNodeType() == 1 && HTML_NS.equals((el = (Element)n).getNamespaceURI())) {
            String string = el.getLocalName();
            if ("script".equals(string)) {
                this.rewriteScriptTag(root, el, jobs);
            } else if ("style".equals(string)) {
                this.rewriteStyleTag(el, jobs);
            } else if ("link".equals(string)) {
                this.rewriteLinkTag(el, jobs);
            } else if ("body".equals(string)) {
                this.moveOnLoadHandlerToEndOfBody(el);
            }
        }
        for (Node node : Nodes.childrenOf(n)) {
            this.rewriteDomTree(root, node, jobs);
        }
    }

    private void rewriteScriptTag(Node root, Element scriptTag, Jobs jobs) {
        Block parsedScriptBody;
        FilePosition scriptPos;
        CharProducer jsStream;
        Node parent = scriptTag.getParentNode();
        PluginEnvironment env = jobs.getPluginMeta().getPluginEnvironment();
        Attr type = scriptTag.getAttributeNodeNS(HTML_NS, "type");
        Attr src = scriptTag.getAttributeNodeNS(HTML_NS, "src");
        if (type != null && !RewriteHtmlStage.isJavaScriptContentType(type.getNodeValue())) {
            jobs.getMessageQueue().addMessage((MessageTypeInt)PluginMessageType.UNRECOGNIZED_CONTENT_TYPE, Nodes.getFilePositionFor(type), MessagePart.Factory.valueOf(type.getNodeValue()), MessagePart.Factory.valueOf(scriptTag.getTagName()));
            parent.removeChild(scriptTag);
            return;
        }
        if (src == null) {
            jsStream = RewriteHtmlStage.textNodesToCharProducer(Nodes.childrenOf(scriptTag), true);
            if (jsStream == null) {
                parent.removeChild(scriptTag);
                return;
            }
            scriptPos = FilePosition.span(Nodes.getFilePositionFor(scriptTag.getFirstChild()), Nodes.getFilePositionFor(scriptTag.getLastChild()));
        } else {
            URI srcUri;
            FilePosition srcPos = Nodes.getFilePositionFor(src);
            FilePosition srcValuePos = Nodes.getFilePositionForValue(src);
            try {
                srcUri = new URI(src.getNodeValue());
            }
            catch (URISyntaxException ex) {
                jobs.getMessageQueue().getMessages().add(new Message((MessageTypeInt)PluginMessageType.MALFORMED_URL, MessageLevel.ERROR, srcPos, MessagePart.Factory.valueOf(src.getNodeName())));
                parent.removeChild(scriptTag);
                return;
            }
            URI absUri = srcValuePos.source().getUri().resolve(srcUri);
            jobs.getMessageContext().addInputSource(new InputSource(absUri));
            jsStream = env.loadExternalResource(new ExternalReference(absUri, srcValuePos), "text/javascript");
            if (jsStream == null) {
                jobs.getMessageQueue().addMessage((MessageTypeInt)PluginMessageType.FAILED_TO_LOAD_EXTERNAL_URL, srcValuePos, MessagePart.Factory.valueOf("" + srcUri));
                jsStream = CharProducer.Factory.fromString((CharSequence)("throw new Error(" + StringLiteral.toQuotedValue("Failed to load " + srcUri.toString()) + ");"), srcPos);
            }
            scriptPos = null;
        }
        try {
            parsedScriptBody = RewriteHtmlStage.parseJs(jsStream.getCurrentPosition().source(), jsStream, scriptPos, jobs.getMessageQueue());
        }
        catch (ParseException ex) {
            ex.toMessageQueue(jobs.getMessageQueue());
            parsedScriptBody = null;
        }
        if (parsedScriptBody == null) {
            parent.removeChild(scriptTag);
            return;
        }
        Element placeholder = parent.getOwnerDocument().createElementNS(HTML_NS, "span");
        Nodes.setFilePositionFor(placeholder, Nodes.getFilePositionFor(scriptTag));
        ExtractedHtmlContent.setExtractedScriptFor(placeholder, parsedScriptBody);
        if (Strings.equalsIgnoreCase("defer", scriptTag.getAttributeNS(HTML_NS, "defer"))) {
            parent.removeChild(scriptTag);
            root.appendChild(placeholder);
        } else {
            parent.replaceChild(placeholder, scriptTag);
        }
    }

    private void rewriteStyleTag(Element styleTag, Jobs jobs) {
        styleTag.getParentNode().removeChild(styleTag);
        CharProducer cssStream = RewriteHtmlStage.textNodesToCharProducer(Nodes.childrenOf(styleTag), false);
        if (cssStream != null) {
            this.extractStyles(styleTag, cssStream, null, jobs);
        }
    }

    private void rewriteLinkTag(Element styleTag, Jobs jobs) {
        URI hrefUri;
        PluginEnvironment env = jobs.getPluginMeta().getPluginEnvironment();
        styleTag.getParentNode().removeChild(styleTag);
        Attr rel = styleTag.getAttributeNodeNS(HTML_NS, "rel");
        if (rel == null || !Strings.equalsIgnoreCase(rel.getNodeValue().trim(), "stylesheet")) {
            return;
        }
        Attr href = styleTag.getAttributeNodeNS(HTML_NS, "href");
        Attr media = styleTag.getAttributeNodeNS(HTML_NS, "media");
        if (href == null) {
            jobs.getMessageQueue().addMessage((MessageTypeInt)PluginMessageType.MISSING_ATTRIBUTE, Nodes.getFilePositionFor(styleTag), MessagePart.Factory.valueOf("href"), MessagePart.Factory.valueOf("link"));
            return;
        }
        try {
            hrefUri = new URI(href.getNodeValue());
        }
        catch (URISyntaxException ex) {
            jobs.getMessageQueue().getMessages().add(new Message((MessageTypeInt)PluginMessageType.MALFORMED_URL, MessageLevel.ERROR, Nodes.getFilePositionFor(href), MessagePart.Factory.valueOf(href.getNodeName())));
            return;
        }
        URI absUri = Nodes.getFilePositionForValue(href).source().getUri().resolve(hrefUri);
        jobs.getMessageContext().addInputSource(new InputSource(absUri));
        CharProducer cssStream = env.loadExternalResource(new ExternalReference(absUri, Nodes.getFilePositionForValue(href)), "text/css");
        if (cssStream == null) {
            jobs.getMessageQueue().addMessage((MessageTypeInt)PluginMessageType.FAILED_TO_LOAD_EXTERNAL_URL, Nodes.getFilePositionForValue(href), MessagePart.Factory.valueOf("" + hrefUri));
            return;
        }
        this.extractStyles(styleTag, cssStream, media, jobs);
    }

    private void extractStyles(Element styleTag, CharProducer cssStream, Attr media, Jobs jobs) {
        String[] mediaTypeArr;
        CssTree.StyleSheet stylesheet;
        Attr type = styleTag.getAttributeNodeNS(HTML_NS, "type");
        if (type != null && !RewriteHtmlStage.isCssContentType(type.getNodeValue())) {
            jobs.getMessageQueue().addMessage((MessageTypeInt)PluginMessageType.UNRECOGNIZED_CONTENT_TYPE, Nodes.getFilePositionFor(type), MessagePart.Factory.valueOf(type.getNodeValue()), MessagePart.Factory.valueOf(styleTag.getTagName()));
            return;
        }
        try {
            stylesheet = RewriteHtmlStage.parseCss(cssStream, jobs.getMessageQueue());
            if (stylesheet == null) {
                return;
            }
        }
        catch (ParseException ex) {
            ex.toMessageQueue(jobs.getMessageQueue());
            return;
        }
        Set<Name> mediaTypes = Collections.emptySet();
        if (!(media == null || (mediaTypeArr = media.getNodeValue().trim().split("\\s*,\\s*")).length == 1 && "".equals(mediaTypeArr[0]))) {
            mediaTypes = new LinkedHashSet<Name>();
            for (String mediaType : mediaTypeArr) {
                if (!CssSchema.isMediaType(mediaType)) {
                    jobs.getMessageQueue().addMessage((MessageTypeInt)PluginMessageType.UNRECOGNIZED_MEDIA_TYPE, Nodes.getFilePositionFor(media), MessagePart.Factory.valueOf(mediaType));
                    continue;
                }
                mediaTypes.add(Name.css(mediaType));
            }
        }
        if (!mediaTypes.isEmpty() && !mediaTypes.contains(Name.css("all"))) {
            final ArrayList rules = new ArrayList();
            stylesheet.acceptPreOrder(new Visitor(){

                @Override
                public boolean visit(AncestorChain<?> ancestors) {
                    CssTree node = (CssTree)ancestors.node;
                    if (node instanceof CssTree.StyleSheet) {
                        return true;
                    }
                    if (node instanceof CssTree.RuleSet) {
                        rules.add((CssTree.RuleSet)node);
                        ((MutableParseTreeNode)ancestors.parent.node).removeChild(node);
                    }
                    return false;
                }
            }, null);
            if (!rules.isEmpty()) {
                ArrayList<CssTree.Medium> mediaChildren = new ArrayList<CssTree.Medium>();
                for (Name mediaType : mediaTypes) {
                    mediaChildren.add(new CssTree.Medium(Nodes.getFilePositionFor(media), mediaType));
                }
                mediaChildren.addAll(rules);
                CssTree.Media mediaBlock = new CssTree.Media(Nodes.getFilePositionFor(styleTag), mediaChildren);
                stylesheet.appendChild(mediaBlock);
            }
        }
        jobs.getJobs().add(new Job(AncestorChain.instance(stylesheet)));
    }

    private void moveOnLoadHandlerToEndOfBody(Element body) {
        Attr onload = body.getAttributeNodeNS(HTML_NS, "onload");
        Attr language = body.getAttributeNodeNS(HTML_NS, "language");
        if (onload == null || language != null && !RewriteHtmlStage.isJavaScriptLanguage(language.getNodeValue())) {
            return;
        }
        body.removeAttributeNode(onload);
        FilePosition pos = Nodes.getFilePositionForValue(onload);
        String source = onload.getNodeValue();
        Text sourceText = body.getOwnerDocument().createTextNode(source);
        Nodes.setFilePositionFor(sourceText, pos);
        Element scriptElement = body.getOwnerDocument().createElementNS(HTML_NS, "script");
        scriptElement.appendChild(sourceText);
        Nodes.setFilePositionFor(scriptElement, pos);
        body.appendChild(scriptElement);
    }

    /*
     * WARNING - void declaration
     */
    private static CharProducer textNodesToCharProducer(Iterable<? extends Node> nodes, boolean stripComments) {
        void var4_6;
        ArrayList<Text> textNodes = new ArrayList<Text>();
        for (Node node : nodes) {
            if (!(node instanceof Text)) continue;
            textNodes.add((Text)node);
        }
        if (textNodes.isEmpty()) {
            return null;
        }
        ArrayList<CharProducer> content = new ArrayList<CharProducer>();
        boolean bl = false;
        int n = textNodes.size();
        while (var4_6 < n) {
            Text node = (Text)textNodes.get((int)var4_6);
            String text = node.getNodeValue();
            if (stripComments) {
                if (var4_6 == false) {
                    text = text.replaceFirst("^(\\s*)<!--", "$1     ");
                }
                if (var4_6 + true == n) {
                    text = text.replaceFirst("-->(\\s*)$", "   $1");
                }
            }
            content.add(CharProducer.Factory.create(new StringReader(text), FilePosition.startOf(Nodes.getFilePositionFor(node))));
            ++var4_6;
        }
        if (content.size() == 1) {
            return (CharProducer)content.get(0);
        }
        return CharProducer.Factory.chain(content.toArray(new CharProducer[0]));
    }

    private static String getMimeType(String contentType) {
        int typeEnd = contentType.indexOf(59);
        if (typeEnd < 0) {
            typeEnd = contentType.length();
        }
        return Strings.toLowerCase(contentType.substring(0, typeEnd));
    }

    private static boolean isJavaScriptContentType(String contentType) {
        String mimeType = RewriteHtmlStage.getMimeType(contentType);
        return "text/javascript".equals(mimeType) || "application/x-javascript".equals(mimeType) || "type/ecmascript".equals(mimeType);
    }

    private static boolean isJavaScriptLanguage(String language) {
        return (language = Strings.toLowerCase(language)).startsWith("javascript") || language.startsWith("jscript");
    }

    private static boolean isCssContentType(String contentType) {
        return "text/css".equals(RewriteHtmlStage.getMimeType(contentType));
    }

    public static Block parseJs(InputSource is, CharProducer cp, FilePosition scriptPos, MessageQueue localMessageQueue) throws ParseException {
        JsLexer lexer = new JsLexer(cp);
        JsTokenQueue tq = new JsTokenQueue(lexer, is);
        tq.setInputRange(scriptPos);
        if (tq.isEmpty()) {
            return null;
        }
        Parser p = new Parser(tq, localMessageQueue);
        Block body = p.parse();
        tq.expectEmpty();
        return body;
    }

    public static CssTree.StyleSheet parseCss(CharProducer cp, MessageQueue mq) throws ParseException {
        TokenQueue<CssTokenType> tq = CssParser.makeTokenQueue(cp, mq, false);
        if (tq.isEmpty()) {
            return null;
        }
        CssParser p = new CssParser(tq, mq, MessageLevel.WARNING);
        CssTree.StyleSheet input = p.parseStyleSheet();
        tq.expectEmpty();
        return input;
    }
}

