/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin;

import com.google.caja.parser.AncestorChain;
import com.google.caja.parser.MutableParseTreeNode;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.quasiliteral.CajitaRewriter;
import com.google.caja.parser.quasiliteral.DefaultValijaRewriter;
import com.google.caja.parser.quasiliteral.IllegalReferenceCheckRewriter;
import com.google.caja.parser.quasiliteral.NonAsciiCheckVisitor;
import com.google.caja.parser.quasiliteral.Rewriter;
import com.google.caja.reporting.BuildInfo;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessageQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionSanitizerCaja {
    private final BuildInfo buildInfo;
    private final MessageQueue mq;

    public ExpressionSanitizerCaja(BuildInfo buildInfo, MessageQueue mq) {
        this.buildInfo = buildInfo;
        this.mq = mq;
    }

    public ParseTreeNode sanitize(AncestorChain<?> toSanitize) {
        MutableParseTreeNode input = (MutableParseTreeNode)toSanitize.node;
        ParseTreeNode result = this.newValijaRewriter(this.mq).expand(input);
        if (!this.mq.hasMessageAtLevel(MessageLevel.ERROR)) {
            result = this.newCajitaRewriter(this.mq).expand(result);
        }
        if (!this.mq.hasMessageAtLevel(MessageLevel.ERROR)) {
            result = new IllegalReferenceCheckRewriter(this.mq, false).expand(result);
            if (!this.mq.hasMessageAtLevel(MessageLevel.ERROR)) {
                result.acceptPreOrder(new NonAsciiCheckVisitor(this.mq), null);
            }
        }
        return result;
    }

    protected Rewriter newCajitaRewriter(MessageQueue mq) {
        return new CajitaRewriter(this.buildInfo, mq, false);
    }

    protected Rewriter newValijaRewriter(MessageQueue mq) {
        return new DefaultValijaRewriter(mq, false);
    }
}

