/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin;

import com.google.caja.lang.css.CssSchema;
import com.google.caja.lang.html.HTML;
import com.google.caja.lang.html.HtmlSchema;
import com.google.caja.parser.AncestorChain;
import com.google.caja.parser.css.CssPropertySignature;
import com.google.caja.parser.css.CssTree;
import com.google.caja.parser.html.AttribKey;
import com.google.caja.parser.html.ElKey;
import com.google.caja.parser.html.Namespaces;
import com.google.caja.plugin.Candidate;
import com.google.caja.plugin.CssPropertyPartType;
import com.google.caja.plugin.Match;
import com.google.caja.plugin.PluginMessageType;
import com.google.caja.plugin.SignatureResolver;
import com.google.caja.render.Concatenator;
import com.google.caja.render.CssPrettyPrinter;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.MessageTypeInt;
import com.google.caja.reporting.RenderContext;
import com.google.caja.util.Multimap;
import com.google.caja.util.Multimaps;
import com.google.caja.util.Name;
import com.google.caja.util.SyntheticAttributeKey;
import com.google.caja.util.SyntheticAttributes;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CssValidator {
    public static final SyntheticAttributeKey<Name> CSS_PROPERTY_PART = new SyntheticAttributeKey<Name>(Name.class, "cssPropertyPart");
    public static final SyntheticAttributeKey<CssPropertyPartType> CSS_PROPERTY_PART_TYPE = new SyntheticAttributeKey<CssPropertyPartType>(CssPropertyPartType.class, "cssPropertyPartType");
    public static final SyntheticAttributeKey<Boolean> INVALID = new SyntheticAttributeKey<Boolean>(Boolean.class, "cssValidator-invalid");
    private final CssSchema cssSchema;
    private final HtmlSchema htmlSchema;
    private final MessageQueue mq;
    private MessageLevel invalidNodeMessageLevel = MessageLevel.ERROR;
    private static final Collection<HTML.Attribute.Type> DISALLOWED_SELECTOR_ATTRIBUTE_TYPES = Collections.unmodifiableSet(EnumSet.of(HTML.Attribute.Type.ID, HTML.Attribute.Type.IDREF, HTML.Attribute.Type.IDREFS, HTML.Attribute.Type.URI));
    private static final Collection<AttribKey> DISALLOWED_SELECTOR_ATTRIBUTE_NAMES = Collections.unmodifiableList(Collections.singletonList(AttribKey.forHtmlAttrib(ElKey.HTML_WILDCARD, "style")));
    private static final Multimap<Name, Specialization> SPECIALIZATIONS = Multimaps.newListHashMultimap();

    public CssValidator(CssSchema cssSchema, HtmlSchema htmlSchema, MessageQueue mq) {
        if (null == cssSchema || null == htmlSchema || null == mq) {
            throw new NullPointerException();
        }
        this.cssSchema = cssSchema;
        this.htmlSchema = htmlSchema;
        this.mq = mq;
    }

    public CssValidator withInvalidNodeMessageLevel(MessageLevel messageLevel) {
        this.invalidNodeMessageLevel = messageLevel;
        return this;
    }

    public boolean validateCss(AncestorChain<? extends CssTree> css) {
        return this.validateCss((CssTree)css.node);
    }

    private boolean validateCss(CssTree t) {
        if (t instanceof CssTree.PropertyDeclaration) {
            CssTree.PropertyDeclaration d = (CssTree.PropertyDeclaration)t;
            return this.validatePropertyDeclaration(d);
        }
        if (t instanceof CssTree.UserAgentHack) {
            return this.validateUserAgentHack((CssTree.UserAgentHack)t);
        }
        if (t instanceof CssTree.SimpleSelector) {
            return this.validateSimpleSelector((CssTree.SimpleSelector)t);
        }
        if (t instanceof CssTree.Import) {
            return this.validateImport((CssTree.Import)t);
        }
        if (t instanceof CssTree.FontFace) {
            return this.validateFontFace((CssTree.FontFace)t);
        }
        if (t instanceof CssTree.Selector) {
            return this.validateSelector((CssTree.Selector)t);
        }
        if (t instanceof CssTree.Combination || t instanceof CssTree.CssExprAtom || t instanceof CssTree.DeclarationGroup || t instanceof CssTree.EmptyDeclaration || t instanceof CssTree.Expr || t instanceof CssTree.FontFace || t instanceof CssTree.Media || t instanceof CssTree.Medium || t instanceof CssTree.Page || t instanceof CssTree.Property || t instanceof CssTree.Pseudo || t instanceof CssTree.PseudoPage || t instanceof CssTree.RuleSet || t instanceof CssTree.SimpleSelector || t instanceof CssTree.StyleSheet || t instanceof CssTree.Term || t instanceof CssTree.WildcardElement) {
            boolean valid = true;
            for (CssTree cssTree : t.children()) {
                valid &= this.validateCss(cssTree);
            }
            return valid;
        }
        throw new IllegalArgumentException(t.getClass().getName());
    }

    private boolean validatePropertyDeclaration(CssTree.PropertyDeclaration d) {
        CssSchema.CssPropertyInfo pinfo;
        CssTree.Property prop = d.getProperty();
        Name moreSpecificName = this.specializeProperty(d);
        if (!moreSpecificName.equals(prop.getPropertyName())) {
            CssTree.Property specializedProp = new CssTree.Property(prop.getFilePosition(), moreSpecificName, prop.children());
            this.mq.addMessage((MessageTypeInt)PluginMessageType.SPECIALIZING_CSS_PROPERTY, prop.getFilePosition(), prop.getPropertyName(), moreSpecificName);
            d.replaceChild(specializedProp, prop);
            prop = specializedProp;
        }
        if (null == (pinfo = this.cssSchema.getCssProperty(prop.getPropertyName())) && prop.getPropertyName().getCanonicalForm().startsWith("_")) {
            pinfo = this.cssSchema.getCssProperty(Name.css(prop.getPropertyName().getCanonicalForm().substring(1)));
        }
        if (null == pinfo) {
            this.mq.addMessage((MessageTypeInt)PluginMessageType.UNKNOWN_CSS_PROPERTY, this.invalidNodeMessageLevel, prop.getFilePosition(), prop.getPropertyName());
            d.getAttributes().set(INVALID, Boolean.TRUE);
            return false;
        }
        if (!this.cssSchema.isPropertyAllowed(pinfo.name)) {
            this.mq.addMessage((MessageTypeInt)PluginMessageType.UNSAFE_CSS_PROPERTY, this.invalidNodeMessageLevel, prop.getFilePosition(), prop.getPropertyName());
            d.getAttributes().set(INVALID, Boolean.TRUE);
            return false;
        }
        if (!this.applySignature(pinfo.name, d.getExpr(), pinfo.sig)) {
            d.getAttributes().set(INVALID, Boolean.TRUE);
            return false;
        }
        return true;
    }

    private boolean validateUserAgentHack(CssTree.UserAgentHack hack) {
        if (hack != null && !this.validatePropertyDeclaration(hack.getDeclaration())) {
            hack.getAttributes().set(INVALID, Boolean.TRUE);
            return false;
        }
        return true;
    }

    private boolean validateSimpleSelector(CssTree.SimpleSelector sel) {
        boolean valid = true;
        if (null != sel.getElementName()) {
            String elName = sel.getElementName();
            ElKey elKey = ElKey.forElement(Namespaces.HTML_DEFAULT, elName);
            if (null != this.htmlSchema.lookupElement(elKey)) {
                if (!this.htmlSchema.isElementAllowed(elKey)) {
                    this.mq.addMessage((MessageTypeInt)PluginMessageType.UNSAFE_TAG, this.invalidNodeMessageLevel, sel.getFilePosition(), elKey);
                    valid = false;
                }
            } else {
                this.mq.addMessage((MessageTypeInt)PluginMessageType.UNKNOWN_TAG, this.invalidNodeMessageLevel, sel.getFilePosition(), MessagePart.Factory.valueOf(sel.getElementName()));
                valid = false;
            }
        }
        if (!(valid &= this.validateAllAttribs(sel))) {
            sel.getAttributes().set(INVALID, Boolean.TRUE);
        }
        return valid;
    }

    private boolean validateAllAttribs(CssTree.SimpleSelector sel) {
        String qname = sel.getElementName();
        ElKey el = qname == null ? ElKey.HTML_WILDCARD : ElKey.forElement(Namespaces.HTML_DEFAULT, qname);
        boolean valid = true;
        for (CssTree cssTree : sel.children()) {
            if (!(cssTree instanceof CssTree.Attrib)) continue;
            valid &= this.validateAttrib(el, (CssTree.Attrib)cssTree);
        }
        return valid;
    }

    private boolean validateAttrib(ElKey elId, CssTree.Attrib attr) {
        AttribKey attrId = AttribKey.forAttribute(Namespaces.HTML_DEFAULT, elId, attr.getIdent());
        HTML.Attribute htmlAttribute = this.htmlSchema.lookupAttribute(attrId);
        if (null != htmlAttribute) {
            return this.validateAttribToSchema(elId, htmlAttribute, attr);
        }
        this.mq.addMessage((MessageTypeInt)PluginMessageType.UNKNOWN_ATTRIBUTE, this.invalidNodeMessageLevel, attr.getFilePosition(), attrId, MessagePart.Factory.valueOf("{css selector}"));
        attr.getAttributes().set(INVALID, Boolean.TRUE);
        return false;
    }

    private boolean validateAttribToSchema(ElKey elId, HTML.Attribute htmlAttribute, CssTree.Attrib attr) {
        boolean valid = true;
        for (HTML.Attribute.Type type : DISALLOWED_SELECTOR_ATTRIBUTE_TYPES) {
            if (type != htmlAttribute.getType()) continue;
            this.mq.addMessage((MessageTypeInt)PluginMessageType.CSS_ATTRIBUTE_TYPE_NOT_ALLOWED_IN_SELECTOR, this.invalidNodeMessageLevel, MessagePart.Factory.valueOf(type.toString()), attr.getFilePosition());
            valid = false;
        }
        if (DISALLOWED_SELECTOR_ATTRIBUTE_NAMES.contains(htmlAttribute.getKey())) {
            this.mq.addMessage((MessageTypeInt)PluginMessageType.CSS_ATTRIBUTE_NAME_NOT_ALLOWED_IN_SELECTOR, this.invalidNodeMessageLevel, MessagePart.Factory.valueOf(htmlAttribute.getKey().localName), attr.getFilePosition());
            valid = false;
        }
        if (null != attr.getOperation()) {
            switch (attr.getOperation().getValue()) {
                case EQUAL: {
                    valid &= this.validateAttribValueEqual(elId, htmlAttribute, attr);
                    break;
                }
                case INCLUDES: {
                    valid &= this.validateAttribValueIncludes(elId, htmlAttribute, attr);
                    break;
                }
                case DASHMATCH: {
                    this.mq.addMessage((MessageTypeInt)PluginMessageType.CSS_DASHMATCH_ATTRIBUTE_OPERATOR_NOT_ALLOWED, this.invalidNodeMessageLevel, attr.getFilePosition());
                    valid = false;
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        return valid;
    }

    private boolean validateAttribValueEqual(ElKey elId, HTML.Attribute htmlAttribute, CssTree.Attrib attr) {
        return this.validateAttribValue(elId, htmlAttribute, attr, attr.getRhsValue().getValue());
    }

    private boolean validateAttribValueIncludes(ElKey elId, HTML.Attribute htmlAttribute, CssTree.Attrib attr) {
        boolean valid = true;
        for (String value : attr.getRhsValue().getValue().split("\\s+")) {
            if ("".equals(value)) continue;
            valid &= this.validateAttribValue(elId, htmlAttribute, attr, value);
        }
        return valid;
    }

    private boolean validateAttribValue(ElKey elId, HTML.Attribute htmlAttribute, CssTree.Attrib attr, String value) {
        if (!htmlAttribute.getValueCriterion().accept(value)) {
            this.mq.addMessage((MessageTypeInt)PluginMessageType.UNRECOGNIZED_ATTRIBUTE_VALUE, this.invalidNodeMessageLevel, attr.getFilePosition(), MessagePart.Factory.valueOf(value), elId, MessagePart.Factory.valueOf(htmlAttribute.getKey().localName));
            return false;
        }
        return true;
    }

    private boolean validateImport(CssTree.Import importNode) {
        this.mq.addMessage((MessageTypeInt)PluginMessageType.IMPORTS_NOT_ALLOWED_HERE, this.invalidNodeMessageLevel, importNode.getFilePosition());
        importNode.getAttributes().set(INVALID, Boolean.TRUE);
        return false;
    }

    private boolean validateFontFace(CssTree.FontFace ff) {
        this.mq.addMessage((MessageTypeInt)PluginMessageType.FONT_FACE_NOT_ALLOWED, this.invalidNodeMessageLevel, ff.getFilePosition());
        ff.getAttributes().set(INVALID, Boolean.TRUE);
        return false;
    }

    private boolean validateSelector(CssTree.Selector s) {
        List<? extends CssTree> children = s.children();
        int i = 0;
        if (i == 0) {
            i = this.skipDescendantOfBodyWithClass(children);
        }
        if (i == 0) {
            i = this.skipDescendantOfWildcardHtml(children);
        }
        boolean valid = true;
        for (CssTree cssTree : children.subList(i, children.size())) {
            valid &= this.validateCss(cssTree);
        }
        if (!valid) {
            s.getAttributes().set(INVALID, Boolean.TRUE);
        }
        return valid;
    }

    private int skipDescendantOfBodyWithClass(List<? extends CssTree> children) {
        if (children.size() <= 2) {
            return 0;
        }
        CssTree.Combination c = (CssTree.Combination)children.get(1);
        if (c.getCombinator() != CssTree.Combinator.DESCENDANT) {
            return 0;
        }
        CssTree.SimpleSelector ss = (CssTree.SimpleSelector)children.get(0);
        List<? extends CssTree> ssParts = ss.children();
        if (ssParts.size() != 2) {
            return 0;
        }
        CssTree ssPart0 = ssParts.get(0);
        if (!(ssPart0 instanceof CssTree.IdentLiteral && "body".equals(ssPart0.getValue()) && ssParts.get(1) instanceof CssTree.ClassLiteral)) {
            return 0;
        }
        return 2;
    }

    private int skipDescendantOfWildcardHtml(List<? extends CssTree> children) {
        if (children.size() <= 4) {
            return 0;
        }
        CssTree.Combination c = (CssTree.Combination)children.get(1);
        if (c.getCombinator() != CssTree.Combinator.DESCENDANT) {
            return 0;
        }
        c = (CssTree.Combination)children.get(3);
        if (c.getCombinator() != CssTree.Combinator.DESCENDANT) {
            return 0;
        }
        CssTree.SimpleSelector ss0 = (CssTree.SimpleSelector)children.get(0);
        List<? extends CssTree> ss0Parts = ss0.children();
        if (ss0Parts.size() != 1 || !(ss0Parts.get(0) instanceof CssTree.WildcardElement)) {
            return 0;
        }
        CssTree.SimpleSelector ss2 = (CssTree.SimpleSelector)children.get(2);
        List<? extends CssTree> ss2Parts = ss2.children();
        if (ss2Parts.size() != 1) {
            return 0;
        }
        CssTree ss2Part0 = ss2Parts.get(0);
        if (!(ss2Part0 instanceof CssTree.IdentLiteral) || !"html".equals(ss2Part0.getValue())) {
            return 0;
        }
        return 4;
    }

    private boolean applySignature(Name propertyName, CssTree.Expr expr, CssPropertySignature sig) {
        SignatureResolver resolver = new SignatureResolver(expr, this.cssSchema);
        List<Candidate> matches = resolver.applySignature(Collections.singletonList(new Candidate(0, null, null)), propertyName, sig);
        int end = expr.children().size();
        Iterator<Candidate> it = matches.iterator();
        while (it.hasNext()) {
            Candidate match = it.next();
            if (match.exprIdx == end) continue;
            it.remove();
        }
        if (matches.isEmpty()) {
            Candidate best = resolver.getBestAttempt();
            int exprIdx = null != best ? best.exprIdx : 0;
            StringBuilder buf = new StringBuilder();
            CssPrettyPrinter tc = new CssPrettyPrinter(new Concatenator(buf));
            RenderContext rc = new RenderContext(tc);
            boolean needsSpace = false;
            int k = 0;
            for (CssTree cssTree : expr.children()) {
                if (needsSpace) {
                    buf.append(' ');
                }
                int len = buf.length();
                if (k++ == exprIdx) {
                    buf.append(" ==>");
                    cssTree.render(rc);
                    tc.noMoreTokens();
                    buf.append("<== ");
                } else {
                    cssTree.render(rc);
                }
                needsSpace = len < buf.length();
            }
            this.mq.addMessage((MessageTypeInt)PluginMessageType.MALFORMED_CSS_PROPERTY_VALUE, expr.getFilePosition(), propertyName, MessagePart.Factory.valueOf(buf.toString().trim()));
            expr.getAttributes().set(INVALID, Boolean.TRUE);
            return false;
        }
        Candidate c = matches.get(0);
        Match m = c.match;
        while (null != m) {
            SyntheticAttributes attribs = m.term.getAttributes();
            attribs.set(CSS_PROPERTY_PART_TYPE, m.type);
            attribs.set(CSS_PROPERTY_PART, m.propertyName);
            m = m.prev;
        }
        if (null != c.warning) {
            c.warning.toMessageQueue(this.mq);
        }
        return true;
    }

    private static void specialization(String generalName, String specialName, String sig) {
        SPECIALIZATIONS.put(Name.css(generalName), new Specialization(Name.css(specialName), CssPropertySignature.Parser.parseSignature(sig)));
    }

    private Name specializeProperty(CssTree.PropertyDeclaration p) {
        Name propertyName = p.getProperty().getPropertyName();
        CssTree.Expr expr = p.getExpr();
        for (Specialization s : SPECIALIZATIONS.get(propertyName)) {
            SignatureResolver r = new SignatureResolver(expr, this.cssSchema);
            List<Candidate> matches = r.applySignature(Collections.singletonList(new Candidate(0, null, null)), propertyName, s.sig);
            int end = expr.children().size();
            int matchCount = 0;
            for (Candidate match : matches) {
                if (match.exprIdx != end) continue;
                ++matchCount;
            }
            if (matchCount != true) continue;
            return s.specialName;
        }
        return propertyName;
    }

    static {
        CssValidator.specialization("font", "font-size", "<absolute-size> | <relative-size> | <length:0,> | <percentage:0,>");
        CssValidator.specialization("font", "font-family", "<loose-quotable-words>");
    }

    private static final class Specialization {
        final Name specialName;
        final CssPropertySignature sig;

        Specialization(Name specialName, CssPropertySignature sig) {
            this.specialName = specialName;
            this.sig = sig;
        }
    }
}

