/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin;

import com.google.caja.config.ConfigUtil;
import com.google.caja.config.WhiteList;
import com.google.caja.lang.css.CssSchema;
import com.google.caja.lang.html.HtmlSchema;
import com.google.caja.lexer.InputSource;
import com.google.caja.reporting.BuildInfo;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.MessageType;
import com.google.caja.reporting.MessageTypeInt;
import com.google.caja.util.Strings;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Config {
    private final Options options = new Options();
    private final Option INPUT = this.defineOption("i", "input", "Input URI containing HTML (with optional script and style blocks)", true);
    private final Option OUTPUT_HTML = this.defineOption("h", "output_html", "Output file path for translated HTML (defaults to input with \".out.html\")", true);
    private final Option OUTPUT_JS = this.defineOption("j", "output_js", "Output file path for translated JS (defaults to input with \".out.js\")", true);
    private final Option OUTPUT_BASE = this.defineOption("o", "out", "Path to which the appropriate extension is added to form output files.", true);
    private final Option CSS_PROPERTY_WHITELIST = this.defineOption("css_prop_schema", "A file: or resource: URI of the CSS Property Whitelist to use.", true);
    private final Option HTML_ATTRIBUTE_WHITELIST = this.defineOption("html_attrib_schema", "A file: or resource: URI of the HTML attribute Whitelist to use.", true);
    private final Option HTML_ELEMENT_WHITELIST = this.defineOption("html_property_schema", "A file: or resource: URI of the HTML element Whitelist to use.", true);
    private final Option BASE_URI = this.defineOption("base_uri", "The URI relative to which URIs in the inputs are resolved.", true);
    private final Option SERVICE_PORT = this.defineOption("port", "The port on which cajoling service is run.", true);
    private final Option VIEW = this.defineOption("v", "view", "Gadget view to render (default is 'canvas')", true);
    private final Option ID_CLASS = this.defineOption("c", "id_class", "The module ID if it is statically known", true);
    private final Option DEBUG_MODE = this.defineBooleanOption("g", "debug", "Set to add debugging info to cajoled output.");
    private final Option RENDERER = this.defineOption("r", "renderer", "The output renderer ('minify', 'pretty', 'sidebyside', or 'debugger')", true);
    private final Class<?> mainClass;
    private final PrintWriter stderr;
    private final String usageText;
    private List<URI> inputUris;
    private File outputBase;
    private File outputJsFile;
    private File outputHtmlFile;
    private URI cssPropertyWhitelistUri;
    private URI htmlAttributeWhitelistUri;
    private URI htmlElementWhitelistUri;
    private URI baseUri;
    private String gadgetView;
    private boolean debugMode;
    private SourceRenderMode renderer;
    private int servicePort;
    private String idClass;

    public Config(Class<?> mainClass, PrintStream stderr, String usageText) {
        this(mainClass, new PrintWriter(stderr), usageText);
    }

    public Config(Class<?> mainClass, PrintWriter stderr, String usageText) {
        this.mainClass = mainClass;
        this.stderr = stderr;
        this.usageText = usageText;
    }

    public Collection<URI> getInputUris() {
        return this.inputUris;
    }

    public File getOutputJsFile() {
        return this.outputJsFile;
    }

    public File getOutputHtmlFile() {
        return this.outputHtmlFile;
    }

    public File getOutputBase() {
        return this.outputBase;
    }

    public int getServicePort() {
        return this.servicePort;
    }

    public URI getCssPropertyWhitelistUri() {
        return this.cssPropertyWhitelistUri;
    }

    public URI getHtmlAttributeWhitelistUri() {
        return this.htmlAttributeWhitelistUri;
    }

    public URI getHtmlElementWhitelistUri() {
        return this.htmlElementWhitelistUri;
    }

    public URI getBaseUri() {
        return this.baseUri;
    }

    public CssSchema getCssSchema(MessageQueue mq) {
        return new CssSchema(Config.whitelist(this.cssPropertyWhitelistUri, mq), Config.whitelist(URI.create("resource:///com/google/caja/lang/css/css-extensions-fns.json"), mq));
    }

    public HtmlSchema getHtmlSchema(MessageQueue mq) {
        return new HtmlSchema(Config.whitelist(this.htmlElementWhitelistUri, mq), Config.whitelist(this.htmlAttributeWhitelistUri, mq));
    }

    public String getGadgetView() {
        return this.gadgetView;
    }

    public String getIdClass() {
        return this.idClass;
    }

    public boolean debugMode() {
        return this.debugMode;
    }

    public SourceRenderMode renderer() {
        return this.renderer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processArguments(String[] argv) {
        try {
            boolean bl;
            CommandLine cl;
            try {
                cl = new BasicParser().parse(this.options, argv, false);
            }
            catch (ParseException e) {
                this.usage(e.getMessage(), this.stderr);
                boolean bl2 = false;
                this.stderr.flush();
                return bl2;
            }
            this.inputUris = new ArrayList<URI>();
            if (cl.getOptionValues(this.INPUT.getOpt()) != null) {
                for (String input : cl.getOptionValues(this.INPUT.getOpt())) {
                    URI inputUri;
                    block36: {
                        File inputFile;
                        block37: {
                            try {
                                if (input.indexOf(58) >= 0) {
                                    inputUri = new URI(input);
                                    break block36;
                                }
                                inputFile = new File(input);
                                if (!inputFile.exists()) {
                                    this.usage("File \"" + input + "\" does not exist", this.stderr);
                                    boolean bl3 = false;
                                    return bl3;
                                }
                                if (inputFile.canRead() && !inputFile.isDirectory()) break block37;
                                this.usage("File \"" + input + "\" is not a regular file", this.stderr);
                                boolean bl4 = false;
                                return bl4;
                            }
                            catch (URISyntaxException ex) {
                                this.usage("Input \"" + input + "\" is not a valid URI", this.stderr);
                                boolean bl5 = false;
                                return bl5;
                            }
                        }
                        inputUri = inputFile.getAbsoluteFile().toURI();
                    }
                    this.inputUris.add(inputUri);
                }
            }
            if (this.inputUris.isEmpty()) {
                this.usage("Option \"--" + this.INPUT.getLongOpt() + "\" missing", this.stderr);
                boolean arr$ = false;
                return arr$;
            }
            if (cl.getOptionValue(this.OUTPUT_BASE.getOpt()) != null) {
                this.outputBase = new File(cl.getOptionValue(this.OUTPUT_BASE.getOpt()));
                this.outputJsFile = Config.substituteExtension(this.outputBase, ".out.js");
                this.outputHtmlFile = Config.substituteExtension(this.outputBase, ".out.html");
                if (cl.getOptionValue(this.OUTPUT_JS.getOpt()) != null) {
                    this.usage("Can't specify both --out and --output_js", this.stderr);
                    boolean arr$ = false;
                    return arr$;
                }
                if (cl.getOptionValue(this.OUTPUT_HTML.getOpt()) != null) {
                    this.usage("Can't specify both --out and --output_html", this.stderr);
                    boolean arr$ = false;
                    return arr$;
                }
            } else {
                URI inputUri = this.inputUris.get(0);
                File file = this.outputJsFile = cl.getOptionValue(this.OUTPUT_JS.getOpt()) == null ? Config.toFileWithExtension(inputUri, "out.js") : new File(cl.getOptionValue(this.OUTPUT_JS.getOpt()));
                if (this.outputJsFile == null) {
                    this.usage("Please specify js output via " + this.OUTPUT_JS.getLongOpt(), this.stderr);
                }
                File file2 = this.outputHtmlFile = cl.getOptionValue(this.OUTPUT_HTML.getOpt()) == null ? Config.toFileWithExtension(inputUri, "out.html") : new File(cl.getOptionValue(this.OUTPUT_HTML.getOpt()));
                if (this.outputHtmlFile == null) {
                    this.usage("Please specify js output via " + this.OUTPUT_HTML.getLongOpt(), this.stderr);
                }
            }
            try {
                this.cssPropertyWhitelistUri = new URI(cl.getOptionValue(this.CSS_PROPERTY_WHITELIST.getOpt(), "resource:///com/google/caja/lang/css/css-extensions.json"));
                this.htmlAttributeWhitelistUri = new URI(cl.getOptionValue(this.HTML_ATTRIBUTE_WHITELIST.getOpt(), "resource:///com/google/caja/lang/html/html4-attributes-extensions.json"));
                this.htmlElementWhitelistUri = new URI(cl.getOptionValue(this.HTML_ELEMENT_WHITELIST.getOpt(), "resource:///com/google/caja/lang/html/html4-elements-extensions.json"));
                this.baseUri = cl.getOptionValue(this.BASE_URI.getOpt()) != null ? new URI(cl.getOptionValue(this.BASE_URI.getOpt())) : this.inputUris.get(0);
            }
            catch (URISyntaxException ex) {
                this.stderr.println("Invalid whitelist URI: " + ex.getInput() + "\n    " + ex.getReason());
                int len$ = 0;
                this.stderr.flush();
                return len$ != 0;
            }
            this.gadgetView = cl.getOptionValue(this.VIEW.getOpt(), "canvas");
            this.idClass = cl.getOptionValue(this.ID_CLASS.getOpt(), null);
            this.debugMode = cl.hasOption(this.DEBUG_MODE.getOpt());
            try {
                String servicePortString = cl.getOptionValue(this.SERVICE_PORT.getOpt(), "8887");
                this.servicePort = Integer.parseInt(servicePortString);
            }
            catch (NumberFormatException e) {
                this.stderr.println("Invalid service port: " + this.SERVICE_PORT.getOpt() + "\n    " + e.getMessage());
                bl = false;
                this.stderr.flush();
                return bl;
            }
            String renderString = cl.getOptionValue(this.RENDERER.getOpt());
            if (renderString != null) {
                this.renderer = SourceRenderMode.valueOf(renderString.toUpperCase());
                if (this.renderer == null) {
                    this.stderr.println("Invalid renderer: " + renderString);
                    bl = false;
                    return bl;
                }
            } else {
                this.renderer = SourceRenderMode.PRETTY;
            }
            bl = true;
            return bl;
        }
        finally {
            this.stderr.flush();
        }
    }

    public void usage(String msg, PrintWriter out) {
        out.println(BuildInfo.getInstance().getBuildInfo());
        out.println();
        if (msg != null && !"".equals(msg)) {
            out.println(msg);
            out.println();
        }
        new HelpFormatter().printHelp(out, 74, this.mainClass.getSimpleName() + " --input <in.html> [--output_js <out.js> | --out <out>]", "\n", this.options, 1, 3, "\n" + this.usageText, false);
    }

    private static File toFileWithExtension(URI uri, String extension) {
        if (!Strings.equalsIgnoreCase("file", uri.getScheme())) {
            return null;
        }
        return Config.substituteExtension(new File(uri.getPath()), extension);
    }

    private static File substituteExtension(File file, String extension) {
        String fileName = file.getName();
        int lastDot = fileName.lastIndexOf(46);
        if (lastDot < 0) {
            lastDot = fileName.length();
        }
        return new File(file.getParentFile(), fileName.substring(0, lastDot) + "." + extension);
    }

    private static WhiteList whitelist(URI uri, MessageQueue mq) {
        InputSource src = new InputSource(uri);
        try {
            return ConfigUtil.loadWhiteListFromJson(uri, ConfigUtil.RESOURCE_RESOLVER, mq);
        }
        catch (IOException ex) {
            mq.addMessage((MessageTypeInt)MessageType.IO_ERROR, src);
        }
        catch (com.google.caja.lexer.ParseException ex) {
            ex.toMessageQueue(mq);
        }
        return new WhiteList(){

            @Override
            public Set<String> allowedItems() {
                return Collections.emptySet();
            }

            @Override
            public Map<String, WhiteList.TypeDefinition> typeDefinitions() {
                return Collections.emptyMap();
            }
        };
    }

    private Option defineOption(String shortFlag, String longFlag, String help, boolean optional) {
        Option opt = new Option(shortFlag, longFlag, true, help);
        opt.setOptionalArg(optional);
        this.options.addOption(opt);
        return opt;
    }

    private Option defineBooleanOption(String shortFlag, String longFlag, String help) {
        Option opt = new Option(shortFlag, longFlag, false, help);
        opt.setOptionalArg(true);
        this.options.addOption(opt);
        return opt;
    }

    private Option defineOption(String longFlag, String help, boolean optional) {
        return this.defineOption(longFlag, longFlag, help, optional);
    }

    public static void main(String[] argv) {
        Config config = new Config(Config.class, System.err, "Does some stuff.");
        System.err.println(config.processArguments(argv));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SourceRenderMode {
        MINIFY,
        PRETTY,
        SIDEBYSIDE,
        DEBUGGER;

    }
}

