/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.js;

import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.Keyword;
import com.google.caja.lexer.TokenConsumer;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.js.AbstractExpression;
import com.google.caja.parser.js.AssignOperation;
import com.google.caja.parser.js.Associativity;
import com.google.caja.parser.js.BooleanLiteral;
import com.google.caja.parser.js.ControlOperation;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.FunctionConstructor;
import com.google.caja.parser.js.IntegerLiteral;
import com.google.caja.parser.js.Literal;
import com.google.caja.parser.js.NullLiteral;
import com.google.caja.parser.js.NumberLiteral;
import com.google.caja.parser.js.ObjectConstructor;
import com.google.caja.parser.js.Operator;
import com.google.caja.parser.js.OperatorCategory;
import com.google.caja.parser.js.OperatorType;
import com.google.caja.parser.js.RealLiteral;
import com.google.caja.parser.js.Reference;
import com.google.caja.parser.js.SimpleOperation;
import com.google.caja.parser.js.SpecialOperation;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.reporting.RenderContext;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Operation
extends AbstractExpression {
    private Operator op;
    private static final Object UNDEFINED = new Object(){

        public String toString() {
            return "undefined";
        }
    };

    protected Operation(FilePosition pos, Operator op, List<? extends Expression> params) {
        super(pos, Expression.class);
        this.op = op;
        if (null == op) {
            throw new NullPointerException();
        }
        this.createMutation().appendChildren(params).execute();
    }

    public static boolean is(ParseTreeNode n, Operator op) {
        return n instanceof Operation && op == ((Operation)n).getOperator();
    }

    public static boolean is(ParseTreeNode n, OperatorCategory cat) {
        return n instanceof Operation && cat == ((Operation)n).getOperator().getCategory();
    }

    public List<? extends Expression> children() {
        return this.childrenAs(Expression.class);
    }

    @Override
    protected void childrenChanged() {
        super.childrenChanged();
        int nChildren = this.children().size();
        if (nChildren < Operation.minArity(this.op)) {
            throw new IllegalArgumentException("Too few of children " + nChildren + " for operator " + (Object)((Object)this.op));
        }
        if (nChildren > Operation.maxArity(this.op)) {
            throw new IllegalArgumentException("Too many children " + nChildren + " for operator " + (Object)((Object)this.op));
        }
    }

    public static Operation create(FilePosition pos, Operator op, Expression ... params) {
        switch (op.getCategory()) {
            case ASSIGNMENT: {
                return new AssignOperation(pos, op, Arrays.asList(params));
            }
            case CONTROL: {
                return new ControlOperation(pos, op, Arrays.asList(params));
            }
            case SPECIAL: {
                return new SpecialOperation(pos, op, Arrays.asList(params));
            }
            case SIMPLE: {
                return new SimpleOperation(pos, op, Arrays.asList(params));
            }
        }
        throw new RuntimeException("unexpected: " + (Object)((Object)op));
    }

    public static Operation createInfix(Operator op, Expression left, Expression right) {
        assert (op.getType() == OperatorType.INFIX);
        return Operation.create(FilePosition.span(left.getFilePosition(), right.getFilePosition()), op, left, right);
    }

    public static Operation createTernary(Expression left, Expression middle, Expression right) {
        return Operation.create(FilePosition.span(left.getFilePosition(), right.getFilePosition()), Operator.TERNARY, left, middle, right);
    }

    public static Operation undefined(FilePosition pos) {
        return Operation.create(pos, Operator.VOID, new IntegerLiteral(pos, 0L));
    }

    @Override
    public Object getValue() {
        return this.op;
    }

    public Operator getOperator() {
        return this.op;
    }

    @Override
    public Expression simplifyForSideEffect() {
        switch (this.op) {
            case LOGICAL_OR: 
            case LOGICAL_AND: 
            case COMMA: {
                List<? extends Expression> operands = this.children();
                Expression sa = operands.get(0).simplifyForSideEffect();
                Expression sb = operands.get(1).simplifyForSideEffect();
                return sb == null ? sa : (sa == null ? sb : this);
            }
            case TERNARY: {
                List<? extends Expression> operands = this.children();
                if (operands.get(1).simplifyForSideEffect() == null && operands.get(2).simplifyForSideEffect() == null) {
                    return operands.get(0).simplifyForSideEffect();
                }
                return this;
            }
            case NOT: 
            case TYPEOF: {
                return this.children().get(0).simplifyForSideEffect();
            }
            case VOID: {
                return this.children().get(0).simplifyForSideEffect();
            }
        }
        return this;
    }

    @Override
    public Boolean conditionResult() {
        List<? extends Expression> operands = this.children();
        switch (this.op) {
            case COMMA: {
                return operands.get(1).conditionResult();
            }
            case CONSTRUCTOR: {
                return true;
            }
            case FUNCTION_CALL: {
                return Operation.is((ParseTreeNode)operands.get(0), Operator.CONSTRUCTOR) ? Boolean.valueOf(true) : null;
            }
            case LOGICAL_AND: {
                Boolean opResult = operands.get(0).conditionResult();
                if (opResult != null) {
                    return opResult == false ? false : operands.get(1).conditionResult();
                }
                opResult = operands.get(1).conditionResult();
                if (opResult == null || opResult.booleanValue()) break;
                return false;
            }
            case LOGICAL_OR: {
                Boolean opResult = operands.get(0).conditionResult();
                if (opResult != null) {
                    return opResult != false ? true : operands.get(1).conditionResult();
                }
                opResult = operands.get(1).conditionResult();
                if (opResult == null || !opResult.booleanValue()) break;
                return true;
            }
            case TERNARY: {
                Boolean opResult = operands.get(0).conditionResult();
                if (opResult != null) {
                    return operands.get(opResult != false ? 1 : 2).conditionResult();
                }
                Boolean a = operands.get(1).conditionResult();
                Boolean b = operands.get(2).conditionResult();
                return a != null && a.equals(b) ? a : null;
            }
            case NOT: {
                Boolean opResult = operands.get(0).conditionResult();
                return opResult != null ? Boolean.valueOf(opResult == false) : null;
            }
            case VOID: {
                return false;
            }
        }
        return null;
    }

    @Override
    public boolean isLeftHandSide() {
        switch (this.op) {
            case MEMBER_ACCESS: 
            case SQUARE_BRACKET: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void render(RenderContext rc) {
        TokenConsumer out = rc.getOut();
        out.mark(this.getFilePosition());
        block0 : switch (this.op.getType()) {
            case PREFIX: {
                out.consume(this.op.getSymbol());
                this.renderParam(0, rc);
                break;
            }
            case POSTFIX: {
                this.renderParam(0, rc);
                out.mark(FilePosition.endOfOrNull(this.getFilePosition()));
                out.consume(this.op.getSymbol());
                break;
            }
            case INFIX: {
                this.renderParam(0, rc);
                switch (this.getOperator()) {
                    default: {
                        out.consume(" ");
                        out.consume(this.op.getSymbol());
                        out.consume(" ");
                        this.renderParam(1, rc);
                        break block0;
                    }
                    case MEMBER_ACCESS: {
                        this.renderMemberAccess(rc);
                        break block0;
                    }
                    case COMMA: 
                }
                out.consume(this.op.getSymbol());
                this.renderParam(1, rc);
                break;
            }
            case BRACKET: {
                this.renderParam(0, rc);
                out.consume(this.op.getOpeningSymbol());
                boolean seen = false;
                for (Expression expression : this.children().subList(1, this.children().size())) {
                    if (seen) {
                        out.consume(",");
                    } else {
                        seen = true;
                    }
                    if (!Operation.parenthesize(Operator.COMMA, false, expression)) {
                        expression.render(rc);
                        continue;
                    }
                    out.consume("(");
                    expression.render(rc);
                    out.mark(FilePosition.endOfOrNull(expression.getFilePosition()));
                    out.consume(")");
                }
                out.mark(FilePosition.endOfOrNull(this.getFilePosition()));
                out.consume(this.op.getClosingSymbol());
                break;
            }
            case TERNARY: {
                this.renderParam(0, rc);
                out.consume(this.op.getOpeningSymbol());
                out.consume(" ");
                this.renderParam(1, rc);
                out.consume(this.op.getClosingSymbol());
                out.consume(" ");
                this.renderParam(2, rc);
            }
        }
    }

    private void renderParam(int i, RenderContext rc) {
        TokenConsumer out = rc.getOut();
        ParseTreeNode e = this.children().get(i);
        out.mark(e.getFilePosition());
        if (!Operation.parenthesize(this.op, 0 == i, (Expression)e)) {
            e.render(rc);
        } else {
            out.consume("(");
            e.render(rc);
            out.mark(FilePosition.endOfOrNull(this.getFilePosition()));
            out.consume(")");
        }
    }

    private void renderMemberAccess(RenderContext rc) {
        TokenConsumer out = rc.getOut();
        if (this.isKeywordAccess()) {
            out.consume(Operator.SQUARE_BRACKET.getOpeningSymbol());
            StringLiteral.renderUnquotedValue(this.getMemberName(), rc);
            out.consume(Operator.SQUARE_BRACKET.getClosingSymbol());
        } else {
            out.consume(this.op.getSymbol());
            this.renderParam(1, rc);
        }
    }

    private boolean isKeywordAccess() {
        return this.getOperator() == Operator.MEMBER_ACCESS && this.children().get(1) instanceof Reference && this.isKeyword(this.getMemberName());
    }

    private String getMemberName() {
        return ((Reference)this.children().get(1)).getIdentifierName();
    }

    private boolean isKeyword(String name) {
        return Keyword.fromString(name) != null;
    }

    private static boolean parenthesize(Operator op, boolean firstOp, Expression child) {
        int delta;
        boolean isDividend;
        if (child instanceof FunctionConstructor || child instanceof ObjectConstructor) {
            return firstOp;
        }
        if (child instanceof NumberLiteral) {
            if (firstOp && op == Operator.MEMBER_ACCESS) {
                return true;
            }
            if (OperatorType.PREFIX == op.getType()) {
                return ((NumberLiteral)child).getValue().doubleValue() < 0.0;
            }
        }
        boolean bl = isDividend = firstOp && (op == Operator.DIVISION || op == Operator.ASSIGN_DIV);
        if (isDividend && !(child instanceof Reference) && !(child instanceof NumberLiteral) && !(child instanceof Operation)) {
            return true;
        }
        if (!(child instanceof Operation)) {
            return false;
        }
        Operator childOp = ((Operation)child).getOperator();
        if (firstOp) {
            if (childOp == Operator.FUNCTION_CALL && op == Operator.MEMBER_ACCESS) {
                return false;
            }
            if (isDividend && childOp != Operator.FUNCTION_CALL && childOp != Operator.MEMBER_ACCESS) {
                return true;
            }
            if (childOp == Operator.POST_DECREMENT) {
                switch (op) {
                    case ASSIGN_RSH: 
                    case ASSIGN_USH: 
                    case RSHIFT: 
                    case RUSHIFT: 
                    case GREATER_THAN: 
                    case GREATER_EQUALS: {
                        return true;
                    }
                }
            }
        }
        if ((delta = op.getPrecedence() - childOp.getPrecedence()) < 0) {
            return true;
        }
        if (delta == 0) {
            if (op.getType() == OperatorType.PREFIX) {
                return false;
            }
            return childOp.getAssociativity() == Associativity.LEFT != firstOp;
        }
        return false;
    }

    private static int minArity(Operator op) {
        if (op == Operator.FUNCTION_CALL) {
            return 1;
        }
        return op.getType().getArity();
    }

    private static int maxArity(Operator op) {
        if (op == Operator.FUNCTION_CALL) {
            return Integer.MAX_VALUE;
        }
        return op.getType().getArity();
    }

    @Override
    public String typeOf() {
        List<? extends Expression> operands = this.children();
        switch (this.getOperator()) {
            case ASSIGN_RSH: 
            case ASSIGN_USH: 
            case RSHIFT: 
            case RUSHIFT: 
            case PRE_INCREMENT: 
            case PRE_DECREMENT: 
            case TO_NUMBER: 
            case NEGATION: 
            case INVERSE: 
            case MULTIPLICATION: 
            case DIVISION: 
            case MODULUS: 
            case SUBTRACTION: 
            case LSHIFT: 
            case BITWISE_AND: 
            case BITWISE_OR: 
            case BITWISE_XOR: 
            case ASSIGN_MUL: 
            case ASSIGN_DIV: 
            case ASSIGN_MOD: 
            case ASSIGN_SUB: 
            case ASSIGN_LSH: 
            case ASSIGN_AND: 
            case ASSIGN_XOR: 
            case ASSIGN_OR: {
                return "number";
            }
            case NOT: 
            case GREATER_THAN: 
            case GREATER_EQUALS: 
            case DELETE: 
            case IN: 
            case LESS_THAN: 
            case LESS_EQUALS: 
            case INSTANCE_OF: 
            case EQUAL: 
            case NOT_EQUAL: 
            case STRICTLY_EQUAL: 
            case STRICTLY_NOT_EQUAL: {
                return "boolean";
            }
            case VOID: {
                return "undefined";
            }
            case LOGICAL_OR: 
            case LOGICAL_AND: 
            case TERNARY: {
                String t1 = operands.get(operands.size() - 2).typeOf();
                String t2 = operands.get(operands.size() - 1).typeOf();
                return t1 != null && t1.equals(t2) ? t1 : null;
            }
            case ADDITION: {
                String t1 = operands.get(operands.size() - 2).typeOf();
                String t2 = operands.get(operands.size() - 1).typeOf();
                if ("string".equals(t1) || "string".equals(t2)) {
                    return "string";
                }
                if ("number".equals(t1) && "number".equals(t2)) {
                    return "number";
                }
                return null;
            }
            case TYPEOF: {
                return "string";
            }
            case COMMA: {
                return operands.get(1).typeOf();
            }
        }
        return null;
    }

    @Override
    public Expression fold() {
        if (this.getOperator() == Operator.FUNCTION_CALL) {
            return this.foldCall();
        }
        switch (this.children().size()) {
            case 1: {
                return this.foldUnaryOp();
            }
            case 2: {
                return this.foldBinaryOp();
            }
            case 3: {
                return this.foldTernaryOp();
            }
        }
        return this;
    }

    private Expression foldUnaryOp() {
        Expression operand = this.children().get(0);
        switch (this.op) {
            case NOT: {
                Boolean b = operand.conditionResult();
                if (b != null && operand.simplifyForSideEffect() == null) {
                    return new BooleanLiteral(this.getFilePosition(), b == false);
                }
                return this;
            }
            case TYPEOF: {
                String type = operand.typeOf();
                if (type != null && operand.simplifyForSideEffect() == null) {
                    return StringLiteral.valueOf(this.getFilePosition(), type);
                }
                return this;
            }
        }
        Object v = Operation.toLiteralValue(operand);
        if (v != null) {
            FilePosition pos = this.getFilePosition();
            switch (this.getOperator()) {
                case NEGATION: {
                    long n;
                    if (!(v instanceof Number)) break;
                    if (operand instanceof IntegerLiteral && (n = ((IntegerLiteral)operand).getValue().longValue()) != Long.MIN_VALUE && n != 0L) {
                        return new IntegerLiteral(pos, -n);
                    }
                    return new RealLiteral(pos, -((Number)v).doubleValue());
                }
                case INVERSE: {
                    if (!(v instanceof Number)) break;
                    return new IntegerLiteral(pos, ((Number)v).longValue() ^ 0xFFFFFFFFFFFFFFFFL);
                }
                case TO_NUMBER: {
                    if (!(v instanceof Number)) break;
                    return this.children().get(0);
                }
            }
        }
        return this;
    }

    private Expression foldTernaryOp() {
        Expression cond;
        Boolean condResult;
        if (this.getOperator() == Operator.TERNARY && (condResult = (cond = this.children().get(0)).conditionResult()) != null && cond.simplifyForSideEffect() == null) {
            return this.children().get(condResult != false ? 1 : 2);
        }
        return this;
    }

    private Expression foldBinaryOp() {
        Reference r;
        List<? extends Expression> operands = this.children();
        Expression left = operands.get(0);
        Expression right = operands.get(1);
        Operator op = this.getOperator();
        if (op == Operator.LOGICAL_AND || op == Operator.LOGICAL_OR) {
            Boolean bv = left.conditionResult();
            if (bv != null) {
                Expression sideEffect = left.simplifyForSideEffect();
                if (bv == (op == Operator.LOGICAL_AND)) {
                    return sideEffect == null ? right : Operation.createInfix(Operator.COMMA, sideEffect, right);
                }
                return left;
            }
            bv = right.conditionResult();
            if (bv != null && bv == (op == Operator.LOGICAL_AND) && "boolean".equals(left.typeOf()) && "boolean".equals(right.typeOf()) && right.simplifyForSideEffect() == null) {
                return left;
            }
        } else if (op == Operator.MEMBER_ACCESS && left instanceof StringLiteral && "length".equals((r = (Reference)right).getIdentifierName())) {
            return new IntegerLiteral(this.getFilePosition(), ((StringLiteral)left).getUnquotedValue().length());
        }
        Object lhs = Operation.toLiteralValue(left);
        Object rhs = Operation.toLiteralValue(right);
        if (lhs != null && rhs != null) {
            FilePosition pos = this.getFilePosition();
            switch (op) {
                case EQUAL: 
                case NOT_EQUAL: 
                case STRICTLY_EQUAL: 
                case STRICTLY_NOT_EQUAL: {
                    boolean isStrict = op == Operator.STRICTLY_EQUAL || op == Operator.STRICTLY_NOT_EQUAL;
                    boolean isEqual = op == Operator.EQUAL || op == Operator.STRICTLY_EQUAL;
                    boolean areEqual = lhs.equals(rhs);
                    if (!isStrict && !areEqual && !lhs.getClass().equals(rhs.getClass())) break;
                    return new BooleanLiteral(pos, areEqual == isEqual);
                }
                case ADDITION: {
                    if (!(lhs instanceof String) && !(rhs instanceof String)) break;
                    if (lhs instanceof Number) {
                        lhs = NumberLiteral.numberToString(((Number)lhs).doubleValue());
                    } else if (rhs instanceof Number) {
                        rhs = NumberLiteral.numberToString(((Number)rhs).doubleValue());
                    }
                    return StringLiteral.valueOf(pos, "" + lhs + rhs);
                }
            }
            if (lhs instanceof Number && rhs instanceof Number) {
                double result;
                double a = ((Number)lhs).doubleValue();
                double b = ((Number)rhs).doubleValue();
                if (Operation.isIntOp(op) && !Double.isNaN(a) && !Double.isNaN(b)) {
                    long result2;
                    switch (op) {
                        case BITWISE_AND: {
                            result2 = Operation.toInt32(a) & Operation.toInt32(b);
                            break;
                        }
                        case BITWISE_OR: {
                            result2 = Operation.toInt32(a) | Operation.toInt32(b);
                            break;
                        }
                        case BITWISE_XOR: {
                            result2 = Operation.toInt32(a) ^ Operation.toInt32(b);
                            break;
                        }
                        case LSHIFT: {
                            result2 = Operation.toInt32(a) << (int)Operation.toUint32(b);
                            break;
                        }
                        case RSHIFT: {
                            result2 = Operation.toInt32(a) >> (int)Operation.toUint32(b);
                            break;
                        }
                        case RUSHIFT: {
                            result2 = Operation.toUint32(a) >>> (int)Operation.toUint32(b);
                            break;
                        }
                        default: {
                            return this;
                        }
                    }
                    return new IntegerLiteral(pos, result2);
                }
                switch (op) {
                    case ADDITION: {
                        result = a + b;
                        break;
                    }
                    case SUBTRACTION: {
                        result = a - b;
                        break;
                    }
                    case MULTIPLICATION: {
                        result = a * b;
                        break;
                    }
                    case DIVISION: {
                        result = a / b;
                        break;
                    }
                    case MODULUS: {
                        result = Math.IEEEremainder(a, b);
                        break;
                    }
                    default: {
                        return this;
                    }
                }
                return new RealLiteral(pos, result);
            }
        }
        return this;
    }

    private Expression foldCall() {
        List<? extends Expression> operands = this.children();
        Expression fn = operands.get(0);
        if (Operation.is((ParseTreeNode)fn, Operator.MEMBER_ACCESS) && fn.children().get(0) instanceof StringLiteral) {
            Expression target;
            StringLiteral sl = (StringLiteral)fn.children().get(0);
            String methodName = ((Reference)fn.children().get(1)).getIdentifierName();
            if ("indexOf".equals(methodName) && operands.size() == 2 && (target = operands.get(1)) instanceof StringLiteral) {
                int index = sl.getUnquotedValue().indexOf(((StringLiteral)target).getUnquotedValue());
                return new IntegerLiteral(this.getFilePosition(), index);
            }
        }
        return this;
    }

    private static Object toLiteralValue(Expression e) {
        if (Operation.is((ParseTreeNode)e, Operator.VOID) && e.simplifyForSideEffect() == null) {
            return UNDEFINED;
        }
        if (e instanceof Literal) {
            if (e instanceof StringLiteral) {
                return ((StringLiteral)e).getUnquotedValue();
            }
            if (e instanceof NumberLiteral) {
                return ((NumberLiteral)e).doubleValue();
            }
            if (e instanceof BooleanLiteral || e instanceof NullLiteral) {
                return e.getValue();
            }
        }
        return null;
    }

    private static boolean isIntOp(Operator op) {
        switch (op) {
            case RSHIFT: 
            case RUSHIFT: 
            case LSHIFT: 
            case BITWISE_AND: 
            case BITWISE_OR: 
            case BITWISE_XOR: {
                return true;
            }
        }
        return false;
    }

    private static long toInt32(double n) {
        return (int)n;
    }

    private static long toUint32(double n) {
        return (long)n & 0xFFFFFFFFL;
    }
}

