/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.lang.css;

import com.google.caja.config.ConfigUtil;
import com.google.caja.config.WhiteList;
import com.google.caja.lexer.ParseException;
import com.google.caja.parser.AncestorChain;
import com.google.caja.parser.Visitor;
import com.google.caja.parser.css.CssPropertySignature;
import com.google.caja.reporting.Message;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.SimpleMessageQueue;
import com.google.caja.util.Criterion;
import com.google.caja.util.Name;
import com.google.caja.util.Pair;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CssSchema {
    private final Map<Name, CssPropertyInfo> properties = new HashMap<Name, CssPropertyInfo>();
    private final Map<Name, SymbolInfo> symbols = new HashMap<Name, SymbolInfo>();
    private final Set<Name> keywords = new HashSet<Name>();
    private final Set<Name> functionsAllowed;
    private final Set<Name> propertiesAllowed;
    private static Pair<CssSchema, List<Message>> defaultSchema;
    private static final Pattern HTML_IDENTIFIER;
    private static final Pattern CSS_IDENTIFIER;
    private static final Pattern JS_IDENTIFIER;
    private static final Criterion<String> ALL_ELEMENTS;
    private static final Criterion<String> ALL_MEDIA;

    public static CssSchema getDefaultCss21Schema(MessageQueue mq) {
        if (defaultSchema == null) {
            WhiteList fnDefs;
            WhiteList propDefs;
            SimpleMessageQueue cacheMq = new SimpleMessageQueue();
            URI fnSrc = URI.create("resource:///com/google/caja/lang/css/css-extensions-fns.json");
            URI propSrc = URI.create("resource:///com/google/caja/lang/css/css-extensions.json");
            try {
                propDefs = ConfigUtil.loadWhiteListFromJson(propSrc, ConfigUtil.RESOURCE_RESOLVER, cacheMq);
                fnDefs = ConfigUtil.loadWhiteListFromJson(fnSrc, ConfigUtil.RESOURCE_RESOLVER, cacheMq);
            }
            catch (IOException ex) {
                mq.getMessages().addAll(cacheMq.getMessages());
                throw new RuntimeException(ex);
            }
            catch (ParseException ex) {
                ex.toMessageQueue(cacheMq);
                mq.getMessages().addAll(cacheMq.getMessages());
                throw new RuntimeException(ex);
            }
            defaultSchema = Pair.pair(new CssSchema(propDefs, fnDefs), cacheMq.getMessages());
        }
        mq.getMessages().addAll((Collection)CssSchema.defaultSchema.b);
        return (CssSchema)CssSchema.defaultSchema.a;
    }

    public CssPropertyInfo getCssProperty(Name propertyName) {
        return this.properties.get(propertyName);
    }

    public Collection<CssPropertyInfo> getCssProperties() {
        return Collections.unmodifiableCollection(this.properties.values());
    }

    public SymbolInfo getSymbol(Name symbolName) {
        return this.symbols.get(symbolName);
    }

    public boolean isKeyword(Name name) {
        return this.keywords.contains(name);
    }

    public boolean isFunctionAllowed(Name name) {
        return this.functionsAllowed.contains(name);
    }

    public boolean isPropertyAllowed(Name name) {
        return this.propertiesAllowed.contains(name);
    }

    public static boolean isMediaType(String mediaType) {
        return ALL_MEDIA.accept(mediaType);
    }

    private static Criterion<String> in(String ... elementGroups) {
        final HashSet<String> elements = new HashSet<String>();
        elements.addAll(Arrays.asList(elementGroups));
        return new Criterion<String>(){

            @Override
            public boolean accept(String s) {
                return elements.contains(s);
            }
        };
    }

    private static Criterion<String> criterionFromConfig(Object type, Criterion<String> permissiveCriterion) {
        if ("*".equals(type)) {
            return permissiveCriterion;
        }
        boolean invert = false;
        if (type instanceof Map) {
            Map map = (Map)type;
            if (map.containsKey("exclude")) {
                invert = true;
                type = map.get("exclude");
            } else {
                type = map.get("include");
            }
        }
        ArrayList<String> members = new ArrayList<String>();
        for (Object member : (List)type) {
            if (member instanceof String) {
                members.add((String)member);
                continue;
            }
            members.add((String)((Map)member).get("key"));
        }
        Criterion<String> set = CssSchema.in(members.toArray(new String[0]));
        if (invert) {
            return Criterion.Factory.and(permissiveCriterion, Criterion.Factory.not(set));
        }
        return set;
    }

    private void defineProperty(Name name, String sig, String defaultValue, Criterion<String> appliesTo, boolean inherited, Criterion<String> mediaGroups, List<String> dom2properties) {
        if ("".equals(defaultValue)) {
            throw new IllegalArgumentException("Bad default value for symbol " + name + ", use null instead");
        }
        if (!CSS_IDENTIFIER.matcher(name.getCanonicalForm()).matches()) {
            throw new IllegalArgumentException("Bad property name: " + name);
        }
        for (String dom2property : dom2properties) {
            if (JS_IDENTIFIER.matcher(dom2property).matches()) continue;
            throw new IllegalArgumentException("Bad DOM2 name: " + dom2property);
        }
        CssPropertySignature csssig = CssSchema.parseSignature(name, sig);
        this.properties.put(name, new CssPropertyInfo(name, csssig, mediaGroups, inherited, appliesTo, defaultValue, dom2properties));
    }

    private void defineSymbol(Name name, String sig) {
        if (sig == null) {
            throw new NullPointerException("Null signature for symbol " + name);
        }
        if (!CSS_IDENTIFIER.matcher(name.getCanonicalForm()).matches()) {
            throw new IllegalArgumentException("Bad symbol name: " + name);
        }
        CssPropertySignature csssig = CssSchema.parseSignature(name, sig);
        this.symbols.put(name, new SymbolInfo(name, csssig));
    }

    public CssSchema(WhiteList symbolsAndProperties, WhiteList functions) {
        for (WhiteList.TypeDefinition def : symbolsAndProperties.typeDefinitions().values()) {
            List<String> dom2properties;
            String key = (String)def.get("key", null);
            String aliasKey = (String)def.get("as", null);
            if (aliasKey != null) {
                def = CssSchema.merge(def, symbolsAndProperties.typeDefinitions().get(aliasKey));
            }
            if (key.startsWith("<") && key.endsWith(">")) {
                this.defineSymbol(Name.css(key.substring(1, key.length() - 1)), (String)def.get("signature", null));
                continue;
            }
            Criterion<String> appliesTo = CssSchema.criterionFromConfig(def.get("appliesTo", "*"), ALL_ELEMENTS);
            Criterion<String> mediaGroups = CssSchema.criterionFromConfig(def.get("mediaGroups", "*"), ALL_MEDIA);
            Object dom2property = def.get("dom2property", null);
            if (dom2property instanceof String) {
                dom2properties = Collections.singletonList((String)dom2property);
            } else if (dom2property == null) {
                dom2properties = Collections.emptyList();
            } else {
                dom2properties = new ArrayList<String>();
                for (Object item : (Iterable)dom2property) {
                    dom2properties.add((String)item);
                }
            }
            this.defineProperty(Name.css(key), (String)def.get("signature", null), (String)def.get("default", null), appliesTo, Boolean.TRUE.equals(def.get("inherited", null)), mediaGroups, dom2properties);
        }
        this.functionsAllowed = new LinkedHashSet<Name>();
        for (String k : functions.allowedItems()) {
            this.functionsAllowed.add(Name.css(k));
        }
        this.propertiesAllowed = new LinkedHashSet<Name>();
        for (String k : symbolsAndProperties.allowedItems()) {
            this.propertiesAllowed.add(Name.css(k));
        }
        for (CssPropertyInfo pi : this.properties.values()) {
            pi.sig.acceptPreOrder(new Visitor(){

                @Override
                public boolean visit(AncestorChain<?> ancestors) {
                    Object n = ancestors.node;
                    if (n instanceof CssPropertySignature.LiteralSignature) {
                        String kw = ((CssPropertySignature.LiteralSignature)n).value;
                        CssSchema.this.keywords.add(Name.css(kw));
                    }
                    return true;
                }
            }, null);
        }
        for (SymbolInfo si : this.symbols.values()) {
            si.sig.acceptPreOrder(new Visitor(){

                @Override
                public boolean visit(AncestorChain<?> ancestors) {
                    Object n = ancestors.node;
                    if (n instanceof CssPropertySignature.LiteralSignature) {
                        String kw = ((CssPropertySignature.LiteralSignature)n).value;
                        CssSchema.this.keywords.add(Name.css(kw));
                    }
                    return true;
                }
            }, null);
        }
        this.keywords.add(Name.css("initial"));
    }

    private static CssPropertySignature parseSignature(Name name, String sig) {
        try {
            return CssPropertySignature.Parser.parseSignature(sig);
        }
        catch (RuntimeException ex) {
            throw new RuntimeException("Error parsing symbol " + name + " with signature " + sig, ex);
        }
    }

    private static WhiteList.TypeDefinition merge(final WhiteList.TypeDefinition wl1, final WhiteList.TypeDefinition wl2) {
        return new WhiteList.TypeDefinition(){

            public Object get(String key, Object defaultValue) {
                return wl1.get(key, wl2.get(key, defaultValue));
            }
        };
    }

    static {
        HTML_IDENTIFIER = Pattern.compile("^[\\w\\-]+$");
        CSS_IDENTIFIER = Pattern.compile("^[a-zA-Z\\-][\\w\\-]*$");
        JS_IDENTIFIER = Pattern.compile("^[a-zA-Z_][\\w_]*$");
        ALL_ELEMENTS = new RegexpCriterion(HTML_IDENTIFIER);
        ALL_MEDIA = CssSchema.in("all", "aural", "braille", "embossed", "handheld", "print", "projection", "screen", "tty", "tv");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RegexpCriterion
    implements Criterion<String> {
        private final Pattern p;

        RegexpCriterion(Pattern p) {
            this.p = p;
        }

        @Override
        public boolean accept(String s) {
            return s != null && this.p.matcher(s).matches();
        }
    }

    public static class SymbolInfo {
        public final Name name;
        public final CssPropertySignature sig;

        private SymbolInfo(Name name, CssPropertySignature sig) {
            this.name = name;
            this.sig = sig;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CssPropertyInfo
    extends SymbolInfo {
        public final Criterion<String> mediaGroups;
        public final boolean inherited;
        public final Criterion<String> appliesTo;
        public final String defaultValue;
        public final List<String> dom2properties;

        private CssPropertyInfo(Name name, CssPropertySignature sig, Criterion<String> mediaGroups, boolean inherited, Criterion<String> appliesTo, String defaultValue, List<String> dom2properties) {
            super(name, sig);
            this.mediaGroups = mediaGroups;
            this.inherited = inherited;
            this.appliesTo = appliesTo;
            this.defaultValue = defaultValue;
            this.dom2properties = dom2properties;
        }
    }
}

