/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.ancillary.jsdoc;

import com.google.caja.ancillary.jsdoc.AbstractAnnotation;
import com.google.caja.lexer.FilePosition;
import com.google.caja.reporting.RenderContext;
import java.util.Collections;

public final class TextAnnotation
extends AbstractAnnotation {
    TextAnnotation(String text, FilePosition pos) {
        super(text, Collections.emptyList(), pos);
        if (text == null) {
            throw new NullPointerException();
        }
    }

    public void render(RenderContext r) {
        r.getOut().mark(this.getFilePosition());
        r.getOut().consume(this.getValue());
    }

    public TextAnnotation slice(int start, int end) {
        return TextAnnotation.slice(this.getValue(), this.getFilePosition(), start, end);
    }

    public static TextAnnotation slice(String value, FilePosition pos, int start, int end) {
        int sline = pos.startLineNo();
        int scil = pos.startCharInLine();
        for (int i = 0; i < start; ++i) {
            char ch = value.charAt(i);
            if (ch == '\r') {
                if (i + 1 >= value.length() || '\n' != value.charAt(i + 1)) {
                    ++sline;
                }
                scil = 1;
                continue;
            }
            if (ch == '\n') {
                ++sline;
                scil = 1;
                continue;
            }
            ++scil;
        }
        int eline = sline;
        int ecil = scil;
        for (int i = start; i < end; ++i) {
            char ch = value.charAt(i);
            if (ch == '\r') {
                if (i + 1 >= value.length() || '\n' != value.charAt(i + 1)) {
                    ++eline;
                }
                ecil = 1;
                continue;
            }
            if (ch == '\n') {
                ++eline;
                ecil = 1;
                continue;
            }
            ++ecil;
        }
        return new TextAnnotation(value.substring(start, end), FilePosition.instance(pos.source(), sline, pos.startCharInFile() + start, scil, end - start));
    }
}

