/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.annotations.gwt.client.annotea;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.core.client.GWT;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.Response;
import com.google.gwt.http.client.URL;
import com.google.gwt.user.client.Window;
import org.nuxeo.ecm.platform.annotations.gwt.client.annotea.AnnotationXmlGenerator;
import org.nuxeo.ecm.platform.annotations.gwt.client.annotea.AnnoteaResponseManager;
import org.nuxeo.ecm.platform.annotations.gwt.client.configuration.WebConfiguration;
import org.nuxeo.ecm.platform.annotations.gwt.client.controler.AnnotationController;
import org.nuxeo.ecm.platform.annotations.gwt.client.model.Annotation;

public class AnnoteaClient {
    private static AnnoteaResponseManager responseManager;
    private static WebConfiguration webConfiguration;
    private RequestBuilder postRequest;
    private static AnnotationController controller;

    public AnnoteaClient(AnnotationController annotationController) {
        controller = annotationController;
        responseManager = new AnnoteaResponseManager(annotationController);
        webConfiguration = annotationController.getWebConfiguration();
    }

    public void submitAnnotation(Annotation newAnnotation) {
        AnnotationXmlGenerator xmlGenerator = new AnnotationXmlGenerator(webConfiguration, newAnnotation);
        String request = xmlGenerator.generateXml();
        this.postRequest = new RequestBuilder(RequestBuilder.POST, URL.encode((String)controller.getAnnoteaServerUrl()));
        try {
            this.postRequest.sendRequest(request, new RequestCallback(){

                public void onError(Request request, Throwable exception) {
                    Window.alert((String)("Error while sending data to annotea server: " + exception.toString()));
                }

                public void onResponseReceived(Request request, Response response) {
                    responseManager.processSubmitAnnotationResponse(response.getText());
                    AnnoteaClient.this.getAnnotationList(controller.getDocumentUrl());
                    controller.reloadAnnotations();
                }
            });
        }
        catch (Throwable e) {
            GWT.log((String)"Error while sending new annotation", (Throwable)e);
            Log.debug((String)"Error while sending new annotation", (Throwable)e);
        }
    }

    public void getAnnotationList(String annotates) {
        this.getAnnotationList(annotates, false);
    }

    public void getAnnotationList(String annotates, final boolean forceDecorate) {
        if (annotates.contains("?")) {
            annotates = annotates.substring(0, annotates.indexOf(63));
        }
        String url = controller.getAnnoteaServerUrl() + "?w3c_annotates=" + annotates;
        RequestBuilder getRequest = new RequestBuilder(RequestBuilder.GET, URL.encode((String)url));
        try {
            getRequest.sendRequest(null, new RequestCallback(){

                public void onError(Request request, Throwable exception) {
                }

                public void onResponseReceived(Request request, Response response) {
                    responseManager.processAnnotationListResponse(response.getText());
                    if (forceDecorate) {
                        controller.updateAnnotations(true);
                    }
                }
            });
        }
        catch (RequestException e) {
            GWT.log((String)("Error while requesting annotations: " + url), (Throwable)e);
            Log.debug((String)("Error while requesting annotations: " + url), (Throwable)e);
            Window.alert((String)e.toString());
        }
    }

    public void deleteAnnotation(String annotates, Annotation annotation) {
        if (annotates.contains("?")) {
            annotates = annotates.substring(0, annotates.indexOf(63));
        }
        String url = controller.getAnnoteaServerUrl() + "/" + annotation.getUUID();
        url = url + "?document_url=" + annotates;
        RequestBuilder req = new RequestBuilder("DELETE", url){};
        try {
            req.sendRequest(null, new RequestCallback(){

                public void onError(Request arg0, Throwable arg1) {
                }

                public void onResponseReceived(Request arg0, Response arg1) {
                    AnnoteaClient.this.getAnnotationList(Window.Location.getHref(), true);
                    controller.reloadAnnotations();
                }
            });
        }
        catch (RequestException e) {
            GWT.log((String)("Error while deleting an annotation: " + url), (Throwable)e);
            Log.debug((String)("Error while deleting an annotation: " + url), (Throwable)e);
        }
    }
}

