/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.oauth.tokens;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.platform.oauth.tokens.NuxeoOAuthToken;
import org.nuxeo.ecm.platform.oauth.tokens.OAuthToken;
import org.nuxeo.ecm.platform.oauth.tokens.OAuthTokenStore;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.DefaultComponent;

public class OAuthTokenStoreImpl
extends DefaultComponent
implements OAuthTokenStore {
    protected static final Log log = LogFactory.getLog(OAuthTokenStoreImpl.class);
    public static final String DIRECTORY_NAME = "oauthTokens";
    protected Map<String, OAuthToken> requestTokenStore = new HashMap<String, OAuthToken>();

    @Override
    public OAuthToken addVerifierToRequestToken(String token, Long duration) {
        NuxeoOAuthToken rToken = (NuxeoOAuthToken)this.getRequestToken(token);
        if (rToken != null) {
            rToken.verifier = "NX-VERIF-" + UUID.randomUUID().toString();
            rToken.durationInMinutes = duration;
        }
        return rToken;
    }

    @Override
    public OAuthToken createAccessTokenFromRequestToken(OAuthToken requestToken) {
        String token;
        NuxeoOAuthToken aToken = new NuxeoOAuthToken((NuxeoOAuthToken)requestToken);
        aToken.token = token = "NX-AT-" + UUID.randomUUID().toString();
        aToken.tokenSecret = "NX-ATS-" + UUID.randomUUID().toString();
        aToken.type = OAuthToken.Type.ACCESS;
        try {
            aToken = this.storeAccessTokenAsDirectoryEntry(aToken);
            this.removeRequestToken(requestToken.getToken());
            return aToken;
        }
        catch (Exception e) {
            log.error((Object)"Error during directory persistence", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NuxeoOAuthToken getClientAccessToken(String appId, String owner) throws Exception {
        DirectoryService ds = (DirectoryService)Framework.getService(DirectoryService.class);
        try (Session session = null;){
            session = ds.open(DIRECTORY_NAME);
            HashMap<String, Object> filter = new HashMap<String, Object>();
            filter.put("appId", appId);
            filter.put("clientId", owner);
            filter.put("clientToken", 1);
            DocumentModelList entries = session.query(filter);
            if (entries.size() == 0) {
                NuxeoOAuthToken nuxeoOAuthToken = null;
                return nuxeoOAuthToken;
            }
            if (entries.size() > 1) {
                log.error((Object)"Found several tokens");
            }
            NuxeoOAuthToken nuxeoOAuthToken = this.getTokenFromDirectoryEntry((DocumentModel)entries.get(0));
            return nuxeoOAuthToken;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeClientAccessToken(String appId, String owner) throws Exception {
        DirectoryService ds = (DirectoryService)Framework.getService(DirectoryService.class);
        try (Session session = null;){
            session = ds.open(DIRECTORY_NAME);
            HashMap<String, Object> filter = new HashMap<String, Object>();
            filter.put("appId", appId);
            filter.put("clientId", owner);
            filter.put("clientToken", 1);
            DocumentModelList entries = session.query(filter);
            if (entries.size() == 0) {
                return;
            }
            if (entries.size() > 1) {
                log.error((Object)"Found several tokens");
            }
            session.deleteEntry((DocumentModel)entries.get(0));
        }
    }

    @Override
    public void storeClientAccessToken(String consumerKey, String callBack, String token, String tokenSecret, String appId, String owner) {
        NuxeoOAuthToken aToken = new NuxeoOAuthToken(consumerKey, callBack);
        aToken.token = token;
        aToken.tokenSecret = tokenSecret;
        if (appId != null) {
            aToken.appId = appId;
        }
        aToken.clientToken = true;
        aToken.clientId = owner;
        try {
            aToken = this.storeAccessTokenAsDirectoryEntry(aToken);
        }
        catch (Exception e) {
            log.error((Object)"Error during directory persistence", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NuxeoOAuthToken getTokenFromDirectory(String token) throws Exception {
        DirectoryService ds = (DirectoryService)Framework.getService(DirectoryService.class);
        try (Session session = null;){
            session = ds.open(DIRECTORY_NAME);
            DocumentModel entry = session.getEntry(token);
            if (entry == null) {
                NuxeoOAuthToken nuxeoOAuthToken = null;
                return nuxeoOAuthToken;
            }
            NuxeoOAuthToken nuxeoOAuthToken = this.getTokenFromDirectoryEntry(entry);
            return nuxeoOAuthToken;
        }
    }

    protected NuxeoOAuthToken getTokenFromDirectoryEntry(DocumentModel entry) throws ClientException {
        return new NuxeoOAuthToken(entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NuxeoOAuthToken storeAccessTokenAsDirectoryEntry(NuxeoOAuthToken aToken) throws Exception {
        DirectoryService ds = (DirectoryService)Framework.getService(DirectoryService.class);
        try (Session session = null;){
            session = ds.open(DIRECTORY_NAME);
            DocumentModel entry = session.getEntry(aToken.getToken());
            if (entry == null) {
                HashMap<String, String> init = new HashMap<String, String>();
                init.put("token", aToken.getToken());
                entry = session.createEntry(init);
            }
            aToken.updateEntry(entry);
            session.updateEntry(entry);
            session.commit();
            NuxeoOAuthToken nuxeoOAuthToken = this.getTokenFromDirectoryEntry(session.getEntry(aToken.getToken()));
            return nuxeoOAuthToken;
        }
    }

    @Override
    public OAuthToken createRequestToken(String consumerKey, String callBack) {
        String token;
        NuxeoOAuthToken rToken = new NuxeoOAuthToken(consumerKey, callBack);
        rToken.token = token = "NX-RT-" + consumerKey + "-" + UUID.randomUUID().toString();
        rToken.tokenSecret = "NX-RTS-" + consumerKey + UUID.randomUUID().toString();
        rToken.type = OAuthToken.Type.REQUEST;
        this.requestTokenStore.put(token, rToken);
        return rToken;
    }

    @Override
    public OAuthToken getAccessToken(String token) {
        try {
            return this.getTokenFromDirectory(token);
        }
        catch (Exception e) {
            log.error((Object)"Error while accessing Token SQL storage", (Throwable)e);
            return null;
        }
    }

    @Override
    public OAuthToken getRequestToken(String token) {
        return this.requestTokenStore.get(token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<OAuthToken> listAccessTokenForConsumer(String consumerKey) {
        ArrayList<OAuthToken> result = new ArrayList<OAuthToken>();
        try {
            DirectoryService ds = (DirectoryService)Framework.getService(DirectoryService.class);
            try (Session session = null;){
                session = ds.open(DIRECTORY_NAME);
                HashMap<String, Object> filter = new HashMap<String, Object>();
                filter.put("consumerKey", consumerKey);
                filter.put("clientToken", 0);
                DocumentModelList entries = session.query(filter);
                for (DocumentModel entry : entries) {
                    result.add(new NuxeoOAuthToken(entry));
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Error during token listing", (Throwable)e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<OAuthToken> listAccessTokenForUser(String login) {
        ArrayList<OAuthToken> result = new ArrayList<OAuthToken>();
        try {
            DirectoryService ds = (DirectoryService)Framework.getService(DirectoryService.class);
            try (Session session = null;){
                session = ds.open(DIRECTORY_NAME);
                HashMap<String, Object> filter = new HashMap<String, Object>();
                filter.put("nuxeoLogin", login);
                filter.put("clientToken", 0);
                DocumentModelList entries = session.query(filter);
                for (DocumentModel entry : entries) {
                    result.add(new NuxeoOAuthToken(entry));
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Error during token listing", (Throwable)e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAccessToken(String token) throws Exception {
        DirectoryService ds = (DirectoryService)Framework.getService(DirectoryService.class);
        try (Session session = null;){
            session = ds.open(DIRECTORY_NAME);
            session.deleteEntry(token);
            session.commit();
        }
    }

    @Override
    public void removeRequestToken(String token) {
        this.requestTokenStore.remove(token);
    }
}

