/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.oauth.consumers;

import net.oauth.OAuthConsumer;
import net.oauth.OAuthServiceProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;

public class NuxeoOAuthConsumer
extends OAuthConsumer {
    public static final String ALLOW_SIGNEDFETCH = "allowSignedFetch";
    public static final String SIGNEDFETCH_NONE = "none";
    public static final String SIGNEDFETCH_OPENSOCIAL_VIEWER = "opensocial:viewer";
    public static final String SIGNEDFETCH_OPENSOCIAL_OWNER = "opensocial:owner";
    public static final String SIGNEDFETCH_DEDICATED_USER = "nuxeo:user";
    public static final String SCHEMA = "oauthConsumer";
    protected static final Log log = LogFactory.getLog(NuxeoOAuthConsumer.class);
    private static final long serialVersionUID = 1L;
    protected String publicKey;
    protected String description;
    protected String signedFetchSupport = "none";
    protected String dedicatedLogin;
    protected boolean enabled = true;
    protected boolean allowBypassVerifier = false;

    public static NuxeoOAuthConsumer createFromDirectoryEntry(DocumentModel entry, String keyType) throws ClientException {
        Boolean allowBypassVerifierFlag;
        String callbackURL = (String)entry.getProperty(SCHEMA, "callbackURL");
        String consumerKey = (String)entry.getProperty(SCHEMA, "consumerKey");
        String consumerSecret = (String)entry.getProperty(SCHEMA, "consumerSecret");
        String rsaKey = (String)entry.getProperty(SCHEMA, "publicKey");
        NuxeoOAuthConsumer consumer = new NuxeoOAuthConsumer(callbackURL, consumerKey, consumerSecret, null);
        if ("RSA-SHA1".equals(keyType) && rsaKey != null) {
            if (rsaKey.contains("-----BEGIN PUBLIC KEY-----")) {
                consumer.setProperty("RSA-SHA1.PublicKey", rsaKey);
            } else {
                consumer.setProperty("RSA-SHA1.X509Certificate", rsaKey);
            }
        }
        consumer.publicKey = rsaKey;
        consumer.description = (String)entry.getProperty(SCHEMA, "description");
        consumer.signedFetchSupport = (String)entry.getProperty(SCHEMA, "signedFetchSupport");
        consumer.dedicatedLogin = (String)entry.getProperty(SCHEMA, "dedicatedLogin");
        Boolean enabledFlag = (Boolean)entry.getProperty(SCHEMA, "enabled");
        if (Boolean.FALSE.equals(enabledFlag)) {
            consumer.enabled = false;
        }
        if (Boolean.TRUE.equals(allowBypassVerifierFlag = (Boolean)entry.getProperty(SCHEMA, "allowBypassVerifier"))) {
            consumer.allowBypassVerifier = true;
        }
        return consumer;
    }

    public NuxeoOAuthConsumer(String callbackURL, String consumerKey, String consumerSecret, OAuthServiceProvider serviceProvider) {
        super(callbackURL, consumerKey, consumerSecret, serviceProvider);
    }

    protected DocumentModel asDocumentModel(DocumentModel entry) throws ClientException {
        entry.setProperty(SCHEMA, "callbackURL", (Object)this.callbackURL);
        entry.setProperty(SCHEMA, "consumerKey", (Object)this.consumerKey);
        entry.setProperty(SCHEMA, "consumerSecret", (Object)this.consumerSecret);
        entry.setProperty(SCHEMA, "publicKey", (Object)this.publicKey);
        entry.setProperty(SCHEMA, "description", (Object)this.description);
        entry.setProperty(SCHEMA, "signedFetchSupport", (Object)this.signedFetchSupport);
        entry.setProperty(SCHEMA, "dedicatedLogin", (Object)this.dedicatedLogin);
        entry.setProperty(SCHEMA, "enabled", (Object)this.enabled);
        entry.setProperty(SCHEMA, "allowBypassVerifier", (Object)this.allowBypassVerifier);
        return entry;
    }

    public String getCallbackURL() {
        return this.callbackURL;
    }

    public String getConsumerKey() {
        return this.consumerKey;
    }

    public String getConsumerSecret() {
        return this.consumerSecret;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public boolean allowSignedFetch() {
        if (this.signedFetchSupport == null || SIGNEDFETCH_NONE.equals(this.signedFetchSupport)) {
            return false;
        }
        return !SIGNEDFETCH_DEDICATED_USER.equals(this.signedFetchSupport) || this.dedicatedLogin != null;
    }

    public String getSignedFetchUser() {
        if (!this.allowSignedFetch()) {
            return null;
        }
        if (this.signedFetchSupport.startsWith(SIGNEDFETCH_DEDICATED_USER)) {
            return this.dedicatedLogin;
        }
        return this.signedFetchSupport;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSecret(String type) {
        if (type == null || "HMAC-SHA1".equals(type)) {
            return this.consumerSecret;
        }
        if ("RSA-SHA1".equals(type)) {
            return "";
        }
        log.error((Object)("Unknown type of key :" + type));
        return null;
    }

    public boolean allowBypassVerifier() {
        return this.allowBypassVerifier;
    }
}

