/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.web.config;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsecurity.config.ConfigurationException;
import org.jsecurity.config.IniConfiguration;
import org.jsecurity.config.ReflectionBuilder;
import org.jsecurity.mgt.RealmSecurityManager;
import org.jsecurity.util.AntPathMatcher;
import org.jsecurity.util.PatternMatcher;
import org.jsecurity.util.StringUtils;
import org.jsecurity.web.DefaultWebSecurityManager;
import org.jsecurity.web.WebUtils;
import org.jsecurity.web.config.WebConfiguration;
import org.jsecurity.web.filter.PathConfigProcessor;
import org.jsecurity.web.filter.PathMatchingFilter;
import org.jsecurity.web.filter.authc.AnonymousFilter;
import org.jsecurity.web.filter.authc.BasicHttpAuthenticationFilter;
import org.jsecurity.web.filter.authc.FormAuthenticationFilter;
import org.jsecurity.web.filter.authc.UserFilter;
import org.jsecurity.web.filter.authz.PermissionsAuthorizationFilter;
import org.jsecurity.web.filter.authz.RolesAuthorizationFilter;
import org.jsecurity.web.servlet.ProxiedFilterChain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IniWebConfiguration
extends IniConfiguration
implements WebConfiguration {
    private static final transient Log log = LogFactory.getLog(IniWebConfiguration.class);
    public static final String FILTERS = "filters";
    public static final String URLS = "urls";
    protected FilterConfig filterConfig;
    protected Map<String, List<Filter>> chains;
    protected PatternMatcher pathMatcher = new AntPathMatcher();

    public IniWebConfiguration() {
        this.chains = new LinkedHashMap<String, List<Filter>>();
    }

    public PatternMatcher getPathMatcher() {
        return this.pathMatcher;
    }

    public void setPathMatcher(PatternMatcher pathMatcher) {
        this.pathMatcher = pathMatcher;
    }

    public FilterConfig getFilterConfig() {
        return this.filterConfig;
    }

    public void setFilterConfig(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
    }

    @Override
    public FilterChain getChain(ServletRequest request, ServletResponse response, FilterChain originalChain) {
        if (this.chains == null || this.chains.isEmpty()) {
            return null;
        }
        String requestURI = this.getPathWithinApplication(request);
        for (String path : this.chains.keySet()) {
            if (!this.pathMatches(path, requestURI)) continue;
            if (log.isTraceEnabled()) {
                log.trace((Object)("Matched path [" + path + "] for requestURI [" + requestURI + "].  " + "Utilizing corresponding filter chain..."));
            }
            return this.getChain(path, originalChain);
        }
        return null;
    }

    protected FilterChain getChain(String chainUrl, FilterChain originalChain) {
        List<Filter> pathFilters = this.chains.get(chainUrl);
        if (pathFilters != null && !pathFilters.isEmpty()) {
            return this.createChain(pathFilters, originalChain);
        }
        return null;
    }

    protected FilterChain createChain(List<Filter> filters, FilterChain originalChain) {
        return new ProxiedFilterChain(originalChain, filters);
    }

    protected boolean pathMatches(String pattern, String path) {
        PatternMatcher pathMatcher = this.getPathMatcher();
        return pathMatcher.matches(pattern, path);
    }

    protected String getPathWithinApplication(ServletRequest request) {
        return WebUtils.getPathWithinApplication(WebUtils.toHttp(request));
    }

    @Override
    protected RealmSecurityManager newSecurityManagerInstance() {
        return new DefaultWebSecurityManager();
    }

    @Override
    protected void afterSecurityManagerSet(Map<String, Map<String, String>> sections) {
        Map<String, String> section = sections.get(FILTERS);
        Map<String, Filter> filters = this.getFilters(section);
        section = sections.get(URLS);
        this.chains = this.createChains(section, filters);
        this.initFilters(this.chains);
    }

    protected void initFilters(Map<String, List<Filter>> chains) {
        if (chains == null || chains.isEmpty()) {
            return;
        }
        LinkedHashSet<Filter> filters = new LinkedHashSet<Filter>();
        for (List<Filter> pathFilters : chains.values()) {
            filters.addAll(pathFilters);
        }
        for (Filter filter : filters) {
            this.initFilter(filter);
        }
    }

    protected void initFilter(Filter filter) {
        try {
            filter.init(this.getFilterConfig());
        }
        catch (ServletException e) {
            throw new ConfigurationException(e);
        }
    }

    protected Map<String, Filter> getFilters(Map<String, String> section) {
        Map filters = this.createDefaultFilters();
        if (section != null && !section.isEmpty()) {
            ReflectionBuilder builder = new ReflectionBuilder(filters);
            Map built = builder.buildObjects(section);
            this.assertFilters(built);
            filters = built;
        }
        return filters;
    }

    protected void assertFilters(Map<String, ?> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            this.assertFilter(key, value);
        }
    }

    protected void assertFilter(String name, Object o) throws ConfigurationException {
        if (!(o instanceof Filter)) {
            String msg = "[filters] section specified a filter named '" + name + "', which does not " + "implement the " + Filter.class.getName() + " interface.  Only Filter implementations may be " + "defined.";
            throw new ConfigurationException(msg);
        }
    }

    protected Map<String, Filter> createDefaultFilters() {
        LinkedHashMap<String, Filter> filters = new LinkedHashMap<String, Filter>();
        String name = "anon";
        PathMatchingFilter filter = new AnonymousFilter();
        filter.setName(name);
        filters.put(name, filter);
        name = "user";
        filter = new UserFilter();
        filter.setName(name);
        filters.put(name, filter);
        name = "authc";
        filter = new FormAuthenticationFilter();
        filter.setName(name);
        filters.put(name, filter);
        name = "authcBasic";
        filter = new BasicHttpAuthenticationFilter();
        filter.setName(name);
        filters.put(name, filter);
        name = "roles";
        filter = new RolesAuthorizationFilter();
        filter.setName(name);
        filters.put(name, filter);
        name = "perms";
        filter = new PermissionsAuthorizationFilter();
        filter.setName(name);
        filters.put(name, filter);
        return filters;
    }

    public Map<String, List<Filter>> createChains(Map<String, String> urls, Map<String, Filter> filters) {
        if (urls == null || urls.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No urls to process.");
            }
            return null;
        }
        if (filters == null || filters.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No filters to process.");
            }
            return null;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"Before url processing.");
        }
        LinkedHashMap<String, List<Filter>> pathChains = new LinkedHashMap<String, List<Filter>>(urls.size());
        for (Map.Entry<String, String> entry : urls.entrySet()) {
            String[] filterTokens;
            String path = entry.getKey();
            String value = entry.getValue();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Processing path [" + path + "] with value [" + value + "]"));
            }
            ArrayList<Filter> pathFilters = new ArrayList<Filter>();
            for (String token : filterTokens = StringUtils.split(value, ',', '[', ']', true, true)) {
                Filter filter;
                String[] nameAndConfig = token.split("\\[", 2);
                String name = nameAndConfig[0];
                String config = null;
                if (nameAndConfig.length == 2) {
                    config = nameAndConfig[1];
                    config = config.substring(0, config.length() - 1);
                }
                if ((filter = filters.get(name)) == null) {
                    String msg = "Path [" + path + "] specified a filter named '" + name + "', but that " + "filter has not been specified in the [" + FILTERS + "] section.";
                    throw new ConfigurationException(msg);
                }
                if (filter instanceof PathConfigProcessor) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Applying path [" + path + "] to filter [" + name + "] " + "with config [" + config + "]"));
                    }
                    ((PathConfigProcessor)filter).processPathConfig(path, config);
                }
                pathFilters.add(filter);
            }
            if (pathFilters.isEmpty()) continue;
            pathChains.put(path, pathFilters);
        }
        if (pathChains.isEmpty()) {
            return null;
        }
        return pathChains;
    }
}

