/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.web.attr;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsecurity.web.attr.AbstractWebAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestParamAttribute<T>
extends AbstractWebAttribute<T> {
    private static final Log log = LogFactory.getLog(RequestParamAttribute.class);

    public RequestParamAttribute() {
        this.setMutable(false);
        this.setCheckRequestParams(false);
    }

    public RequestParamAttribute(String name) {
        super(name);
        this.setMutable(false);
        this.setCheckRequestParams(false);
    }

    @Override
    protected T onRetrieveValue(ServletRequest request, ServletResponse response) {
        return this.getFromRequestParam(request);
    }

    @Override
    protected void onStoreValue(T value, ServletRequest request, ServletResponse response) {
        throw new UnsupportedOperationException("RequestParamStores are read-only.");
    }

    @Override
    public void removeValue(ServletRequest request, ServletResponse response) {
        if (log.isWarnEnabled()) {
            String msg = "Asked to remove WebAttribute value.  A " + this.getClass().getName() + " implementation " + "cannot remove values from the request params.";
            log.warn((Object)msg);
        }
    }
}

