/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.spring.remoting;

import java.io.Serializable;
import org.aopalliance.intercept.MethodInvocation;
import org.jsecurity.session.Session;
import org.springframework.remoting.support.DefaultRemoteInvocationFactory;
import org.springframework.remoting.support.RemoteInvocation;

public class SecureRemoteInvocationFactory
extends DefaultRemoteInvocationFactory {
    public static final String SESSION_ID_KEY = Session.class.getName() + "_ID_KEY";
    private static final String SESSION_ID_SYSTEM_PROPERTY_NAME = "jsecurity.session.id";

    public RemoteInvocation createRemoteInvocation(MethodInvocation methodInvocation) {
        String sessionId = System.getProperty(SESSION_ID_SYSTEM_PROPERTY_NAME);
        if (sessionId == null) {
            throw new IllegalStateException("System property [jsecurity.session.id] is not set.  This property must be set to the JSecurity session ID for remote calls to function.");
        }
        RemoteInvocation ri = new RemoteInvocation(methodInvocation);
        ri.addAttribute(SESSION_ID_KEY, (Serializable)((Object)sessionId));
        return ri;
    }
}

