/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.session.mgt;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsecurity.authz.HostUnauthorizedException;
import org.jsecurity.session.ExpiredSessionException;
import org.jsecurity.session.InvalidSessionException;
import org.jsecurity.session.Session;
import org.jsecurity.session.mgt.AbstractSessionManager;
import org.jsecurity.session.mgt.ExecutorServiceSessionValidationScheduler;
import org.jsecurity.session.mgt.SessionValidationScheduler;
import org.jsecurity.session.mgt.ValidatingSession;
import org.jsecurity.session.mgt.ValidatingSessionManager;
import org.jsecurity.util.Destroyable;
import org.jsecurity.util.LifecycleUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractValidatingSessionManager
extends AbstractSessionManager
implements ValidatingSessionManager,
Destroyable {
    private static final Log log = LogFactory.getLog(AbstractValidatingSessionManager.class);
    protected static final long MILLIS_PER_SECOND = 1000L;
    protected static final long MILLIS_PER_MINUTE = 60000L;
    protected static final long MILLIS_PER_HOUR = 3600000L;
    public static final long DEFAULT_GLOBAL_SESSION_TIMEOUT = 1800000L;
    public static final long DEFAULT_SESSION_VALIDATION_INTERVAL = 3600000L;
    protected boolean sessionValidationSchedulerEnabled = true;
    protected SessionValidationScheduler sessionValidationScheduler = null;
    protected long sessionValidationInterval = 3600000L;
    protected long globalSessionTimeout = 1800000L;

    public boolean isSessionValidationSchedulerEnabled() {
        return this.sessionValidationSchedulerEnabled;
    }

    public void setSessionValidationSchedulerEnabled(boolean sessionValidationSchedulerEnabled) {
        this.sessionValidationSchedulerEnabled = sessionValidationSchedulerEnabled;
    }

    public void setSessionValidationScheduler(SessionValidationScheduler sessionValidationScheduler) {
        this.sessionValidationScheduler = sessionValidationScheduler;
    }

    public SessionValidationScheduler getSessionValidationScheduler() {
        return this.sessionValidationScheduler;
    }

    public void enableSessionValidationIfNecessary() {
        SessionValidationScheduler scheduler = this.getSessionValidationScheduler();
        if (this.isSessionValidationSchedulerEnabled() && (scheduler == null || !scheduler.isEnabled())) {
            this.enableSessionValidation();
        }
    }

    public long getGlobalSessionTimeout() {
        return this.globalSessionTimeout;
    }

    public void setGlobalSessionTimeout(int globalSessionTimeout) {
        this.globalSessionTimeout = globalSessionTimeout;
    }

    public void setSessionValidationInterval(long sessionValidationInterval) {
        this.sessionValidationInterval = sessionValidationInterval;
    }

    public long getSessionValidationInterval() {
        return this.sessionValidationInterval;
    }

    @Override
    protected final Session doGetSession(Serializable sessionId) throws InvalidSessionException {
        this.enableSessionValidationIfNecessary();
        return this.retrieveSession(sessionId);
    }

    protected abstract Session retrieveSession(Serializable var1) throws InvalidSessionException;

    @Override
    protected final Session createSession(InetAddress originatingHost) throws HostUnauthorizedException, IllegalArgumentException {
        this.enableSessionValidationIfNecessary();
        return this.doCreateSession(originatingHost);
    }

    protected abstract Session doCreateSession(InetAddress var1) throws HostUnauthorizedException, IllegalArgumentException;

    protected void validate(Session session) throws InvalidSessionException {
        if (session instanceof ValidatingSession) {
            try {
                ((ValidatingSession)session).validate();
            }
            catch (ExpiredSessionException ese) {
                this.notifyExpiration(session);
                this.onExpiration(session);
                throw ese;
            }
        } else {
            String msg = "The " + this.getClass().getName() + " implementation only supports validating " + "Session implementations of the " + ValidatingSession.class.getName() + " interface.  " + "Please either implement this interface in your session implementation or override the " + this.getClass().getName() + ".validate(Session) method to perform validation.";
            throw new IllegalStateException(msg);
        }
    }

    protected long getTimeout(Session session) {
        return session.getTimeout();
    }

    protected SessionValidationScheduler createSessionValidationScheduler() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"No sessionValidationScheduler set.  Attempting to create default instance.");
        }
        ExecutorServiceSessionValidationScheduler scheduler = new ExecutorServiceSessionValidationScheduler(this);
        scheduler.setInterval(this.getSessionValidationInterval());
        if (log.isTraceEnabled()) {
            log.trace((Object)("Created default SessionValidationScheduler instance of type [" + scheduler.getClass().getName() + "]."));
        }
        return scheduler;
    }

    protected void enableSessionValidation() {
        SessionValidationScheduler scheduler = this.getSessionValidationScheduler();
        if (scheduler == null) {
            scheduler = this.createSessionValidationScheduler();
            this.setSessionValidationScheduler(scheduler);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"Enabling session validation scheduler...");
        }
        scheduler.enableSessionValidation();
        this.afterSessionValidationEnabled();
    }

    protected void afterSessionValidationEnabled() {
    }

    protected void disableSessionValidation() {
        this.beforeSessionValidationDisabled();
        SessionValidationScheduler scheduler = this.getSessionValidationScheduler();
        if (scheduler != null) {
            block4: {
                try {
                    scheduler.disableSessionValidation();
                    if (log.isInfoEnabled()) {
                        log.info((Object)"Disabled session validation scheduler.");
                    }
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block4;
                    String msg = "Unable to disable SessionValidationScheduler.  Ignoring (shutting down)...";
                    log.debug((Object)msg, (Throwable)e);
                }
            }
            LifecycleUtils.destroy(scheduler);
            this.setSessionValidationScheduler(null);
        }
    }

    protected void beforeSessionValidationDisabled() {
    }

    @Override
    public void destroy() {
        this.disableSessionValidation();
    }

    @Override
    public void validateSessions() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Validating all active sessions...");
        }
        int invalidCount = 0;
        Collection<Session> activeSessions = this.getActiveSessions();
        if (activeSessions != null && !activeSessions.isEmpty()) {
            for (Session s : activeSessions) {
                try {
                    this.validate(s);
                }
                catch (InvalidSessionException e) {
                    if (log.isDebugEnabled()) {
                        boolean expired = e instanceof ExpiredSessionException;
                        String msg = "Invalidated session with id [" + s.getId() + "]" + (expired ? " (expired)" : " (stopped)");
                        log.debug((Object)msg);
                    }
                    ++invalidCount;
                }
            }
        }
        if (log.isInfoEnabled()) {
            String msg = "Finished session validation.";
            msg = invalidCount > 0 ? msg + "  [" + invalidCount + "] sessions were stopped." : msg + "  No sessions were stopped.";
            log.info((Object)msg);
        }
    }

    protected abstract Collection<Session> getActiveSessions();

    @Override
    public void validateSession(Serializable sessionId) {
        this.getSession(sessionId);
    }
}

