/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.authz.aop;

import java.util.ArrayList;
import java.util.Collection;
import org.jsecurity.aop.MethodInvocation;
import org.jsecurity.authz.AuthorizationException;
import org.jsecurity.authz.aop.AuthenticatedAnnotationMethodInterceptor;
import org.jsecurity.authz.aop.AuthorizingAnnotationMethodInterceptor;
import org.jsecurity.authz.aop.AuthorizingMethodInterceptor;
import org.jsecurity.authz.aop.GuestAnnotationMethodInterceptor;
import org.jsecurity.authz.aop.PermissionAnnotationMethodInterceptor;
import org.jsecurity.authz.aop.RoleAnnotationMethodInterceptor;
import org.jsecurity.authz.aop.UserAnnotationMethodInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AnnotationsAuthorizingMethodInterceptor
extends AuthorizingMethodInterceptor {
    protected Collection<AuthorizingAnnotationMethodInterceptor> methodInterceptors = new ArrayList<AuthorizingAnnotationMethodInterceptor>(5);

    public AnnotationsAuthorizingMethodInterceptor() {
        this.methodInterceptors.add(new RoleAnnotationMethodInterceptor());
        this.methodInterceptors.add(new PermissionAnnotationMethodInterceptor());
        this.methodInterceptors.add(new AuthenticatedAnnotationMethodInterceptor());
        this.methodInterceptors.add(new UserAnnotationMethodInterceptor());
        this.methodInterceptors.add(new GuestAnnotationMethodInterceptor());
    }

    public Collection<AuthorizingAnnotationMethodInterceptor> getMethodInterceptors() {
        return this.methodInterceptors;
    }

    public void setMethodInterceptors(Collection<AuthorizingAnnotationMethodInterceptor> methodInterceptors) {
        this.methodInterceptors = methodInterceptors;
    }

    @Override
    protected void assertAuthorized(MethodInvocation methodInvocation) throws AuthorizationException {
        Collection<AuthorizingAnnotationMethodInterceptor> aamis = this.getMethodInterceptors();
        if (aamis != null && !aamis.isEmpty()) {
            for (AuthorizingAnnotationMethodInterceptor aami : aamis) {
                if (!aami.supports(methodInvocation)) continue;
                aami.assertAuthorized(methodInvocation);
            }
        }
    }
}

