/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.user.center.dashboard.seam;

import java.io.Serializable;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.spaces.api.Space;
import org.nuxeo.ecm.spaces.api.SpaceManager;
import org.nuxeo.opensocial.helper.OpenSocialGadgetHelper;
import org.nuxeo.runtime.api.Framework;

@Name(value="userDashboardActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
public class UserDashboardActions
implements Serializable {
    public static final String USER_DASHBOARD_SPACE_PROVIDER = "userDashboardSpaceProvider";
    @In(create=true)
    protected transient CoreSession documentManager;

    public String removeUserDashboard() throws ClientException {
        SpaceManager spaceManager = this.getSpaceManager();
        Space userSpace = spaceManager.getSpace(USER_DASHBOARD_SPACE_PROVIDER, this.documentManager);
        if (userSpace != null) {
            IdRef spaceRef = new IdRef(userSpace.getId());
            this.documentManager.removeDocument((DocumentRef)spaceRef);
            this.documentManager.save();
        }
        return null;
    }

    protected SpaceManager getSpaceManager() throws ClientException {
        try {
            return (SpaceManager)Framework.getService(SpaceManager.class);
        }
        catch (Exception e) {
            throw new ClientException("Unable to retrieve SpaceManager service", (Throwable)e);
        }
    }

    @Factory(value="gadgetsBaseURL", scope=ScopeType.APPLICATION)
    public String getGadgetsBaseURL() {
        return OpenSocialGadgetHelper.getGadgetsBaseUrl((boolean)false);
    }
}

