/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.gwt;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.Environment;
import org.nuxeo.common.utils.ZipUtils;
import org.nuxeo.runtime.api.Framework;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;

public class GwtBundleActivator
implements BundleActivator,
FrameworkListener {
    private static final Log log = LogFactory.getLog(GwtBundleActivator.class);
    public static final String GWT_DEV_MODE_PROP = "nuxeo.gwt_dev_mode";
    public static final File GWT_ROOT = new File(Environment.getDefault().getWeb(), "root.war/gwt");
    public static final boolean GWT_DEV_MODE = "true".equals(System.getProperty("nuxeo.gwt_dev_mode", "false"));
    protected BundleContext context;

    public void start(BundleContext context) throws Exception {
        this.context = context;
        context.addFrameworkListener((FrameworkListener)this);
    }

    public void stop(BundleContext context) throws Exception {
        context.removeFrameworkListener((FrameworkListener)this);
    }

    public static void installGwtApp(Bundle bundle) throws Exception {
        if (GWT_DEV_MODE) {
            return;
        }
        GWT_ROOT.mkdirs();
        String symName = bundle.getSymbolicName();
        File markerFile = new File(GWT_ROOT, ".metadata/" + symName);
        File file = Framework.getRuntime().getBundleFile(bundle);
        if (file == null) {
            log.warn((Object)"A GWT module without a war directory inside");
            return;
        }
        if (markerFile.lastModified() < file.lastModified()) {
            log.info((Object)("Installing GWT Application from bundle " + symName));
            ZipUtils.unzip((String)"gwt-war", (File)file, (File)GWT_ROOT);
            markerFile.getParentFile().mkdirs();
            markerFile.createNewFile();
        }
    }

    public void frameworkEvent(FrameworkEvent event) {
        if (1 == event.getType()) {
            try {
                GwtBundleActivator.installGwtApp(this.context.getBundle());
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to install GWT application: " + this.context.getBundle().getSymbolicName(), e);
            }
        }
    }
}

