/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin.stages;

import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.JsLexer;
import com.google.caja.lexer.JsTokenQueue;
import com.google.caja.lexer.ParseException;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.Identifier;
import com.google.caja.parser.js.Operation;
import com.google.caja.parser.js.Parser;
import com.google.caja.parser.js.Reference;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.util.Pair;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Splitter {
    int startString = 0;
    int startOffset = 1;
    List<StringLiteral> literals = new ArrayList<StringLiteral>();
    List<Expression> parts = new ArrayList<Expression>();
    State state = State.LITERAL;
    int i;
    int j;
    MessageQueue mq;

    Splitter(List<StringLiteral> literals, MessageQueue mq) {
        this.literals = literals;
        this.mq = mq;
    }

    void split() {
        int n = this.literals.size();
        this.j = 0;
        while (this.j < n) {
            StringLiteral str = this.literals.get(this.j);
            String rawString = str.getValue();
            int m = rawString.length();
            this.i = 1;
            while (this.i < m) {
                char ch = rawString.charAt(this.i);
                block0 : switch (ch) {
                    case '$': {
                        switch (this.state) {
                            case LITERAL: 
                            case SAW_DOLLAR: {
                                this.state = State.SAW_DOLLAR;
                                break block0;
                            }
                            case IN_REFERENCE: {
                                this.finishReference(0);
                                this.mark(0);
                                this.state = State.SAW_DOLLAR;
                                break block0;
                            }
                        }
                        break;
                    }
                    case '{': {
                        switch (this.state) {
                            case SAW_DOLLAR: {
                                this.finishLiteral(-1);
                                this.mark(1);
                                this.state = State.IN_BLOCK;
                                break block0;
                            }
                            case IN_REFERENCE: {
                                this.finishReference(0);
                                this.mark(0);
                                this.state = State.LITERAL;
                                break block0;
                            }
                        }
                        break;
                    }
                    case '}': {
                        switch (this.state) {
                            case IN_REFERENCE: {
                                this.finishReference(0);
                                this.mark(0);
                                this.state = State.LITERAL;
                                break block0;
                            }
                            case SAW_DOLLAR: {
                                this.state = State.LITERAL;
                                break block0;
                            }
                            case IN_BLOCK: {
                                this.finishBlock(0);
                                this.mark(1);
                                this.state = State.LITERAL;
                                break block0;
                            }
                        }
                        break;
                    }
                    default: {
                        if (Character.isLetter(ch) || ch == '_') {
                            switch (this.state) {
                                case SAW_DOLLAR: {
                                    this.finishLiteral(-1);
                                    this.mark(0);
                                    this.state = State.IN_REFERENCE;
                                    break block0;
                                }
                            }
                            break;
                        }
                        switch (this.state) {
                            case IN_REFERENCE: {
                                if (Character.isDigit(ch)) break block0;
                                this.finishReference(0);
                                this.mark(0);
                                this.state = State.LITERAL;
                                break block0;
                            }
                            case SAW_DOLLAR: {
                                this.state = State.LITERAL;
                                break block0;
                            }
                        }
                    }
                }
                ++this.i;
            }
            ++this.j;
        }
        switch (this.state) {
            case LITERAL: 
            case SAW_DOLLAR: {
                this.finishLiteral(0);
                break;
            }
            case IN_REFERENCE: {
                this.finishReference(0);
                break;
            }
            case IN_BLOCK: {
                throw new RuntimeException("End of template inside brackets");
            }
        }
    }

    private void mark(int delta) {
        this.startString = this.j;
        this.startOffset = this.i + delta;
    }

    private void finishLiteral(int delta) {
        FilePosition start = null;
        FilePosition end = null;
        StringBuilder sb = new StringBuilder();
        for (Pair<String, FilePosition> p : this.upTo(delta)) {
            if (start == null) {
                start = (FilePosition)p.b;
            }
            end = (FilePosition)p.b;
            sb.append((String)p.a);
        }
        this.parts.add(StringLiteral.valueOf(FilePosition.span(start, end), sb));
    }

    private void finishReference(int delta) {
        FilePosition start = null;
        FilePosition end = null;
        StringBuilder sb = new StringBuilder();
        for (Pair<String, FilePosition> p : this.upTo(delta)) {
            if (start == null) {
                start = (FilePosition)p.b;
            }
            end = (FilePosition)p.b;
            sb.append((String)p.a);
        }
        FilePosition pos = FilePosition.span(start, end);
        Identifier ident = new Identifier(pos, sb.toString());
        Reference ref = new Reference(ident);
        this.parts.add(ref);
    }

    private void finishBlock(int delta) {
        Expression result;
        FilePosition start = null;
        FilePosition end = null;
        ArrayList<CharProducer> producers = new ArrayList<CharProducer>();
        for (Pair<String, FilePosition> p : this.upTo(delta)) {
            if (start == null) {
                start = (FilePosition)p.b;
            }
            end = (FilePosition)p.b;
            producers.add(CharProducer.Factory.create(new StringReader((String)p.a), (FilePosition)p.b));
        }
        CharProducer joined = producers.size() == 1 ? (CharProducer)producers.get(0) : CharProducer.Factory.chain(producers.toArray(new CharProducer[0]));
        CharProducer exprText = CharProducer.Factory.fromJsString(joined);
        JsLexer lexer = new JsLexer(exprText);
        JsTokenQueue tq = new JsTokenQueue(lexer, start.source(), JsTokenQueue.NO_COMMENT);
        Parser p = new Parser(tq, this.mq);
        try {
            result = p.parseExpression(true);
            tq.expectEmpty();
        }
        catch (ParseException ex) {
            ex.toMessageQueue(this.mq);
            result = Operation.undefined(FilePosition.span(start, end));
        }
        this.parts.add(result);
    }

    private List<Pair<String, FilePosition>> upTo(int delta) {
        String literalText;
        StringLiteral lit;
        int endOffset;
        int currentString = this.startString;
        int currentOffset = this.startOffset;
        while (this.literals.size() > this.startString && this.startOffset >= this.literals.get(this.startString).getValue().length() - 1) {
            this.startOffset = 1 + this.startOffset - (this.literals.get(this.startString).getValue().length() - 1);
            ++this.startString;
        }
        int endString = this.j;
        for (endOffset = this.i + delta; endOffset < 1 && endString > 0; endOffset += this.literals.get(--endString).getValue().length() - 1) {
        }
        ArrayList<Pair<String, FilePosition>> parts = new ArrayList<Pair<String, FilePosition>>();
        while (currentString < endString) {
            lit = this.literals.get(currentString);
            literalText = lit.getValue();
            int end = literalText.length() - 1;
            parts.add(Pair.pair(literalText.substring(currentOffset, end), Splitter.clippedPos(lit.getFilePosition(), currentOffset, end)));
            currentOffset = 1;
            ++currentString;
        }
        if (currentString == endString && currentOffset <= endOffset && currentString < this.literals.size()) {
            lit = this.literals.get(currentString);
            literalText = lit.getValue();
            parts.add(Pair.pair(literalText.substring(currentOffset, endOffset), Splitter.clippedPos(lit.getFilePosition(), currentOffset, endOffset)));
        }
        if (parts.isEmpty()) {
            StringLiteral lastLit = this.literals.get(this.literals.size() - 1);
            parts.add(Pair.pair("", FilePosition.endOf(lastLit.getFilePosition())));
        }
        return parts;
    }

    static FilePosition clippedPos(FilePosition p, int start, int end) {
        if (end <= 0) {
            return FilePosition.startOf(p);
        }
        if (p.endCharInFile() - p.startCharInFile() <= start) {
            return FilePosition.endOf(p);
        }
        if (end < start) {
            end = start;
        }
        return FilePosition.instance(p.source(), p.startLineNo(), p.startCharInFile() + start, p.startCharInLine() + start, end - start);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        LITERAL,
        SAW_DOLLAR,
        IN_REFERENCE,
        IN_BLOCK;

    }
}

