/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.dam.operations;

import org.nuxeo.dam.AssetLibrary;
import org.nuxeo.dam.DamService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.platform.filemanager.api.FileManager;

@Operation(id="Dam.Import", category="Dam", label="Create Asset(s) from file(s)", description="Create Asset(s) from Blob(s) using the FileManagerService.")
public class DamImport {
    public static final String ID = "Dam.Import";
    @Context
    protected OperationContext ctx;
    @Context
    protected CoreSession session;
    @Context
    protected FileManager fileManager;
    @Context
    protected DamService damService;
    @Param(name="overwrite", required=false)
    protected Boolean overwrite = false;

    @OperationMethod
    public DocumentModel run(Blob blob) throws Exception {
        AssetLibrary assetLibrary = this.damService.getAssetLibrary();
        this.ctx.put("AddMessage.messageParams", (Object)new Object[]{1});
        return this.fileManager.createDocumentFromBlob(this.session, blob, assetLibrary.getPath(), this.overwrite.booleanValue(), blob.getFilename());
    }

    @OperationMethod
    public DocumentModelList run(BlobList blobs) throws Exception {
        DocumentModelListImpl result = new DocumentModelListImpl();
        for (Blob blob : blobs) {
            result.add((Object)this.run(blob));
        }
        this.ctx.put("AddMessage.messageParams", (Object)new Object[]{result.size()});
        return result;
    }
}

