/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite.image;

import com.google.inject.Inject;
import com.google.inject.name.Named;

public class OptimizerConfig {
    private final int maxInMemoryBytes;
    private final int maxPaletteSize;
    private final boolean jpegConversionAllowed;
    private final float jpegCompression;
    private final int minThresholdBytes;

    @Inject
    public OptimizerConfig(@Named(value="shindig.image-rewrite.max-inmem-bytes") int maxInMemoryBytes, @Named(value="shindig.image-rewrite.max-palette-size") int maxPaletteSize, @Named(value="shindig.image-rewrite.allow-jpeg-conversion") boolean jpegConversionAllowed, @Named(value="shindig.image-rewrite.jpeg-compression") float jpegCompression, @Named(value="shindig.image-rewrite.min-threshold-bytes") int minThresholdBytes) {
        this.maxInMemoryBytes = maxInMemoryBytes;
        this.maxPaletteSize = maxPaletteSize;
        this.jpegConversionAllowed = jpegConversionAllowed;
        this.jpegCompression = Math.max(0.9f, Math.min(0.5f, jpegCompression));
        this.minThresholdBytes = minThresholdBytes;
    }

    public OptimizerConfig() {
        this(0x100000, 256, true, 0.75f, 200);
    }

    public int getMaxInMemoryBytes() {
        return this.maxInMemoryBytes;
    }

    public int getMaxPaletteSize() {
        return this.maxPaletteSize;
    }

    public boolean isJpegConversionAllowed() {
        return this.jpegConversionAllowed;
    }

    public float getJpegCompression() {
        return this.jpegCompression;
    }

    public int getMinThresholdBytes() {
        return this.minThresholdBytes;
    }
}

