/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite.image;

import com.google.common.collect.Maps;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.util.HashMap;
import java.util.Iterator;

public class ImageUtils {
    public static BufferedImage palettize(BufferedImage img, int maxEntries) {
        IndexColorModel originalModel;
        int addedCount = 0;
        HashMap added = Maps.newHashMap();
        for (int y = 0; y < img.getHeight(); ++y) {
            for (int x = 0; x < img.getWidth(); ++x) {
                if (!added.containsKey(img.getRGB(x, y))) {
                    added.put(img.getRGB(x, y), addedCount++);
                }
                if (added.size() <= maxEntries) continue;
                return null;
            }
        }
        int[] cmap = new int[added.size()];
        Iterator i$ = added.keySet().iterator();
        while (i$.hasNext()) {
            int c;
            cmap[((Integer)added.get((Object)Integer.valueOf((int)c))).intValue()] = c = ((Integer)i$.next()).intValue();
        }
        int bitCount = 1;
        while (added.size() >> bitCount != 0) {
            bitCount *= 2;
        }
        IndexColorModel icm = new IndexColorModel(bitCount, added.size(), cmap, 0, 0, null);
        if (img.getColorModel() instanceof IndexColorModel && (originalModel = (IndexColorModel)img.getColorModel()).getPixelSize() == icm.getPixelSize() && originalModel.getMapSize() == icm.getMapSize()) {
            return null;
        }
        BufferedImage dst = new BufferedImage(img.getWidth(), img.getHeight(), icm.getPixelSize() < 8 ? 12 : 13, icm);
        WritableRaster wr = dst.getRaster();
        for (int y = 0; y < dst.getHeight(); ++y) {
            for (int x = 0; x < dst.getWidth(); ++x) {
                wr.setSample(x, y, 0, (Integer)added.get(img.getRGB(x, y)));
            }
        }
        return dst;
    }

    public static BufferedImage depalettize(BufferedImage img, int maxBytes) {
        if (img.getWidth() * img.getHeight() * 4 > maxBytes) {
            return null;
        }
        ColorModel colorModel = img.getColorModel();
        if (colorModel instanceof IndexColorModel) {
            IndexColorModel indexModel = (IndexColorModel)colorModel;
            return indexModel.convertToIntDiscrete(img.getData(), false);
        }
        return null;
    }

    public static boolean isOpaque(BufferedImage img) {
        for (int x = 0; x < img.getWidth(); ++x) {
            for (int y = 0; y < img.getHeight(); ++y) {
                if ((img.getRGB(x, y) & 0xFF000000) == -16777216) continue;
                return false;
            }
        }
        return true;
    }

    public static BufferedImage getScaledInstance(BufferedImage img, int targetWidth, int targetHeight, Object hint, boolean higherQuality, int imageType) {
        int h;
        int w;
        BufferedImage ret = img;
        if (higherQuality) {
            w = img.getWidth();
            h = img.getHeight();
        } else {
            w = targetWidth;
            h = targetHeight;
        }
        do {
            if (higherQuality && w > targetWidth && (w /= 2) < targetWidth) {
                w = targetWidth;
            }
            if (higherQuality && h > targetHeight && (h /= 2) < targetHeight) {
                h = targetHeight;
            }
            BufferedImage tmp = new BufferedImage(w, h, imageType);
            Graphics2D g2 = tmp.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, hint);
            g2.drawImage(ret, 0, 0, w, h, null);
            g2.dispose();
            ret = tmp;
        } while (w > targetWidth || h > targetHeight);
        return ret;
    }
}

