/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.preview.adapter.base;

import java.io.IOException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.List;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.impl.blob.ByteArrayBlob;
import org.nuxeo.ecm.platform.preview.adapter.base.PreprocessedHtmlPreviewAdapter;
import org.nuxeo.ecm.platform.preview.api.PreviewException;

public class NoteHtmlPreviewAdapter
extends PreprocessedHtmlPreviewAdapter {
    public NoteHtmlPreviewAdapter(List<String> fieldsPaths) {
        super(fieldsPaths);
    }

    @Override
    public List<Blob> getPreviewBlobs() throws PreviewException {
        List<Blob> blobs = super.getPreviewBlobs();
        if (!blobs.isEmpty()) {
            Blob blob = blobs.remove(0);
            Blob newBlob = this.processNoteBlob(blob);
            blobs.add(0, newBlob);
        }
        return blobs;
    }

    protected Blob processNoteBlob(Blob blob) throws PreviewException {
        try {
            String note = blob.getString();
            StringBuilder sb = new StringBuilder();
            sb.append("<html><body>");
            sb.append(note);
            sb.append("</body></html>");
            byte[] bytes = blob.getEncoding() == null ? sb.toString().getBytes() : sb.toString().getBytes(blob.getEncoding());
            String mimeType = blob.getMimeType();
            if (mimeType == null) {
                mimeType = "text/html";
            }
            ByteArrayBlob newBlob = new ByteArrayBlob(bytes, mimeType, blob.getEncoding());
            return newBlob;
        }
        catch (IOException e) {
            throw new PreviewException(e);
        }
        catch (UnsupportedCharsetException e) {
            throw new PreviewException(e);
        }
    }

    @Override
    public List<Blob> getPreviewBlobs(String xpath) throws PreviewException {
        return this.getPreviewBlobs();
    }
}

