/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.annotations.api;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.nuxeo.ecm.platform.annotations.api.Annotation;
import org.nuxeo.ecm.platform.annotations.api.AnnotationException;
import org.nuxeo.ecm.platform.annotations.api.AnnotationImpl;
import org.nuxeo.ecm.platform.annotations.api.UriResolver;
import org.nuxeo.ecm.platform.relations.api.Graph;
import org.nuxeo.ecm.platform.relations.api.Node;
import org.nuxeo.ecm.platform.relations.api.RelationManager;
import org.nuxeo.ecm.platform.relations.api.Resource;
import org.nuxeo.ecm.platform.relations.api.Statement;
import org.nuxeo.ecm.platform.relations.api.Subject;
import org.nuxeo.ecm.platform.relations.api.impl.ResourceImpl;
import org.nuxeo.runtime.api.Framework;

public class AnnotationManager {
    private static final String TRANSIENT_GRAPH_TYPE = "jena";

    public void writeAnnotation(OutputStream os, Annotation annotation) throws AnnotationException {
        Graph graph = AnnotationManager.getTransientGraph();
        graph.add(annotation.getStatements());
        try {
            os.write("<?xml version='1.0'?>".getBytes());
        }
        catch (IOException e) {
            throw new AnnotationException(e);
        }
        graph.write(os, null, null);
    }

    public Annotation translateAnnotationFromRepo(UriResolver resolver, String baseUrl, Annotation annotation) throws AnnotationException {
        ArrayList<Statement> results = new ArrayList<Statement>();
        for (Statement statement : annotation.getStatements()) {
            Resource resource;
            Subject node = statement.getSubject();
            if (node instanceof Resource) {
                resource = AnnotationManager.getTranslatedResource(resolver, baseUrl, (Node)node);
                statement.setSubject((Node)resource);
            }
            if ((node = statement.getObject()) instanceof Resource) {
                resource = AnnotationManager.getTranslatedResource(resolver, baseUrl, (Node)node);
                statement.setObject((Node)resource);
            }
            results.add(statement);
        }
        return this.getAnnotation(results);
    }

    private static Resource getTranslatedResource(UriResolver resolver, String baseUrl, Node node) throws AnnotationException {
        String uri = ((Resource)node).getUri();
        ResourceImpl resource = null;
        try {
            URI newUri = resolver.translateFromGraphURI(new URI(uri), baseUrl);
            resource = new ResourceImpl(newUri.toString());
        }
        catch (URISyntaxException e) {
            throw new AnnotationException(e);
        }
        return resource;
    }

    public Annotation translateAnnotationToRepo(UriResolver resolver, Annotation annotation) throws AnnotationException {
        ArrayList<Statement> results = new ArrayList<Statement>();
        for (Statement statement : annotation.getStatements()) {
            ResourceImpl resource;
            URI u;
            String uri;
            Subject node = statement.getSubject();
            if (node instanceof Resource) {
                uri = ((Resource)node).getUri();
                try {
                    u = resolver.translateToGraphURI(new URI(uri));
                }
                catch (URISyntaxException e) {
                    throw new AnnotationException(e);
                }
                resource = new ResourceImpl(u.toString());
                statement.setSubject((Node)resource);
            }
            if ((node = statement.getObject()) instanceof Resource) {
                uri = ((Resource)node).getUri();
                try {
                    u = resolver.translateToGraphURI(new URI(uri));
                }
                catch (URISyntaxException e) {
                    throw new AnnotationException(e);
                }
                resource = new ResourceImpl(u.toString());
                statement.setObject((Node)resource);
            }
            results.add(statement);
        }
        return this.getAnnotation(results);
    }

    public Annotation getAnnotation(List<Statement> statements) throws AnnotationException {
        AnnotationImpl annotation = new AnnotationImpl();
        Graph graph = AnnotationManager.getTransientGraph();
        graph.add(statements);
        annotation.setGraph(graph);
        return annotation;
    }

    public Annotation getAnnotation(InputStream is) throws AnnotationException {
        Graph graph = AnnotationManager.getTransientGraph();
        graph.read(is, null, null);
        AnnotationImpl annotation = new AnnotationImpl();
        annotation.setGraph(graph);
        return annotation;
    }

    public Annotation getAnnotation(String is) throws AnnotationException {
        Graph graph = AnnotationManager.getTransientGraph();
        graph.read(is, null, null);
        AnnotationImpl annotation = new AnnotationImpl();
        annotation.setGraph(graph);
        return annotation;
    }

    private static Graph getTransientGraph() throws AnnotationException {
        Graph graph;
        try {
            RelationManager service = (RelationManager)Framework.getService(RelationManager.class);
            graph = service.getTransientGraph(TRANSIENT_GRAPH_TYPE);
        }
        catch (Exception e) {
            throw new AnnotationException(e);
        }
        return graph;
    }
}

