/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.betwixt.schema;

import java.beans.IntrospectionException;
import org.apache.commons.betwixt.ElementDescriptor;
import org.apache.commons.betwixt.schema.LocalElement;
import org.apache.commons.betwixt.schema.Schema;
import org.apache.commons.betwixt.schema.TranscriptionConfiguration;

public class SimpleLocalElement
extends LocalElement {
    private String type;

    public SimpleLocalElement(String name, String type) {
        super(name);
        this.setType(type);
    }

    public SimpleLocalElement(TranscriptionConfiguration configuration, ElementDescriptor descriptor, Schema schema) throws IntrospectionException {
        super(descriptor, schema);
        this.setType(configuration.getDataTypeMapper().toXMLSchemaDataType(descriptor.getPropertyType()));
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof SimpleLocalElement) {
            SimpleLocalElement simpleLocalElement = (SimpleLocalElement)obj;
            result = this.isEqual(this.getName(), simpleLocalElement.getName()) && this.isEqual(this.getType(), simpleLocalElement.getType());
        }
        return result;
    }

    private boolean isEqual(String one, String two) {
        if (one == null) {
            return two == null;
        }
        return one.equals(two);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<element name='");
        buffer.append(this.getName());
        buffer.append("' type='");
        buffer.append(this.getType());
        buffer.append("'/>");
        return buffer.toString();
    }
}

