/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.rating;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.nuxeo.ecm.activity.ActivitiesList;
import org.nuxeo.ecm.activity.ActivitiesListImpl;
import org.nuxeo.ecm.activity.Activity;
import org.nuxeo.ecm.activity.ActivityHelper;
import org.nuxeo.ecm.activity.ActivityReply;
import org.nuxeo.ecm.activity.ActivityStreamFilter;
import org.nuxeo.ecm.activity.ActivityStreamService;
import org.nuxeo.ecm.activity.ActivityStreamServiceImpl;

public class RatingActivityStreamFilter
implements ActivityStreamFilter {
    public static final String ID = "RatingActivityStreamFilter";
    public static final String QUERY_TYPE_PARAMETER = "queryTypeParameter";
    public static final String TARGET_OBJECT_PARAMETER = "targetObject";
    public static final String ASPECT_PARAMETER = "aspect";
    public static final String ACTOR_PARAMETER = "actor";
    public static final String RATING_PARAMETER = "rating";
    public static final String CONTEXT_PARAMETER = "context";

    public String getId() {
        return ID;
    }

    public boolean isInterestedIn(Activity activity) {
        String verb = activity.getVerb();
        return verb != null && verb.startsWith("rating:");
    }

    public void handleNewActivity(ActivityStreamService activityStreamService, Activity activity) {
    }

    @Deprecated
    public void handleRemovedActivities(ActivityStreamService activityStreamService, Collection<Serializable> activityIds) {
    }

    public void handleRemovedActivities(ActivityStreamService activityStreamService, ActivitiesList activities) {
        ArrayList<String> activityObjects = new ArrayList<String>();
        for (Activity activity : activities) {
            activityObjects.add(ActivityHelper.createActivityObject((Activity)activity));
            for (ActivityReply reply : activity.getActivityReplies()) {
                activityObjects.add(ActivityHelper.createActivityObject((Serializable)((Object)reply.getId())));
            }
        }
        this.removeAllRatingActivitiesFor(activityStreamService, activityObjects);
    }

    public void handleRemovedActivityReply(ActivityStreamService activityStreamService, Activity activity, ActivityReply activityReply) {
        this.removeAllRatingActivitiesFor(activityStreamService, Collections.singleton(ActivityHelper.createActivityObject((Serializable)((Object)activityReply.getId()))));
    }

    protected void removeAllRatingActivitiesFor(ActivityStreamService activityStreamService, Collection<String> activityObjects) {
        EntityManager em = ((ActivityStreamServiceImpl)activityStreamService).getEntityManager();
        Query query = em.createQuery("delete from Activity activity where activity.verb LIKE :verb and activity.target in (:target)");
        query.setParameter("verb", (Object)"rating:%");
        query.setParameter("target", activityObjects);
        query.executeUpdate();
    }

    public ActivitiesList query(ActivityStreamService activityStreamService, Map<String, Serializable> parameters, long offset, long limit) {
        EntityManager em = ((ActivityStreamServiceImpl)activityStreamService).getEntityManager();
        QueryType queryType = (QueryType)((Object)parameters.get(QUERY_TYPE_PARAMETER));
        if (queryType == null) {
            return new ActivitiesListImpl();
        }
        Query query = null;
        String targetObject = (String)((Object)parameters.get(TARGET_OBJECT_PARAMETER));
        String aspect = (String)((Object)parameters.get(ASPECT_PARAMETER));
        String actor = (String)((Object)parameters.get(ACTOR_PARAMETER));
        Integer rating = (Integer)parameters.get(RATING_PARAMETER);
        String context = (String)((Object)parameters.get(CONTEXT_PARAMETER));
        switch (queryType) {
            case GET_ACTOR_RATINGS_FOR_OBJECT: {
                StringBuilder sb = new StringBuilder("select activity from Activity activity where activity.verb = :verb and activity.actor = :actor and activity.target = :targetObject and activity.context is null");
                if (rating != null) {
                    sb.append(" and activity.object = :rating");
                }
                query = em.createQuery(sb.toString());
                query.setParameter("verb", (Object)("rating:" + aspect));
                query.setParameter(TARGET_OBJECT_PARAMETER, (Object)targetObject);
                query.setParameter(ACTOR_PARAMETER, (Object)actor);
                if (rating == null) break;
                query.setParameter(RATING_PARAMETER, (Object)String.valueOf(rating));
                break;
            }
            case GET_RATINGS_FOR_OBJECT: {
                StringBuilder sb = new StringBuilder("select activity from Activity activity where activity.verb = :verb and activity.target = :targetObject and activity.context is null");
                if (rating != null) {
                    sb.append(" and activity.object = :rating");
                }
                query = em.createQuery(sb.toString());
                query.setParameter("verb", (Object)("rating:" + aspect));
                query.setParameter(TARGET_OBJECT_PARAMETER, (Object)targetObject);
                if (rating == null) break;
                query.setParameter(RATING_PARAMETER, (Object)String.valueOf(rating));
                break;
            }
            case GET_RATED_CHILDREN_FOR_CONTEXT: {
                StringBuilder sb = new StringBuilder("select activity from Activity activity where activity.verb = :verb and activity.context  = :context");
                if (rating != null) {
                    sb.append(" and activity.object = :rating");
                }
                query = em.createQuery(sb.toString());
                query.setParameter("verb", (Object)("rating:" + aspect));
                query.setParameter(CONTEXT_PARAMETER, (Object)context);
                if (rating == null) break;
                query.setParameter(RATING_PARAMETER, (Object)String.valueOf(rating));
                break;
            }
            case GET_RATINGS_FOR_CANCEL: {
                StringBuilder sb = new StringBuilder("select activity from Activity activity where activity.target = :targetObject");
                if (rating != null) {
                    sb.append(" and activity.object = :rating");
                }
                if (actor != null) {
                    sb.append(" and activity.actor = :actor");
                }
                if (aspect != null) {
                    sb.append(" and activity.verb = :verb");
                } else {
                    sb.append(" and activity.verb LIKE :verb");
                    aspect = "%";
                }
                query = em.createQuery(sb.toString());
                query.setParameter("verb", (Object)("rating:" + aspect));
                query.setParameter(TARGET_OBJECT_PARAMETER, (Object)targetObject);
                if (rating != null) {
                    query.setParameter(RATING_PARAMETER, (Object)String.valueOf(rating));
                }
                if (actor == null) break;
                query.setParameter(ACTOR_PARAMETER, (Object)actor);
                break;
            }
            case GET_LATEST_RATED_FOR_OBJECT: {
                query = em.createQuery("select activity from Activity activity where activity.target LIKE :targetObject and activity.context is null and activity.actor = :actor and activity.verb = :verb order by activity.publishedDate DESC");
                query.setParameter("verb", (Object)("rating:" + aspect));
                query.setParameter(ACTOR_PARAMETER, (Object)actor);
                query.setParameter(TARGET_OBJECT_PARAMETER, (Object)"doc:%");
            }
        }
        if (limit > 0L) {
            query.setMaxResults((int)limit);
            if (offset > 0L) {
                query.setFirstResult((int)offset);
            }
        }
        return new ActivitiesListImpl((Collection)query.getResultList());
    }

    public static enum QueryType {
        GET_ACTOR_RATINGS_FOR_OBJECT,
        GET_RATINGS_FOR_OBJECT,
        GET_RATED_CHILDREN_FOR_CONTEXT,
        GET_RATINGS_FOR_CANCEL,
        GET_LATEST_RATED_FOR_OBJECT;

    }
}

