/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.rating;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.activity.ActivitiesList;
import org.nuxeo.ecm.activity.ActivitiesListImpl;
import org.nuxeo.ecm.activity.Activity;
import org.nuxeo.ecm.activity.ActivityBuilder;
import org.nuxeo.ecm.activity.ActivityReply;
import org.nuxeo.ecm.activity.ActivityStreamFilter;
import org.nuxeo.ecm.activity.ActivityStreamService;
import org.nuxeo.ecm.activity.ActivityStreamServiceImpl;

public class LikesCountActivityStreamFilter
implements ActivityStreamFilter {
    public static final String ID = "LikesCountActivityStreamFilter";
    public static final String CONTEXT_PARAMETER = "context";
    public static final String ASPECT_PARAMETER = "aspect";
    public static final String OBJECT_PARAMETER = "object";
    public static final String ACTOR_PARAMETER = "actor";
    public static final String FROMDT_PARAMETER = "fromDt";
    public static final String TODT_PARAMETER = "toDt";
    protected static final String VERB_PARAMETER = "verb";
    protected static final String VERB_MINIMESSAGE_PARAMETER = "verbMiniMessage";
    private static final Log log = LogFactory.getLog(LikesCountActivityStreamFilter.class);

    public String getId() {
        return ID;
    }

    public boolean isInterestedIn(Activity activity) {
        return false;
    }

    public void handleNewActivity(ActivityStreamService activityStreamService, Activity activity) {
    }

    @Deprecated
    public void handleRemovedActivities(ActivityStreamService activityStreamService, Collection<Serializable> activityIds) {
    }

    public void handleRemovedActivities(ActivityStreamService activityStreamService, ActivitiesList activities) {
    }

    public void handleRemovedActivityReply(ActivityStreamService activityStreamService, Activity activity, ActivityReply activityReply) {
    }

    public ActivitiesList query(ActivityStreamService activityStreamService, Map<String, Serializable> parameters, long offset, long limit) {
        QueryType queryType = (QueryType)((Object)parameters.get("queryTypeParameter"));
        if (queryType == null) {
            return new ActivitiesListImpl();
        }
        Query query = null;
        String queryStr = "";
        String innerStr = "";
        EntityManager em = ((ActivityStreamServiceImpl)activityStreamService).getEntityManager();
        Serializable actor = parameters.get(ACTOR_PARAMETER);
        switch (queryType) {
            case GET_DOCUMENTS_COUNT: {
                innerStr = "SELECT COUNT(activity2) FROM Activity activity2 WHERE activity2.verb = :verb";
                innerStr = innerStr + " AND activity2.context = :context AND activity2.object = :object";
                innerStr = innerStr + " AND activity2.actor = :actor AND activity2.target = activity.target";
                if (parameters.containsKey(FROMDT_PARAMETER)) {
                    innerStr = innerStr + " AND activity2.publishedDate BETWEEN :fromDt AND :toDt";
                }
                queryStr = "SELECT activity.target, count(activity), (" + innerStr + ") FROM Activity activity";
                queryStr = queryStr + " WHERE activity.verb = :verb and activity.context  = :context";
                queryStr = queryStr + " AND activity.object = :object";
                if (parameters.containsKey(FROMDT_PARAMETER)) {
                    queryStr = queryStr + " AND activity.publishedDate BETWEEN :fromDt AND :toDt";
                }
                queryStr = queryStr + " GROUP BY activity.target ORDER BY COUNT(activity) DESC";
                String object = String.valueOf(parameters.get(OBJECT_PARAMETER));
                query = em.createQuery(queryStr);
                query.setParameter(OBJECT_PARAMETER, (Object)object);
                break;
            }
            case GET_MINI_MESSAGE_COUNT: {
                innerStr = "Select count(likes2) from Activity as likes2 ";
                innerStr = innerStr + " where likes.target = likes2.target and likes2.actor = :actor";
                if (parameters.containsKey(FROMDT_PARAMETER)) {
                    innerStr = innerStr + " AND likes2.publishedDate BETWEEN :fromDt AND :toDt";
                }
                queryStr = "Select likes.target, count(likes), (" + innerStr + ") from Activity as likes, Activity as minimessage";
                queryStr = queryStr + " where concat('activity:', cast(minimessage.id as string)) = likes.target";
                queryStr = queryStr + " and minimessage.verb = :verbMiniMessage and minimessage.context  = :context";
                queryStr = queryStr + " and likes.verb = :verb";
                if (parameters.containsKey(FROMDT_PARAMETER)) {
                    queryStr = queryStr + " AND likes.publishedDate BETWEEN :fromDt AND :toDt";
                }
                queryStr = queryStr + " group by likes.target order by count(likes) desc";
                query = em.createQuery(queryStr);
                query.setParameter(VERB_MINIMESSAGE_PARAMETER, (Object)"minimessage");
                break;
            }
            default: {
                log.info((Object)("Unknown query type: " + (Object)((Object)queryType)));
                return new ActivitiesListImpl();
            }
        }
        query.setParameter(CONTEXT_PARAMETER, (Object)parameters.get(CONTEXT_PARAMETER));
        query.setParameter(VERB_PARAMETER, (Object)"rating:like");
        query.setParameter(ACTOR_PARAMETER, (Object)actor);
        if (parameters.containsKey(FROMDT_PARAMETER)) {
            query.setParameter(FROMDT_PARAMETER, (Object)parameters.get(FROMDT_PARAMETER));
            query.setParameter(TODT_PARAMETER, (Object)parameters.get(TODT_PARAMETER));
        }
        if (limit > 0L && offset != 0L) {
            query.setFirstResult((int)offset);
        }
        ActivitiesListImpl likesCount = new ActivitiesListImpl();
        for (Object result : query.getResultList()) {
            Object[] objects = (Object[])result;
            ActivityBuilder ab = new ActivityBuilder().verb("rating:like").actor((String)((Object)actor)).object(String.valueOf(objects[1])).target((String)objects[0]).context(String.valueOf(objects[2]));
            likesCount.add((Object)ab.build());
        }
        return likesCount;
    }

    public static enum QueryType {
        GET_DOCUMENTS_COUNT,
        GET_MINI_MESSAGE_COUNT;

    }
}

