/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.dam.webapp.contentbrowser;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Context;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.Events;
import org.nuxeo.dam.webapp.chainselect.ChainSelectCleaner;
import org.nuxeo.dam.webapp.helper.DownloadHelper;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.PagedDocumentsProvider;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.impl.DocumentLocationImpl;
import org.nuxeo.ecm.platform.actions.Action;
import org.nuxeo.ecm.platform.audit.api.AuditException;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.ecm.platform.audit.web.listener.ejb.ContentHistoryActionsBean;
import org.nuxeo.ecm.platform.picture.api.adapters.PictureResourceAdapter;
import org.nuxeo.ecm.platform.ui.web.api.WebActions;
import org.nuxeo.ecm.platform.ui.web.tag.fn.DocumentModelFunctions;
import org.nuxeo.ecm.platform.ui.web.tag.fn.Functions;
import org.nuxeo.ecm.platform.url.DocumentViewImpl;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.ecm.platform.url.codec.DocumentFileCodec;
import org.nuxeo.ecm.platform.util.RepositoryLocation;
import org.nuxeo.ecm.webapp.delegate.DocumentManagerBusinessDelegate;

@Name(value="damDocumentActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
public class DamDocumentActions
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(DamDocumentActions.class);
    protected static final String DEFAULT_PICTURE_DOWNLOAD_PROPERTY = "Original";
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In
    protected transient Context conversationContext;
    @In(create=true)
    protected transient WebActions webActions;
    @In(create=true)
    private transient NuxeoPrincipal currentNuxeoPrincipal;
    @In(create=true)
    ContentHistoryActionsBean contentHistoryActions;
    protected DocumentModel currentSelection;
    protected String currentSelectionLink;
    protected boolean showExifArea;
    protected boolean showIptcArea;
    protected String displayMode = "view";
    protected String downloadSize = "Original";
    protected List<LogEntry> selectedAssetLogEntries;

    public DocumentModel getCurrentSelection() {
        return this.currentSelection;
    }

    public void setCurrentSelection(DocumentModel selection) {
        this.webActions.resetCurrentTabs("DAM_VIEW_ASSET_ACTION_LIST");
        this.displayMode = "view";
        this.currentSelection = selection;
        this.selectedAssetLogEntries = null;
        this.currentSelectionLink = this.webActions.getCurrentTabAction("DAM_VIEW_ASSET_ACTION_LIST").getLink();
        this.resetData();
        DamDocumentActions.raiseEvents(this.currentSelection);
    }

    public String getCurrentSelectionLink() {
        if (this.currentSelectionLink == null) {
            return "/incl/tabs/empty_tab.xhtml";
        }
        return this.currentSelectionLink;
    }

    public void setCurrentTabAction(Action currentTabAction) {
        this.webActions.setCurrentTabAction("DAM_VIEW_ASSET_ACTION_LIST", currentTabAction);
        this.currentSelectionLink = currentTabAction.getLink();
    }

    public String getDisplayMode() {
        return this.displayMode;
    }

    public void toggleDisplayMode() {
        this.displayMode = "view".equals(this.displayMode) ? "edit" : "view";
    }

    public void updateCurrentSelection() throws ClientException {
        if (this.currentSelection != null) {
            this.documentManager.saveDocument(this.currentSelection);
            this.documentManager.save();
            this.displayMode = "view";
        }
    }

    public String getTitleCropped(DocumentModel document, int maxLength) {
        int nbrEllipses = 3;
        int minLength = 5;
        String title = DocumentModelFunctions.titleOrId((DocumentModel)document);
        int length = title.length();
        if (length <= minLength) {
            return title;
        }
        if (maxLength <= minLength) {
            maxLength = minLength;
        }
        if (length <= maxLength) {
            return title;
        }
        int nbrBeginningChars = (maxLength - nbrEllipses) % 2 == 0 ? (maxLength - nbrEllipses) / 2 : (maxLength - nbrEllipses) / 2 + 1;
        String beginningChars = title.substring(0, nbrBeginningChars);
        int nbrEndChars = maxLength - nbrBeginningChars - nbrEllipses;
        String endChars = title.substring(length - nbrEndChars, length);
        return beginningChars + "..." + endChars;
    }

    public void download(DocumentView docView) throws ClientException {
        if (docView != null) {
            DocumentModel doc;
            DocumentLocation docLoc = docView.getDocumentLocation();
            if (this.documentManager == null) {
                RepositoryLocation loc = new RepositoryLocation(docLoc.getServerName());
                this.documentManager = this.getOrCreateDocumentManager(loc);
            }
            if ((doc = this.documentManager.getDocument(docLoc.getDocRef())) != null) {
                String filename = DocumentFileCodec.getFilename((DocumentModel)doc, (DocumentView)docView);
                FacesContext context = FacesContext.getCurrentInstance();
                DownloadHelper.download(context, doc, docView.getParameter("FILE_PROPERTY_PATH"), filename);
            }
        }
    }

    protected CoreSession getOrCreateDocumentManager(RepositoryLocation repositoryLocation) throws ClientException {
        if (this.documentManager != null) {
            return this.documentManager;
        }
        DocumentManagerBusinessDelegate documentManagerBD = (DocumentManagerBusinessDelegate)Contexts.lookupInStatefulContexts((String)"documentManager");
        if (documentManagerBD == null) {
            documentManagerBD = new DocumentManagerBusinessDelegate();
            this.conversationContext.set("documentManager", (Object)documentManagerBD);
        }
        this.documentManager = documentManagerBD.getDocumentManager(repositoryLocation);
        return this.documentManager;
    }

    public String downloadBlob() throws ClientException {
        if (this.currentSelection != null) {
            if (this.currentSelection.hasSchema("file")) {
                DocumentLocationImpl docLoc = new DocumentLocationImpl(this.currentSelection);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("FILE_PROPERTY_PATH", "file:content");
                Blob blob = ((BlobHolder)this.currentSelection.getAdapter(BlobHolder.class)).getBlob();
                params.put("FILENAME", blob.getFilename());
                DocumentViewImpl docView = new DocumentViewImpl((DocumentLocation)docLoc, null, params);
                this.download((DocumentView)docView);
            } else if (this.currentSelection.hasSchema("picture")) {
                PictureResourceAdapter pra = (PictureResourceAdapter)this.currentSelection.getAdapter(PictureResourceAdapter.class);
                String xpath = pra.getViewXPath(this.downloadSize);
                String filename = (String)((Object)this.currentSelection.getPropertyValue(xpath + "filename"));
                String blobXpath = xpath + "content";
                FacesContext context = FacesContext.getCurrentInstance();
                DownloadHelper.download(context, this.currentSelection, blobXpath, filename);
            }
        }
        return null;
    }

    private void resetData() {
        this.downloadSize = DEFAULT_PICTURE_DOWNLOAD_PROPERTY;
        ChainSelectCleaner.cleanup("navigation:assetView:nxl_dublincore:nxw_coverage_2:nxw_coverage_2_editselect");
        ChainSelectCleaner.cleanup("navigation:assetView:nxl_dublincore:nxw_subjects_2:nxw_subjects_2_editselect");
    }

    public String getDownloadSize() {
        return this.downloadSize;
    }

    public void setDownloadSize(String downloadSize) {
        this.downloadSize = downloadSize;
    }

    public void rewind(PagedDocumentsProvider provider) {
        provider.rewind();
        this.setCurrentSelectionBasedOnProvider(provider);
    }

    public void previous(PagedDocumentsProvider provider) {
        provider.previous();
        this.setCurrentSelectionBasedOnProvider(provider);
    }

    public void next(PagedDocumentsProvider provider) {
        provider.next();
        this.setCurrentSelectionBasedOnProvider(provider);
    }

    public void last(PagedDocumentsProvider provider) {
        provider.last();
        this.setCurrentSelectionBasedOnProvider(provider);
    }

    private void setCurrentSelectionBasedOnProvider(PagedDocumentsProvider provider) {
        DocumentModelList currentPage = provider.getCurrentPage();
        if (currentPage != null && !currentPage.isEmpty()) {
            this.currentSelection = (DocumentModel)currentPage.get(0);
            this.selectedAssetLogEntries = null;
        }
    }

    public static void raiseEvents(DocumentModel document) {
        Events eventManager = Events.instance();
        eventManager.raiseEvent("documentSelectionChanged", new Object[]{document});
    }

    public String getFullUserName() {
        String fullName = this.currentNuxeoPrincipal != null ? Functions.principalFullName((NuxeoPrincipal)this.currentNuxeoPrincipal) : Functions.principalFullName((NuxeoPrincipal)((NuxeoPrincipal)this.documentManager.getPrincipal()));
        return fullName;
    }

    public boolean canEditAsset() throws ClientException {
        return this.documentManager.hasPermission(this.currentSelection.getRef(), "Write");
    }

    public boolean isShowExifArea() {
        return this.showExifArea;
    }

    public void setShowExifArea(boolean showExifArea) {
        this.showExifArea = showExifArea;
    }

    public void toggleExifArea(ActionEvent event) {
        this.showExifArea = !this.showExifArea;
    }

    public boolean isShowIptcArea() {
        return this.showIptcArea;
    }

    public void setShowIptcArea(boolean showIptcArea) {
        this.showIptcArea = showIptcArea;
    }

    public void toggleIptcArea(ActionEvent event) {
        this.showIptcArea = !this.showIptcArea;
    }

    public List<LogEntry> getSelectedAssetLogEntries() throws AuditException {
        if (this.selectedAssetLogEntries == null) {
            this.selectedAssetLogEntries = this.contentHistoryActions.computeLogEntries(this.getCurrentSelection());
        }
        return this.selectedAssetLogEntries;
    }
}

