/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.dam.webapp.comment;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.faces.event.ActionEvent;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.nuxeo.dam.webapp.contentbrowser.DamDocumentActions;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.platform.comment.api.CommentableDocument;

@Name(value="commentActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
public class CommentActions
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(CommentActions.class);
    @In(create=true)
    private transient NuxeoPrincipal currentNuxeoPrincipal;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected transient DamDocumentActions damDocumentActions;
    protected String newContent;
    protected boolean showCreateForm;
    protected boolean showCommentsArea;
    protected CommentableDocument commentableDoc;
    protected List<DocumentModel> comments;

    public void addComment() throws ClientException {
        if (!StringUtils.isBlank((String)this.newContent)) {
            DocumentModel myComment = this.documentManager.createDocumentModel("Comment");
            myComment.setProperty("comment", "author", (Object)this.currentNuxeoPrincipal.getName());
            myComment.setProperty("comment", "text", (Object)this.newContent);
            myComment.setProperty("comment", "creationDate", (Object)Calendar.getInstance());
            myComment = this.addComment(myComment);
            this.showCreateForm = false;
            this.newContent = null;
            this.comments = null;
        }
    }

    protected DocumentModel initializeComment(DocumentModel comment) {
        if (comment != null) {
            try {
                if (comment.getProperty("dublincore", "contributors") == null) {
                    String[] contributors = new String[]{this.currentNuxeoPrincipal.getName()};
                    comment.setProperty("dublincore", "contributors", (Object)contributors);
                }
            }
            catch (ClientException e) {
                throw new ClientRuntimeException((Throwable)e);
            }
            try {
                if (comment.getProperty("dublincore", "created") == null) {
                    comment.setProperty("dublincore", "created", (Object)Calendar.getInstance());
                }
            }
            catch (ClientException e) {
                throw new ClientRuntimeException((Throwable)e);
            }
        }
        return comment;
    }

    public DocumentModel addComment(DocumentModel comment) throws ClientException {
        try {
            comment = this.initializeComment(comment);
            this.commentableDoc = this.getCommentableDoc();
            DocumentModel newComment = this.commentableDoc.addComment(comment);
            if ("comment_moderation".equals(newComment.getLifeCyclePolicy())) {
                new FollowTransitionUnrestricted(this.documentManager, newComment.getRef(), "moderation_publish").runUnrestricted();
            }
            return newComment;
        }
        catch (Throwable t) {
            log.error((Object)"failed to add comment", t);
            throw ClientException.wrap((Throwable)t);
        }
    }

    protected CommentableDocument getCommentableDoc() {
        DocumentModel currentDocument = this.damDocumentActions.getCurrentSelection();
        this.commentableDoc = (CommentableDocument)currentDocument.getAdapter(CommentableDocument.class);
        return this.commentableDoc;
    }

    public List<DocumentModel> getComments() throws ClientException {
        if (this.comments != null) {
            return this.comments;
        }
        this.commentableDoc = this.getCommentableDoc();
        if (this.commentableDoc != null) {
            this.comments = this.commentableDoc.getComments();
            return this.comments;
        }
        return new ArrayList<DocumentModel>();
    }

    public void deleteComment(DocumentModel comment) throws ClientException {
        if (comment == null) {
            log.error((Object)"No comment to delete");
            return;
        }
        try {
            this.commentableDoc = this.getCommentableDoc();
            if (this.commentableDoc != null) {
                this.commentableDoc.removeComment(comment);
            } else {
                log.error((Object)"No commentable document fetched.");
            }
        }
        catch (Throwable t) {
            log.error((Object)"failed to delete comment", t);
            throw ClientException.wrap((Throwable)t);
        }
        this.comments = null;
    }

    @Observer(value={"documentSelectionChanged"}, create=false)
    @BypassInterceptors
    public void cleanContextVariable() {
        this.showCreateForm = false;
        this.newContent = null;
        this.comments = null;
    }

    public String getNewContent() {
        return this.newContent;
    }

    public void setNewContent(String newContent) {
        this.newContent = newContent;
    }

    public boolean isShowCreateForm() {
        return this.showCreateForm;
    }

    public void setShowCreateForm(boolean showCreateForm) {
        this.showCreateForm = showCreateForm;
    }

    public void toggleCreateForm(ActionEvent event) {
        this.showCreateForm = !this.showCreateForm;
        this.showCommentsArea = true;
    }

    public boolean isShowCommentsArea() {
        return this.showCommentsArea;
    }

    public void setShowCommentsArea(boolean showCommentsArea) {
        this.showCommentsArea = showCommentsArea;
    }

    public void toggleCommentsArea(ActionEvent event) {
        boolean bl = this.showCommentsArea = !this.showCommentsArea;
        if (!this.showCommentsArea) {
            this.showCreateForm = false;
        }
    }

    public static class FollowTransitionUnrestricted
    extends UnrestrictedSessionRunner {
        public final DocumentRef docRef;
        public final String transition;

        public FollowTransitionUnrestricted(CoreSession session, DocumentRef docRef, String transition) {
            super(session);
            this.docRef = docRef;
            this.transition = transition;
        }

        public void run() throws ClientException {
            this.session.followTransition(this.docRef, this.transition);
            this.session.save();
        }
    }
}

