/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.dam.webapp;

import java.io.Serializable;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Context;
import org.jboss.seam.contexts.Contexts;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.platform.picture.api.adapters.PictureResourceAdapter;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.ecm.platform.util.RepositoryLocation;
import org.nuxeo.ecm.webapp.delegate.DocumentManagerBusinessDelegate;

@Scope(value=ScopeType.CONVERSATION)
@Name(value="pictureActions")
@Install(precedence=10)
public class PictureActions
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final long MAX_WIDTH_OR_HEIGHT = 384L;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In
    private transient Context conversationContext;

    public void downloadPicture(DocumentView docView) throws ClientException {
        if (docView != null) {
            DocumentModel doc;
            DocumentLocation docLoc = docView.getDocumentLocation();
            if (this.documentManager == null) {
                RepositoryLocation loc = new RepositoryLocation(docLoc.getServerName());
                this.documentManager = this.getOrCreateDocumentManager(loc);
            }
            if ((doc = this.documentManager.getDocument(docLoc.getDocRef())) != null) {
                String[] propertyPath = docView.getParameter("FILE_PROPERTY_PATH").split(":");
                String title = null;
                String field = null;
                Property datamodel = null;
                if (propertyPath.length == 2) {
                    title = propertyPath[0];
                    field = propertyPath[1];
                    datamodel = doc.getProperty("picture:views");
                } else if (propertyPath.length == 3) {
                    String schema = propertyPath[0];
                    title = propertyPath[1];
                    field = propertyPath[2];
                    datamodel = doc.getProperty(schema + ":" + "views");
                }
                Property view = null;
                for (Property property : datamodel) {
                    if (!property.get("title").getValue().equals(title)) continue;
                    view = property;
                }
                if (view == null) {
                    for (Property property : datamodel) {
                        if (!property.get("title").getValue().equals("Thumbnail")) continue;
                        view = property;
                    }
                }
                if (view == null) {
                    return;
                }
                Blob blob = (Blob)view.getValue(field);
                String filename = (String)((Object)view.getValue("filename"));
                FacesContext context = FacesContext.getCurrentInstance();
                ComponentUtils.download((FacesContext)context, (Blob)blob, (String)filename);
            }
        }
    }

    protected CoreSession getOrCreateDocumentManager(RepositoryLocation repositoryLocation) throws ClientException {
        if (this.documentManager != null) {
            return this.documentManager;
        }
        DocumentManagerBusinessDelegate documentManagerBD = (DocumentManagerBusinessDelegate)Contexts.lookupInStatefulContexts((String)"documentManager");
        if (documentManagerBD == null) {
            documentManagerBD = new DocumentManagerBusinessDelegate();
            this.conversationContext.set("documentManager", (Object)documentManagerBD);
        }
        this.documentManager = documentManagerBD.getDocumentManager(repositoryLocation);
        return this.documentManager;
    }

    public boolean isLandscape(DocumentModel doc) throws ClientException {
        long height;
        if (!doc.hasSchema("picture")) {
            return false;
        }
        PictureResourceAdapter picture = (PictureResourceAdapter)doc.getAdapter(PictureResourceAdapter.class);
        Map view = (Map)((Object)doc.getPropertyValue(picture.getViewXPath("Medium")));
        long width = (Long)view.get("width");
        return width > (height = ((Long)view.get("height")).longValue());
    }

    public long getMaxWidth(DocumentModel doc) throws ClientException {
        if (!doc.hasSchema("picture")) {
            return 384L;
        }
        PictureResourceAdapter picture = (PictureResourceAdapter)doc.getAdapter(PictureResourceAdapter.class);
        Map view = (Map)((Object)doc.getPropertyValue(picture.getViewXPath("Medium")));
        long width = (Long)view.get("width");
        return width > 384L ? 384L : 384L;
    }

    public long getMaxHeight(DocumentModel doc) throws ClientException {
        if (!doc.hasSchema("picture")) {
            return 384L;
        }
        PictureResourceAdapter picture = (PictureResourceAdapter)doc.getAdapter(PictureResourceAdapter.class);
        Map view = (Map)((Object)doc.getPropertyValue(picture.getViewXPath("Medium")));
        long height = (Long)view.get("height");
        return height > 384L ? 384L : height;
    }
}

