/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.preview.codec;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.common.utils.URIUtils;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.impl.DocumentLocationImpl;
import org.nuxeo.ecm.platform.url.DocumentViewImpl;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.ecm.platform.url.service.AbstractDocumentViewCodec;

public class DocumentPreviewCodec
extends AbstractDocumentViewCodec {
    public static final String PROPERTY_PATH_KEY = "PROPERTY_PATH_KEY";
    public static final String PREFIX = "restAPI/preview";
    public static final String URLPattern = "/(\\w+)/([a-zA-Z_0-9\\-]+)/([a-zA-Z_0-9:\\-\\.\\]\\[]*)/";

    public String getPrefix() {
        if (this.prefix != null) {
            return this.prefix;
        }
        return PREFIX;
    }

    public DocumentView getDocumentViewFromUrl(String url) {
        Pattern pattern = Pattern.compile(this.getPrefix() + URLPattern);
        Matcher m = pattern.matcher(url);
        if (m.matches()) {
            String server = m.group(1);
            String uuid = m.group(2);
            IdRef docRef = new IdRef(uuid);
            HashMap<String, String> params = new HashMap<String, String>();
            String property = m.group(3);
            params.put(PROPERTY_PATH_KEY, property);
            DocumentLocationImpl docLoc = new DocumentLocationImpl(server, (DocumentRef)docRef);
            DocumentViewImpl docView = new DocumentViewImpl((DocumentLocation)docLoc, null, params);
            return docView;
        }
        return null;
    }

    public String getUrlFromDocumentView(DocumentView docView) {
        DocumentLocation docLoc = docView.getDocumentLocation();
        String property = docView.getParameter(PROPERTY_PATH_KEY);
        if (docLoc != null) {
            ArrayList<String> items = new ArrayList<String>();
            items.add(this.getPrefix());
            items.add(docLoc.getServerName());
            items.add(docLoc.getDocRef().toString());
            items.add(property);
            String uri = StringUtils.join(items, (String)"/");
            uri = uri + '/';
            HashMap requestParams = new HashMap(docView.getParameters());
            requestParams.remove(PROPERTY_PATH_KEY);
            return URIUtils.addParametersToURIQuery((String)uri, requestParams);
        }
        return null;
    }
}

