/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.importer.source;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolderWithProperties;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.platform.importer.properties.IndividualMetadataCollector;
import org.nuxeo.ecm.platform.importer.source.FileSourceNode;
import org.nuxeo.ecm.platform.importer.source.SourceNode;

public class FileWithIndividualMetadasSourceNode
extends FileSourceNode {
    private static final Log log = LogFactory.getLog(FileWithIndividualMetadasSourceNode.class);
    public static final String PROPERTY_FILE_SUFIX = ".properties";
    protected static IndividualMetadataCollector collector = new IndividualMetadataCollector();

    public FileWithIndividualMetadasSourceNode(File file) {
        super(file);
    }

    public FileWithIndividualMetadasSourceNode(String path) {
        super(path);
    }

    @Override
    public BlobHolder getBlobHolder() {
        SimpleBlobHolderWithProperties bh = new SimpleBlobHolderWithProperties((Blob)new FileBlob(this.file), collector.getProperties(this.file));
        return bh;
    }

    public Map<String, Serializable> getMetadataForFolderishNode() {
        return collector.getProperties(this.file);
    }

    @Override
    public List<SourceNode> getChildren() {
        ArrayList<SourceNode> children = new ArrayList<SourceNode>();
        File[] listFiles = this.file.listFiles();
        log.trace((Object)("Element " + this.getSourcePath() + " has children" + listFiles.toString()));
        for (File child : listFiles) {
            if (this.isPropertyFile(child)) {
                try {
                    String propKey = this.getPropertyTargetKey(child, listFiles);
                    if (propKey == null) continue;
                    collector.addPropertyFile(child, propKey);
                }
                catch (Exception e) {
                    log.error((Object)"Error during properties parsing", (Throwable)e);
                }
                continue;
            }
            children.add(new FileWithIndividualMetadasSourceNode(child));
        }
        return children;
    }

    protected boolean isPropertyFile(File file) {
        return file.getName().contains(PROPERTY_FILE_SUFIX);
    }

    protected String getPropertyTargetKey(File propFile, File[] listFiles) {
        String fileName = propFile.getName();
        String absFileName = fileName.substring(0, fileName.lastIndexOf(PROPERTY_FILE_SUFIX));
        for (File file2 : listFiles) {
            if (!file2.isDirectory() || !file2.getName().equals(absFileName)) continue;
            return file2.getAbsolutePath();
        }
        for (File file2 : listFiles) {
            if (!file2.isFile() || this.isPropertyFile(file2) || !FileWithIndividualMetadasSourceNode.getFileNameNoExt(file2).equals(absFileName)) continue;
            return file2.getAbsolutePath();
        }
        return null;
    }

    public static String getFileNameNoExt(File file) {
        String name = file.getName();
        int p = name.lastIndexOf(46);
        if (p == -1) {
            return name;
        }
        return name.substring(0, p);
    }
}

