/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.importer.random;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.nuxeo.ecm.platform.importer.random.DictionaryHolder;
import org.nuxeo.ecm.platform.importer.random.FrenchDictionaryHolder;

public class RandomTextGenerator {
    protected DictionaryHolder dictionaryHolder = new FrenchDictionaryHolder();
    protected Map<String, String> paragraphCache = new HashMap<String, String>();
    protected Map<String, String> pageCache = new HashMap<String, String>();
    protected Map<String, String> blockCache = new HashMap<String, String>();
    protected static final int PARAGRAPH_CACHE_SIZE = 100;
    protected static final int PARAGRAPH_CACHE_HIT = 100;
    protected static final int PAGE_CACHE_SIZE = 50;
    protected static final int PAGE_CACHE_HIT = 30;
    protected static final int BLOC_CACHE_SIZE = 30;
    protected static final int BLOC_CACHE_HIT = 20;
    protected static final int BLOC_SIZE = 10240;
    protected static final int NB_WORDS_PER_LINE = 20;
    protected static final int NB_LINES_PER_PARAGRAPH = 40;
    protected static final int NB_PARAGRAPH_PER_PAGE = 8;
    protected static final int NB_PAGE_PER_BLOC = 3;
    protected Random generator = new Random(System.currentTimeMillis());

    protected int getTargetPageMaxSizeB() {
        return 4095;
    }

    protected int getTargetParagraphMaxSizeB() {
        return (int)(1.2 * (double)(this.getTargetPageMaxSizeB() / 8));
    }

    public String getRandomLine() {
        int nbW = 10 + this.generator.nextInt(20);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < nbW; ++i) {
            sb.append(this.dictionaryHolder.getRandomWord());
        }
        sb.append(".\n");
        return sb.toString();
    }

    public String generateParagraph() {
        int nbL = 10 + this.generator.nextInt(40);
        StringBuffer sb = new StringBuffer();
        int maxSize = this.getTargetParagraphMaxSizeB();
        for (int i = 0; i < nbL; ++i) {
            sb.append(this.getRandomLine());
            if (sb.length() > maxSize) break;
        }
        sb.append("\n\n");
        return sb.toString();
    }

    public void prefilCache() throws Exception {
        String page;
        int i;
        this.dictionaryHolder.init();
        for (i = 0; i < 100; ++i) {
            this.paragraphCache.put("P" + i, this.generateParagraph());
        }
        for (i = 0; i < 50; ++i) {
            page = this.generatePage();
            this.pageCache.put("P" + i, page);
        }
        for (i = 0; i < 30; ++i) {
            page = this.generateBloc();
            this.blockCache.put("B" + i, page);
        }
    }

    public String getRandomParagraph() {
        int rand = this.generator.nextInt();
        int idx = this.generator.nextInt(100);
        String paragraph = null;
        if (rand % 100 != 0) {
            paragraph = this.paragraphCache.get("P" + idx);
        }
        if (paragraph == null) {
            paragraph = this.generateParagraph();
            this.paragraphCache.put("P" + idx, paragraph);
        }
        return paragraph;
    }

    public String generatePage() {
        int nbL = this.generator.nextInt(8) + 1;
        StringBuffer sb = new StringBuffer();
        int maxTargetPageSize = this.getTargetPageMaxSizeB();
        for (int i = 0; i < nbL; ++i) {
            sb.append(this.getRandomParagraph());
            if (sb.length() > maxTargetPageSize) break;
        }
        sb.append("\n\n");
        return sb.toString();
    }

    public String getRandomPage() {
        int rand = this.generator.nextInt();
        int idx = this.generator.nextInt(50);
        String page = null;
        if (rand % 30 != 0) {
            page = this.pageCache.get("P" + idx);
        }
        if (page == null) {
            page = this.generatePage();
            this.pageCache.put("P" + idx, page);
        }
        return page;
    }

    public String generateBloc() {
        StringBuffer sb = new StringBuffer();
        while (sb.length() < 10240) {
            sb.append(this.getRandomPage());
        }
        return sb.toString();
    }

    public String getRandomBloc() {
        int rand = this.generator.nextInt();
        int idx = this.generator.nextInt(30);
        String bloc = null;
        if (rand % 20 != 0) {
            bloc = this.blockCache.get("B" + idx);
        }
        if (bloc == null) {
            bloc = this.generateBloc();
            this.blockCache.put("B" + idx, bloc);
        }
        return bloc;
    }

    public String getRandomText(int avSizeInK) {
        String p;
        StringBuffer sb = new StringBuffer();
        int minSize = (int)((double)(avSizeInK * 1024) * (0.8 + 0.4 * (double)this.generator.nextFloat()));
        while (sb.length() < minSize - 10240) {
            p = this.getRandomBloc();
            sb.append(p);
        }
        while (sb.length() < minSize) {
            p = this.getRandomPage();
            sb.append(p);
        }
        return sb.toString();
    }

    public String getRandomText() {
        int sizeK = this.generator.nextInt(500) + 1;
        return this.getRandomText(sizeK);
    }
}

