/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.importer.random;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.nuxeo.ecm.platform.importer.random.DictionaryHolder;

public class FrenchDictionaryHolder
implements DictionaryHolder {
    protected List<String> words = new LinkedList<String>();
    protected Random generator = new Random(System.currentTimeMillis());
    protected int wordCount;

    @Override
    public void init() throws Exception {
        this.loadDic("fr_FR.dic");
        this.wordCount = this.words.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadDic(String dicName) throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource(dicName);
        BufferedReader reader = null;
        try {
            String line;
            InputStream in = url.openStream();
            reader = new BufferedReader(new InputStreamReader(in));
            while ((line = reader.readLine()) != null) {
                int idx = line.indexOf("/");
                if (idx > 0) {
                    String word = line.substring(0, idx);
                    this.words.add(word + " ");
                    continue;
                }
                this.words.add(line + " ");
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
    }

    @Override
    public int getWordCount() {
        return this.wordCount;
    }

    @Override
    public String getRandomWord() {
        int idx = this.generator.nextInt(this.wordCount);
        return this.words.get(idx);
    }
}

