/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.image.java2d;

import it.tidalwave.image.op.OperationImplementation;
import it.tidalwave.image.op.WriteOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WriteJ2DOp
extends OperationImplementation<WriteOp, BufferedImage> {
    private static final String CLASS = WriteJ2DOp.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);

    @Override
    protected BufferedImage execute(WriteOp operation, BufferedImage bufferedImage) {
        String format = operation.getFormat();
        Class<?> output = operation.getOutput();
        Class<?> outputForLog = output instanceof OutputStream ? output.getClass() : output;
        logger.info("Write2DOp(" + format + ", " + outputForLog + ")");
        OutputStream os = null;
        boolean shouldClose = true;
        try {
            if (output instanceof OutputStream) {
                os = (OutputStream)((Object)output);
                shouldClose = false;
            } else if (output instanceof File) {
                os = new BufferedOutputStream(new FileOutputStream((File)((Object)output)));
                shouldClose = true;
            }
            ImageIO.write((RenderedImage)bufferedImage, format, os);
            BufferedImage bufferedImage2 = bufferedImage;
            return bufferedImage2;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (os != null && shouldClose) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    logger.throwing(CLASS, "execute()", e);
                }
            }
        }
    }
}

