/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.dam.core.listener;

import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;

public class ImageFilenameUpdater
implements EventListener {
    public static final String FILENAME = "filename";
    public static final String TITLE = "title";
    private static final Log log = LogFactory.getLog(ImageFilenameUpdater.class);

    public void handleEvent(Event event) throws ClientException {
        DocumentEventContext docCtx = null;
        if (!(event.getContext() instanceof DocumentEventContext)) {
            return;
        }
        docCtx = (DocumentEventContext)event.getContext();
        String eventId = event.getName();
        if (!eventId.equals("beforeDocumentModification")) {
            return;
        }
        DocumentModel doc = docCtx.getSourceDocument();
        if (!doc.hasSchema("picture")) {
            return;
        }
        Map pictureMap = doc.getDataModel("picture").getMap();
        List viewsList = (List)pictureMap.get("views");
        if (viewsList == null || viewsList.isEmpty()) {
            return;
        }
        String filenameUpdated = (String)((Map)viewsList.get(0)).get(FILENAME);
        boolean differenceFound = false;
        for (int i = 1; i < viewsList.size(); ++i) {
            if (filenameUpdated.equals(((Map)viewsList.get(i)).get(FILENAME))) continue;
            differenceFound = true;
            break;
        }
        if (!differenceFound) {
            return;
        }
        String title = (String)((Map)viewsList.get(0)).get(TITLE);
        for (Map view : viewsList) {
            view.put(FILENAME, filenameUpdated);
            Blob fileBlob = (Blob)view.get("content");
            fileBlob.setFilename(title + "_" + filenameUpdated);
        }
        doc.getDataModel("picture").setMap(pictureMap);
    }
}

