/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.dam;

import java.io.Serializable;
import org.nuxeo.common.utils.Path;
import org.nuxeo.dam.AssetLibrary;
import org.nuxeo.dam.DamService;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.platform.content.template.service.PostContentCreationHandler;
import org.nuxeo.runtime.api.Framework;

public class AssetLibraryHandler
implements PostContentCreationHandler {
    public static final String DC_TITLE = "dc:title";
    public static final String DC_DESCRIPTION = "dc:description";

    public void execute(CoreSession session) {
        try {
            PathRef docRef;
            DamService damService = (DamService)Framework.getLocalService(DamService.class);
            AssetLibrary assetLibrary = damService.getAssetLibrary();
            if (assetLibrary != null && !session.exists((DocumentRef)(docRef = new PathRef(assetLibrary.getPath())))) {
                Path path = new Path(assetLibrary.getPath());
                String parentPath = path.removeLastSegments(1).toString();
                String name = path.lastSegment();
                DocumentModel doc = session.createDocumentModel(parentPath, name, "ImportRoot");
                doc.setPropertyValue(DC_TITLE, (Serializable)((Object)assetLibrary.getTitle()));
                doc.setPropertyValue(DC_DESCRIPTION, (Serializable)((Object)assetLibrary.getDescription()));
                session.createDocument(doc);
            }
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }
}

