/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.dam.importer.core;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.dam.DamService;
import org.nuxeo.dam.importer.core.DamMultiThreadedImporter;
import org.nuxeo.dam.importer.core.filter.DamImporterFilter;
import org.nuxeo.dam.importer.core.filter.DamImportingDocumentFilter;
import org.nuxeo.ecm.platform.importer.base.ImporterRunner;
import org.nuxeo.ecm.platform.importer.base.ImporterRunnerConfiguration;
import org.nuxeo.ecm.platform.importer.executor.AbstractImporterExecutor;
import org.nuxeo.ecm.platform.importer.factories.FileManagerDocumentModelFactory;
import org.nuxeo.ecm.platform.importer.factories.ImporterDocumentModelFactory;
import org.nuxeo.ecm.platform.importer.filter.EventServiceConfiguratorFilter;
import org.nuxeo.ecm.platform.importer.filter.ImporterFilter;
import org.nuxeo.ecm.platform.importer.filter.ImportingDocumentFilter;
import org.nuxeo.ecm.platform.importer.source.FileWithMetadataSourceNode;
import org.nuxeo.ecm.platform.importer.source.SourceNode;
import org.nuxeo.runtime.api.Framework;

public class DamImporterExecutor
extends AbstractImporterExecutor {
    private static final Log log = LogFactory.getLog(DamImporterExecutor.class);
    protected String inputPath;
    protected String importFolderPath;
    protected String importSetTitle;
    protected boolean interactiveMode;
    protected boolean removeImportedFolder;

    public DamImporterExecutor(String inputPath, String importFolderPath, String importSetTitle, boolean interactiveMode, boolean removeImportedFolder) {
        this.inputPath = inputPath;
        this.importFolderPath = importFolderPath;
        this.importSetTitle = importSetTitle;
        this.interactiveMode = interactiveMode;
        this.removeImportedFolder = removeImportedFolder;
    }

    protected Log getJavaLogger() {
        return log;
    }

    public String run() throws Exception {
        File srcFile = new File(this.inputPath);
        FileWithMetadataSourceNode source = new FileWithMetadataSourceNode(srcFile);
        DamService damService = (DamService)Framework.getLocalService(DamService.class);
        ImporterRunnerConfiguration configuration = new ImporterRunnerConfiguration.Builder((SourceNode)source, damService.getAssetLibraryPath(), this.getLogger()).skipRootContainerCreation(Boolean.valueOf(true)).build();
        DamMultiThreadedImporter runner = DamMultiThreadedImporter.createWithImportFolderPath(configuration, this.importFolderPath, this.importSetTitle, this.removeImportedFolder);
        runner.setFactory((ImporterDocumentModelFactory)new FileManagerDocumentModelFactory());
        EventServiceConfiguratorFilter filter = new EventServiceConfiguratorFilter(Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true));
        runner.addFilter((ImporterFilter)filter);
        runner.addFilter(new DamImporterFilter());
        runner.addImportingDocumentFilters(new ImportingDocumentFilter[]{new DamImportingDocumentFilter()});
        return this.doRun((ImporterRunner)runner, this.interactiveMode);
    }
}

