/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.video.convert;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.impl.blob.StreamingBlob;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.cache.SimpleCachableBlobHolder;
import org.nuxeo.ecm.core.convert.extension.Converter;
import org.nuxeo.ecm.core.convert.extension.ConverterDescriptor;
import org.nuxeo.ecm.platform.commandline.executor.api.CmdParameters;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandLineExecutorService;
import org.nuxeo.ecm.platform.video.convert.BaseVideoConverter;
import org.nuxeo.runtime.api.Framework;

public class ScreenshotConverter
extends BaseVideoConverter
implements Converter {
    public static final Log log = LogFactory.getLog(ScreenshotConverter.class);
    public static final String FFMPEG_SCREENSHOT_COMMAND = "ffmpeg-screenshot";
    protected CommandLineExecutorService cleService;

    public void init(ConverterDescriptor descriptor) {
        try {
            this.cleService = (CommandLineExecutorService)Framework.getService(CommandLineExecutorService.class);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    public BlobHolder convert(BlobHolder blobHolder, Map<String, Serializable> parameters) throws ConversionException {
        SimpleCachableBlobHolder simpleCachableBlobHolder;
        File outFile = null;
        Blob blob = null;
        BaseVideoConverter.InputFile inputFile = null;
        try {
            blob = blobHolder.getBlob();
            inputFile = new BaseVideoConverter.InputFile(blob);
            outFile = File.createTempFile("ScreenshotConverter-out-", ".tmp.jpeg");
            CmdParameters params = new CmdParameters();
            params.addNamedParameter("inFilePath", ScreenshotConverter.quoteFilePath(inputFile.file.getAbsolutePath()));
            params.addNamedParameter("outFilePath", ScreenshotConverter.quoteFilePath(outFile.getAbsolutePath()));
            Double position = 0.0;
            if (parameters != null && (position = (Double)parameters.get("position")) == null) {
                position = 0.0;
            }
            long positionParam = Math.round(position);
            params.addNamedParameter("position", String.valueOf(positionParam));
            this.cleService.execCommand(FFMPEG_SCREENSHOT_COMMAND, params);
            Blob outBlob = StreamingBlob.createFromStream((InputStream)new FileInputStream(outFile), (String)"image/jpeg").persist();
            outBlob.setFilename(String.format("video-screenshot-%05d.000.jpeg", positionParam));
            simpleCachableBlobHolder = new SimpleCachableBlobHolder(outBlob);
        }
        catch (Exception e) {
            try {
                if (blob != null) {
                    throw new ConversionException("error extracting screenshot from '" + blob.getFilename() + "': " + e.getMessage(), e);
                }
                throw new ConversionException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                FileUtils.deleteQuietly(outFile);
                if (inputFile != null && inputFile.isTempFile) {
                    FileUtils.deleteQuietly((File)inputFile.file);
                }
                throw throwable;
            }
        }
        FileUtils.deleteQuietly((File)outFile);
        if (inputFile != null && inputFile.isTempFile) {
            FileUtils.deleteQuietly((File)inputFile.file);
        }
        return simpleCachableBlobHolder;
    }
}

